#!/bin/bash
# This is for Linux machines 

#coupled diffusion/elasticity model

#WARNING: this script is provided as a model; the user will need to change the paths as appropriate, whenever appropriate!

#this is the location of the main executable ForwardSolverDiffusion
export PATH=$PATH:../

echo $PATH

break


export SWITCH=../PostProcess/SwitchXYLinux 						#switch x and y in deformation field
export IMD=../PostProcess/ImageDisplacementLinux					#retrieve voxel displacement from FE calculations
export RD=../PostProcess/ResampleDeformationLinux					#resample total deformation field to original image size

export LRD=/sbia/home/ezachar/bin/LinuxReverseDeformationField_withMask 		#LinuxReverseDeformation
export LPDR=/sbia/home/ezachar/bin/LinuxPerformDeformationOnImgUsingVectorField		#LinuxPerformDeformation
#export LMH=/sbiasfw/lab/whammer-0_4/bin/LinuxmakeAVWHeader				#LinuxMakeHeader (for MIPAV, MRIcro, etc.)
export LMH=/sbiasfw/Linux-i686/Linux-i686/lab/hammersuite-0_1/bin/LinuxmakeAVWHeader
 
			
#on Olympus, need to set the PETSc environment first; here PETSc 2.2.1 !!
eval `/usr/local/bin/petsc_env 2.2.1`


# solve the tumor diffusion/elasticity model; options set in ForwardSolver.in; here
# (cinit,Dw,rho,p1) obtained from running optimization first

# note that the directory containing the executable ForwardSolverDiffusion *must* already be added to 
# the user's path in the .cshrc (profile) file!!
# also, the input file ForwardSolver.in must be created by the user in its current working directory

ForwardSolverDiffusion -gfileInput HC_seg_646464.img  -gcinit 1.633e-01  -gdiffwm 1.028e-07 -gdiffgm 0.2056e-07 -grho 7.750e-03  -gp1 2.000e+00 -ksp_monitor


# From here on, is all post-processing (after having run the diffusion/elasticity model)

# in case the output is saved only at the end (nstore=ntimesteps in ForwardSolver.in)
# then there is only one deformation field - named DeformationField.001.fld, which
# corresponds to the total (cumulative) displacement calculated automatically by the program
# ForwardSolverDiffusion and saved; *no need for concatenation here*!!

mv DeformationField.001.fld  TotalDeformation.fld
mv TumorDensity.001.fld  TumorHC.img  #64 64 64 float

# switch deformation field in DS convention, for the purpose of resampling: y,x,z; mine is x,y,z
${SWITCH} TotalDeformation.fld TotalDeformationDing.fld -d 65,65,65

# compute *physical* displacement per voxel from nodal displacement (linear interpolation)
${IMD} TotalDeformationDing.fld TotalDeformationDingImage.fld TotalDeformationDingImageV.fld -v 65,65,65
# output files in this case should be 64,64,64

# resample to original resolution  - here the *padded* image, from 124 to 128 in the z-direction 
${RD} TotalDeformationDingImageV.fld TotalDeformationDingImageV_phys.fld TotalDeformationDingImageVoxel.fld -v 64,64,64 -r 3.75,3.75,3.0 -o 256,256,128

# if xyz convention for vector fields, then switch back
${SWITCH} TotalDeformationDingImageVoxel.fld TotalDeformationImageVoxel.fld -d 256,256,128

# This part is  to deform the original 3D image using Dingang's tools 
# and create headers for visualization in MIPAV (or MRIcro); note that
# so far I've been resampling the tumor density field directly in MIPAV
# for visualization, to overlay the tumor maps on the correspondingly deformed image




${LRD} TotalDeformationDingImageVoxel.fld RevDefDing.fld  #reverse deformation

${LPDR} RevDefDing.fld testHC.img testHC_def.img #perform deformation

${LMH} testHC_def.hdr -d 256,256,128 -r 0.9375,0.9375,1.5 -t CHAR  #making header

#${LMH} TumorHC_64.hdr -d 64,64,64 -r 3.75,3.75,3.0 -t FLOAT
${LMH} TumorHC.hdr -d 64,64,64 -r 3.75,3.75,3.0 -t FLOAT

#remove the output files currently unused
#rm TotalDeformation.fld
rm TotalDeformationDing.fld
rm TotalDeformationDingImage.fld
rm TotalDeformationDingImageV.fld
rm TotalDeformationDingImageResampled.fld
rm TotalDeformationDingImageResampledVoxel.fld
rm TotalDeformationDingImageV_phys.fld
#rm RevDefDing.fld
rm Diffusivity.001.fld
rm Mu.001.fld
rm Lambda.001.fld
rm VelocityField.001.fld
#rm *.mhd 	 		# the .mhd files are headers for ParaView visualization, if of interest

 

