/*!
 * \file PCShellMain.h
 *
 * Copyright (c) 2011 University of Pennsylvania. All rights reserved.
 * See COPYING file or https://www.rad.upenn.edu/sbia/software/license.html.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#ifndef __PC_SHELL_MAIN_H
#define __PC_SHELL_MAIN_H

/* ********************************************************************** */
/* PC-Shell routines*/
/* ********************************************************************** */

// {void *pcShellStruct; } PCShellCtx;
#undef __FUNCT__
#define __FUNCT__ "CreatePCShellContext"
PetscErrorCode CreatePCShellContext(void** pcSh) {
    PetscInt       pcShellOpt =1;//pcShell option
    PCShellCtx 	*tmpPcSh;
    PetscFunctionBegin;
    iC(PetscNew(PCShellCtx,&tmpPcSh));
    iC(PetscOptionsGetInt(0,"-pcShell",&pcShellOpt,0));
    switch(pcShellOpt) {
        case 1: {
            iC(CreatePC1Context((PC1ShellCtx**)(&(tmpPcSh->pcShellStruct))));
            break;
        }
        case 2: {
            iC(CreatePC2Context((PC2ShellCtx**)(&(tmpPcSh->pcShellStruct))));
            break;
        }
        default: SETERRQ(PETSC_ERR_USER,"Check the option -pcShell!");
    }
    *pcSh = tmpPcSh;
    PetscFunctionReturn(0);
}
#undef __FUNCT__
#define __FUNCT__ "SetUpPCShell"
PetscErrorCode SetUpPCShell(void* pcSh,Mat B) {
    PetscInt       pcShellOpt =1;//pcShell option
    PetscFunctionBegin;
    iC(PetscOptionsGetInt(0,"-pcShell",&pcShellOpt,0));
    switch(pcShellOpt) {
        case 1: {
            iC(SetUpPC1((PC1ShellCtx*)(((PCShellCtx*)(pcSh))->pcShellStruct),B));
            break;
        }
        case 2: {
            iC(SetUpPC2((PC2ShellCtx*)(((PCShellCtx*)(pcSh))->pcShellStruct),B));
            break;
        }
        default: SETERRQ(PETSC_ERR_USER,"Check the option -pcShell!");
    }
    PetscFunctionReturn(0);
}

#undef __FUNCT__
#define __FUNCT__ "CreatePCShellContext"
PetscErrorCode ApplyPCShell(void* pcSh,Vec in,Vec out) {
    PetscInt       pcShellOpt =1;//pcShell option
    PetscFunctionBegin;
    iC(PetscOptionsGetInt(0,"-pcShell",&pcShellOpt,0));
    switch(pcShellOpt) {
        case 1: {
            iC(ApplyPC1((PC1ShellCtx*)(((PCShellCtx*)(pcSh))->pcShellStruct),in,out));
            break;
        }
        case 2: {
            iC(ApplyPC2((PC2ShellCtx*)(((PCShellCtx*)(pcSh))->pcShellStruct),in,out));
            break;
        }
        default: SETERRQ(PETSC_ERR_USER,"Check the option -pcShell!");
    }
    PetscFunctionReturn(0);
}
#undef __FUNCT__
#define __FUNCT__ "CreatePCShellContext"
PetscErrorCode DestroyPCShell(void* pcSh) {
    PetscInt       pcShellOpt =1;//pcShell option
    PetscFunctionBegin;
    iC(PetscOptionsGetInt(0,"-pcShell",&pcShellOpt,0));
    switch(pcShellOpt) {
        case 1: {
            iC(DestroyPC1((PC1ShellCtx*)(((PCShellCtx*)(pcSh))->pcShellStruct)));
            break;
        }
        case 2: {
            iC(DestroyPC2((PC2ShellCtx*)(((PCShellCtx*)(pcSh))->pcShellStruct)));
            break;
        }
        default: SETERRQ(PETSC_ERR_USER,"Check the option -pcShell!");
    }
    PetscFunctionReturn(0);
}

#endif
