/*!
 * \file pcShell2.h
 *
 * Copyright (c) 2011 University of Pennsylvania. All rights reserved.
 * See COPYING file or https://www.rad.upenn.edu/sbia/software/license.html.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#ifndef __PC_SHELL_2_H
#define __PC_SHELL_2_H

/*typedef struct{ Vec diag;} PC2ShellCtx;
 */
PetscErrorCode CreatePC2Context(PC2ShellCtx** pc2Sh){
    PC2ShellCtx *tmpPc2;
    PetscFunctionBegin;
    //printf("Inside CreatePC2Context.\n");
    iC(PetscNew(PC2ShellCtx,&tmpPc2));
    tmpPc2->diag =0;
    *pc2Sh = tmpPc2;
    //printf("Finished CreatePC2Context.\n");
    PetscFunctionReturn(0);
}
PetscErrorCode SetUpPC2(PC2ShellCtx* pc2Sh,Mat B ){
    Vec diag;
    int i,sizediag1,sizediag2;
    PetscReal *diagarray;
    PetscFunctionBegin;
    //printf("Inside SetUpPC2.\n");
    iC(MatGetVecs(B,&diag,0));
    iC(MatGetDiagonal(B,diag));
    //MatGetSize(B,&sizediag1,&sizediag2);
    VecGetSize(diag,&sizediag1);
    VecGetArray1d(diag,sizediag1,0, &diagarray);
    for (i=0;i<sizediag1;i++){if (fabs(diagarray[i])<=0.000001) {printf("Found zero on main diagonal sizediag=  i=  diagarray[i]=  %d %d %g\n",sizediag1,i,diagarray[i]);};}
    //if (sizediag1==3*9*9*9) {VecView(diag,0);}
    //printf("PC SIZEDIAG %d %d\n",sizediag1,sizediag2);
    iC(VecReciprocal(diag));
    pc2Sh->diag = diag;
    //printf("Finished SetUpPC2.\n");
    //if (sizediag1==3*17*17*17) {VecView(pc2Sh->diag,0);}
    PetscFunctionReturn(0);
}
PetscErrorCode ApplyPC2(PC2ShellCtx* pc2Sh,Vec in,Vec out){
    int size;
    PetscFunctionBegin;
    //printf("Inside ApplyPC2.\n");
    iC(VecPointwiseMult(in,pc2Sh->diag,out));
    VecGetSize(out,&size);
    //VecView(pc2Sh->diag,0);
    //printf("PC SIZE %d\n",size);
    //printf("Finished ApplyPC2.\n");
    PetscFunctionReturn(0);
}
PetscErrorCode DestroyPC2(PC2ShellCtx* pc2Sh){
    PetscFunctionBegin;
    //printf("Inside DestroyPC2.\n");
    if(pc2Sh->diag) {iC(VecDestroy(pc2Sh->diag));}
    iC(PetscFree(pc2Sh));
    //printf("Finished DestroyPC2.\n");
    PetscFunctionReturn(0);
}

#endif
