/*!
 * \file SwitchXY.c
 *
 * Copyright (c) 2011 University of Pennsylvania. All rights reserved.
 * See COPYING file or https://www.rad.upenn.edu/sbia/software/license.html.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#include <math.h>
#include <stdlib.h>
#include <stdio.h>

int nnc,nsd;
 
#undef __FUNCT__
#define __FUNCT__ "SwitchXY"

void show_usage() ;
 
  void SwitchXY(char InputDispFile[80], int xm, int ym, int zm, char OutputDispFile[80]){
  
  int i,j,k,ii,jj,knl;
  int knl1,knl2,knl3,knl4,knl5,knl6,knl7,knl8;
  int counti,countj,countk,ie,ic,ic1,ic2,ic3,ic4,ic5,ic6,ic7,ic8;
  FILE *fp;
  float tmp;
  float *disp_xyz, *disp_yxz;
  
  
  nnc=xm*ym*zm;
  nsd=3;
  
  disp_xyz=malloc(nnc*nsd*sizeof(float));
  disp_yxz=malloc(nnc*nsd*sizeof(float));//displacement field, written in the output file as *y,x*,z
  
  
 fp=fopen(InputDispFile,"rb"); //displacement field, written in the input file as x,y,z
 for(jj=0;jj<nnc;jj++) {
 	
  	for(ii=0; ii<3;ii++) {
  	
  		fread(&tmp, sizeof(float), 1, fp);
  		disp_xyz[jj*3+ii]=tmp;
  		
  	}
  		
  }
  		
  				
 fclose(fp); 

 counti = 1; countj = 1; countk = 1;
 
 fp=fopen(OutputDispFile,"wb");
 
 for (jj=0;jj<nnc;jj++){
 
        knl = jj * nsd;
        i = counti-1; j = countj-1; k = countk-1;
       
        
        disp_yxz[knl]= disp_xyz[knl+1];  //switch the x and y coordinates
        tmp=disp_yxz[knl];
        fwrite(&tmp, sizeof(float), 1, fp);
   	
  	disp_yxz[knl+1]= disp_xyz[knl];
  	tmp=disp_yxz[knl+1];
  	fwrite(&tmp, sizeof(float), 1, fp);
  	
  	disp_yxz[knl+2]= disp_xyz[knl+2];  //leave z coord. as it is    
  	tmp=disp_yxz[knl+2];
  	fwrite(&tmp, sizeof(float), 1, fp);
  	
 	

        counti++;
        if (counti==xm+1){ countj++; counti=1; }
        if (countj==ym+1){ counti=1; countj=1; countk++;}
 }
 
 
  fclose(fp);						
  	
  
  free(disp_xyz);
  free(disp_yxz);
 		
 
  
  } //end function SwitchXY
  
  
  main(int argc,char *argv[])
{
  int            c,num;
  extern char   *optarg;
  int xm,ym,zm;


  num=2;

  if(argc<num)
    show_usage() ;


  /*  input  size, defaults */
  xm= 256;
  ym= 256;
  zm= 124;
  
  
  while((c=getopt(argc-num,argv+num,"d:")) != -1)
    {
      switch(c)
	{
	case 'd':
	  sscanf(optarg, "%d,%d,%d",&xm, &ym, &zm ) ; /* size of input file, xyz */
	  break ;
	  
	default:
	  break;
	}
    }
    
    
    printf("size_x size_y size_z %d %d %d\n",xm,ym,zm);
     
  
  SwitchXY(argv[1], xm, ym, zm, argv[2]);


} //end main


void show_usage()
{
  printf("USAGE: ConcatenateDisplacements <input  Displacement File, float xyz>  <input  Displacement File, float yxz>\n\
\t -d <int,int,int>             : x,y,z input file size, default : 256,256,124  \n\
");
  exit(1);
}

  
