#!/bin/csh

#set PETSc libraries
eval `/usr/local/bin/petsc_env 2.2.1`

#set executable path for the main executable LmarkObjective 
setenv PATH ${PATH}:../


#if parallel execution (recomended for practical purposes) on Olympus cluster
#openmpi, with the compute nodes specified by the machinefile (can be manually edited, for convenience, to avoid overload/conflicts with other users)

#set the openmpi env
	setenv OPENMPI /usr/local/openmpi
	setenv MPI OPENMPI;
        setenv PATH "$OPENMPI/bin:$PATH";
        setenv LD_LIBRARY_PATH "$OPENMPI/lib:$LD_LIBRARY_PATH";
        setenv MANPATH "$OPENMPI/man:${MANPATH}";
	

buildmachines -n 60 -- -a 1.95> machinefile.tmp 


mpirun --prefix $OPENMPI -machinefile ./machinefile.tmp -np 60 /sbia/home/chogea/lib/appspack/src/appspack_mpi LmarkOpt.apps \
> ./DemoLogOptimizationHC_test.txt 

# if APPSPACK serial is to be used instead, then only the following is needed:
#/sbia/home/chogea/lib/appspack/src/appspack_serial LmarkOpt.apps \
#> ./DemoLogOptimizationHC_test.txt
# in this case, there is no need for generating machinefile or setting the mpi env. 


