/*!
 * \file ConcatenateDisplacments.c
 *
 * Copyright (c) 2011 University of Pennsylvania. All rights reserved.
 * See COPYING file or https://www.rad.upenn.edu/sbia/software/license.html.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

int nnc,ne,nsd;
 
#undef __FUNCT__
#define __FUNCT__ "ConcatenateDisplacements"

void show_usage() ;
 
  void ConcatenateDisplacements(char InputDispFile[80], int xm, int ym, int zm, float Hx, float Hy, float Hz, float *deflmark){
  
  int i,j,k,ii,jj,knl;
  int knl1,knl2,knl3,knl4,knl5,knl6,knl7,knl8;
  int counti,countj,countk,ie,ic,ic1,ic2,ic3,ic4,ic5,ic6,ic7,ic8;
  FILE *fp;
  float tmp;
  float wx,wy,wz; //weights for trilinear interpolation
  float *disp, *dispxlmark, *dispylmark, *dispzlmark;
  
  
  nnc=xm*ym*zm;
  nsd=3;
  ne=(xm-1)*(ym-1)*(zm-1);
  
  disp=malloc(nnc*nsd*sizeof(float));
  dispxlmark=malloc(nnc*sizeof(float));
  dispylmark=malloc(nnc*sizeof(float));
  dispzlmark=malloc(nnc*sizeof(float));
  
  
 fp=fopen(InputDispFile,"rb"); //displacement field, *physical* , written in the input file as x,y,z
 
 printf("%s\n", InputDispFile);
 
 for(jj=0;jj<nnc;jj++) {
 	
  	for(ii=0; ii<3;ii++) {
  	
  		fread(&tmp, sizeof(float), 1, fp);
  		disp[jj*3+ii]=tmp;
  		
  		//printf("jj ii disp %d %d %f\n",jj,ii,disp[jj*3+ii]);
  		
  	}
  		
  }
  
 fclose(fp);
  		
  				
  
 
  for(jj=0;jj<nnc;jj++) {
  
  	//printf("lmark %d\n",jj);
  
  	for(ii=0; ii<3;ii++) {
  	
  			if (ii==0){
  		
  			i=(int)(deflmark[jj*3+ii]/Hx);//left most corner x-index on the regular grid
  			wx=(deflmark[jj*3+ii]-i*Hx)/Hx;
  			
  			//printf("undeflmark wx %f %f\n",deflmark[jj*3+ii],wx);
  			
  			}else if (ii==1){
  		
  			j=(int)(deflmark[jj*3+ii]/Hy);
  			wy=(deflmark[jj*3+ii]-j*Hy)/Hy;
  			
  			//printf("undeflmark wy %f %f\n",deflmark[jj*3+ii],wy);
  			
  			}else if (ii==2){
  			
  			k=(int)(deflmark[jj*3+ii]/Hz);
  			wz=(deflmark[jj*3+ii]-k*Hz)/Hz;
  			
  			//printf("undeflmark wz %f %f\n",deflmark[jj*3+ii],wz);
  			
  			}
  			
  	}//end for ii=0,2
  	
  	if((i<xm-1) && (j<ym-1) && (k<zm-1)) {
  	
  			
  	ic=i+j*ym+k*xm*ym;
  	ic1=ic;
        ic2=ic1+1;
        ic3=ic+xm;
        ic4=ic3+1;
        
        ic5=ic+xm*ym;
        ic6=ic5+1;
        ic7=ic5+xm;
        ic8=ic7+1;  
        		
        knl1 = ic1 * nsd;
        knl2 = ic2 * nsd;
        knl3 = ic3 * nsd;
        knl4 = ic4 * nsd;
        knl5 = ic5 * nsd;
        knl6 = ic6 * nsd;
        knl7 = ic7 * nsd;
        knl8 = ic8 * nsd;
        
        
        //printf("knl1-8 %d %d %d %d %d %d %d %d\n",knl1,knl2,knl3,knl4,knl5,knl6,knl7,knl8);
        		
  wx=1.0-wx;
  wy=1.0-wy;
  wz=1.0-wz;     		      
       	
  dispxlmark[jj]=wz*(wy*(wx*disp[knl1]+(1.0-wx)*disp[knl2])+(1.0-wy)*(wx*disp[knl3]+(1.0-wx)*disp[knl4]))+(1.0-wz)*(wy*(wx*disp[knl5]+(1.0-wx)*disp[knl6])+(1.0-wy)*(wx*disp[knl7]+(1.0-wx)*disp[knl8]));
      	
  dispylmark[jj]=wz*(wy*(wx*disp[knl1+1]+(1.0-wx)*disp[knl2+1])+(1.0-wy)*(wx*disp[knl3+1]+(1.0-wx)*disp[knl4+1]))+(1.0-wz)*(wy*(wx*disp[knl5+1]+(1.0-wx)*disp[knl6+1])+(1.0-wy)*(wx*disp[knl7+1]+(1.0-wx)*disp[knl8+1]));
      	
  dispzlmark[jj]=wz*(wy*(wx*disp[knl1+2]+(1.0-wx)*disp[knl2+2])+(1.0-wy)*(wx*disp[knl3+2]+(1.0-wx)*disp[knl4+2]))+(1.0-wz)*(wy*(wx*disp[knl5+2]+(1.0-wx)*disp[knl6+2])+(1.0-wy)*(wx*disp[knl7+2]+(1.0-wx)*disp[knl8+2]));			   
      			   
  
  }//end if i,j,k   	
 

  } //end for jj=0,number of landmarks
  			

 counti = 1; countj = 1; countk = 1;
 
 for (jj=0;jj<nnc;jj++){
 
        knl = jj * nsd;
        i = counti-1; j = countj-1; k = countk-1;
        
        deflmark[knl]= deflmark[knl]+dispxlmark[jj];  
   	
  	deflmark[knl+1]= deflmark[knl+1]+dispylmark[jj];  
  	
  	deflmark[knl+2]= deflmark[knl+2]+dispzlmark[jj];  
  	
 	

        counti++;
        if (counti==xm+1){ countj++; counti=1; }
        if (countj==ym+1){ counti=1; countj=1; countk++;}
 }
 
	
  
  free(disp);
  free(dispxlmark);
  free(dispylmark);
  free(dispzlmark);		
 
  
  } //end function ConcatenateDisplacements
  
  
  main(int argc,char *argv[])
{
  int            c,num;
  FILE          *fp;
  extern char   *optarg;
 
  char 		fileOutput[256];
  
  int nbdispfiles,xm,ym,zm;
  float Hx,Hy,Hz,xcoord,ycoord,zcoord,tmpf;
  float  *deflmark;
  
  int jj, counti,countj,countk,i,j,k,knl;

  /*  input  size, defaults */
  nbdispfiles=1;
  
  xm= 256;
  ym= 256;
  zm= 124;
  
  Hx=0.9375;
  Hy=0.9375;
  Hz=1.5;
    
  
  nbdispfiles=atoi(argv[1]);
  
  num=nbdispfiles+1; 
	  
  
  while((c=getopt(argc-(num+1),argv+(num+1),"v:r:")) != -1)
    {
      switch(c)
	{
	case 'v':
	  sscanf(optarg, "%d,%d,%d", &xm, &ym, &zm ) ; /*  grid size, FEM calculations */
	  break ;
	  
	case 'r':
	  sscanf(optarg, "%f,%f,%f", &Hx, &Hy, &Hz ) ; /* grid size, FEM calculations */
	  break ;

	default:
	  break;
	}
    }
    
   
   printf("number of files size_x size_y size_z %d %d %d %d\n", nbdispfiles, xm, ym, zm);
   printf("Hx Hy Hz %f %f %f\n",Hx,Hy,Hz);
   
   
   if(argc<num)
    show_usage() ;
    
  nnc=xm*ym*zm;
  nsd=3;
  ne=(xm-1)*(ym-1)*(zm-1);
 
 deflmark=malloc(nnc*nsd*sizeof(float));
  
 counti = 1; countj = 1; countk = 1;
 
 for (jj=0;jj<nnc;jj++){
 
        knl = jj * nsd;
        i = counti-1; j = countj-1; k = countk-1;
        
        deflmark[knl] = i * Hx; //initial undeformed regular Cartesian grid used to solve the FEM problem
        deflmark[knl+1] = j * Hy;
        deflmark[knl+2]= k * Hz;
        
        //printf("jj x y z %d %f %f %f\n",jj,deflmark[knl],deflmark[knl+1],deflmark[knl+2]);
        
        counti++;
        if (counti==xm+1){ countj++; counti=1; }
        if (countj==ym+1){ counti=1; countj=1; countk++;}
 }
 
  for (c=2;c<=num;c++){ 
  
  	//printf("c %d\n",c);
  
  	ConcatenateDisplacements(argv[c], xm, ym, zm, Hx, Hy, Hz, deflmark);
  	
  }
  
 
 //write total displacement file
 strcpy(fileOutput, argv[num+1]);
 printf("%s\n", fileOutput);
 
 fp=fopen(fileOutput,"wb"); //write the concatenated dispacement in *float* format
 
 counti = 1; countj = 1; countk = 1;
 
 for (jj=0;jj<nnc;jj++){
 
        knl = jj * nsd;
        i = counti-1; j = countj-1; k = countk-1;
        
        xcoord = i * Hx;
        ycoord = j * Hy;
        zcoord = k * Hz;
          
  	tmpf=deflmark[knl]-xcoord;//always compute displacement with respect to the initial undeformed Cartesian grid
  	fwrite(&tmpf, sizeof(float), 1, fp);
  	 
  	tmpf=deflmark[knl+1]-ycoord;//always compute displacement with respect to the initial undeformed Cartesian grid
  	fwrite(&tmpf, sizeof(float), 1, fp);
  	
  	tmpf=deflmark[knl+2]-zcoord;//always compute displacement with respect to the initial undeformed Cartesian grid
  	fwrite(&tmpf, sizeof(float), 1, fp);
 	

        counti++;
        if (counti==xm+1){ countj++; counti=1; }
        if (countj==ym+1){ counti=1; countj=1; countk++;}
 }
 
 
  						
  fclose(fp);	
  	
  	  

  free(deflmark);
}


void show_usage()
{
  printf("USAGE: ConcatenateDisplacements <int total number of incremental displacement files to be concatenated > <input Incremental Displacement Files up to the current one, float xyz>  <output Total Current Displacement File, float xyz>\n\
\t <int>                         : total number of incremental displacement files to be concatenated; default: 1 \n\
\t -v <int,int,int,int>             : x,y,z number of regular Cartesian grid nodes in FEM calculations, default : 256,256,124  \n\
\t -r <float,float,float>       : x,y,z mesh size of regular Cartesian grid in FEM calculations, in mm , default : 0.9375,0.9375,1.5  \n\
");
  exit(1);
}

  
