/*!
 * \file ImageDisplacementPhys.c
 *
 * Copyright (c) 2011 University of Pennsylvania. All rights reserved.
 * See COPYING file or https://www.rad.upenn.edu/sbia/software/license.html.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <mvcd.h>    
#include <cres.h>
#include <matrixSHEN_1.h>
#include <unistd.h>

/* "/sbia/home/chogea/TC/Include/mvcd.h"
#include "/sbia/home/chogea/TC/Include/cres.h"
#include "/sbia/home/chogea/TC/Include/matrixSHEN_1.h"  */

#define YYES    1
#define NNO     0

/*this takes a nodal displacement field and computes the displacement per voxel in the physical space: 
displacement per voxel=1/8*sum(disp corners)*/
/*Note: this is in Dingang's convention: y,x,z, therefore if original field is written as
x,y,z , it must be switched before: use switchXY */

int getopt(int nargc, char * const *nargv, const char *ostr);


int nx, ny, nz; /*number of nodes in x,y,z direction*/
Fvector3d     ***Orig_DeformFld, ***Output_DeformFld, ***Output_DeformFld_Voxel;

void ShenMain(int argc,char *argv[]) ;
void show_usage_SHEN() ;


void WriteDeformationField(char filename[180], Fvector3d ***DeformFld, int nx, int ny, int nz)
{
  FILE  *fp;
  int   i, k ;

  /* write the smoothed image */
  fp=myopen(filename,"w");
  /*fwrite(&image_size,sizeof(int),1,fp);
    fwrite(&image_size_z,sizeof(int),1,fp);*/
  for(k=0;k<nz-1;k++)
    for(i=0;i<nx-1;i++)
      fwrite(DeformFld[k][i],sizeof(Fvector3d),ny-1,fp);
  fclose(fp);
}



void SampleDeformationField(char InputFile[80], Fvector3d ***Orig_DeformFld, int nx, int ny, int nz, char OutputFile1[80], char OutputFile2[80], Fvector3d ***Output_DeformFld, Fvector3d ***Output_DeformFld_Voxel)
{
  FILE  *fp;
  float ratio;
  int i,j,k;

  /* open nodal deformation field */
  fp=myopen(InputFile,"r");
    fseek(fp,0,SEEK_END);
    rewind(fp);

    printf("given: nx=%d ", nx) ;
    printf("given: ny=%d ", ny) ;
    printf("given: nz=%d\n", nz) ;


    /* vector field */ 
    Orig_DeformFld   = Fvector3dalloc3d(nx,ny,nz);
    Output_DeformFld = Fvector3dalloc3d(nx-1,ny-1,nz-1);
    Output_DeformFld_Voxel = Fvector3dalloc3d(nx-1,ny-1,nz-1);

    for(k=0;k<nz;k++)
      for(i=0;i<nx;i++) {
	fread(Orig_DeformFld[k][i],sizeof(Fvector3d),ny,fp);
 	 
	/*temporary clean the values on the walls,from catVF; manually set them to 0.0*/
	for(j=0;j<ny;j++)
		if(k==0 || k==1 || i==0 || i==1 || j==0 || j==1 || k==nz-2 || k==nz-1 || i==nx-2 || i==nx-1 || j==ny-2 || j==ny-1){
			Orig_DeformFld[k][i][j].x=0.0; Orig_DeformFld[k][i][j].y=0.0; Orig_DeformFld[k][i][j].z=0.0;
		}
      }
	
  fclose(fp);


  /* trilinear interpolation */

  ratio=1.0/8.0;


  for(k=0; k<nz-1; k++)
    for(i=0; i<nx-1; i++)
      for(j=0; j<ny-1; j++)
	{
	
// physical displacement per voxel

Output_DeformFld_Voxel[k][i][j].x = ratio*(Orig_DeformFld[k][i][j].x+Orig_DeformFld[k][i+1][j].x+Orig_DeformFld[k][i][j+1].x+Orig_DeformFld[k][i+1][j+1].x+Orig_DeformFld[k+1][i][j].x+Orig_DeformFld[k+1][i+1][j].x+Orig_DeformFld[k+1][i][j+1].x+Orig_DeformFld[k+1][i+1][j+1].x);

 //if (Orig_DeformFld[k][i][j].x>1.0 ) printf("k i j origdeformx outputdeformVx %d %d %d %g %g\n", k,i,j,Orig_DeformFld[k][i][j].x,Output_DeformFld_Voxel[k][i][j].x);


Output_DeformFld_Voxel[k][i][j].y = ratio*(Orig_DeformFld[k][i][j].y+Orig_DeformFld[k][i+1][j].y+Orig_DeformFld[k][i][j+1].y+Orig_DeformFld[k][i+1][j+1].y+Orig_DeformFld[k+1][i][j].y+Orig_DeformFld[k+1][i+1][j].y+Orig_DeformFld[k+1][i][j+1].y+Orig_DeformFld[k+1][i+1][j+1].y);

//printf("k i j origdeformy outputdeformVy %d %d %d %g %g\n", k,i,j,Orig_DeformFld[k][i][j].y,Output_DeformFld_Voxel[k][i][j].y); 


Output_DeformFld_Voxel[k][i][j].z = ratio*(Orig_DeformFld[k][i][j].z+Orig_DeformFld[k][i+1][j].z+Orig_DeformFld[k][i][j+1].z+Orig_DeformFld[k][i+1][j+1].z+Orig_DeformFld[k+1][i][j].z+Orig_DeformFld[k+1][i+1][j].z+Orig_DeformFld[k+1][i][j+1].z+Orig_DeformFld[k+1][i+1][j+1].z);

//printf("k i j origdeformz outputdeformVz %d %d %d %g %g\n", k,i,j,Orig_DeformFld[k][i][j].z,Output_DeformFld_Voxel[k][i][j].z); 

//if(Output_DeformFld_Voxel[k][i][j].x>1.0) printf("%d %d %d %g\n ",k,i,j,Output_DeformFld_Voxel[k][i][j].x);


// physical displacement per node, without the x=nx, y=ny, z=nz slices; further resampling purposes to deform the original fine image

Output_DeformFld[k][i][j].x =Orig_DeformFld[k][i][j].x; 
Output_DeformFld[k][i][j].y =Orig_DeformFld[k][i][j].y; 
Output_DeformFld[k][i][j].z =Orig_DeformFld[k][i][j].z; 


	}

  printf("done\n") ;
  WriteDeformationField(OutputFile1, Output_DeformFld, nx, ny, nz) ;
  WriteDeformationField(OutputFile2, Output_DeformFld_Voxel, nx, ny, nz) ;


  /* free */
  Fvector3dfree3d(Orig_DeformFld, nz,nx) ;
  Fvector3dfree3d(Output_DeformFld, nz-1, nx-1) ;
  Fvector3dfree3d(Output_DeformFld_Voxel, nz-1, nx-1) ;

}




main(int argc,char *argv[])
{
  ShenMain(argc,argv);    
}



/* the following is edited by SHEN */
void ShenMain(int argc,char *argv[])
{
  int           i,j,k,c,num;
  FILE          *fp;
  extern char   *optarg;

  Fvector3d     ***Output_DeformFld_Voxel2;


  num=3;

  if(argc<num)
    show_usage_SHEN() ;


  /*  input vector fields size */
  nx= 257;
  ny= 257;
  nz= 125 ;

  while((c=getopt(argc-3,argv+3,"v:")) != -1)
    {
      switch(c)
	{
	case 'v':
	  sscanf(optarg, "%d,%d,%d", &nx,&ny,&nz) ; /* original input vector field, nodal */
	  break ;

	default:
	  break;
	}
    }


  SampleDeformationField(argv[1], Orig_DeformFld, nx, ny, nz, argv[2],argv[3], Output_DeformFld, Output_DeformFld_Voxel);

 /* //test the output file here: open deformation field in the last resolution 

  fp=myopen(argv[3],"r");

    //vector field 
    Output_DeformFld_Voxel2 = Fvector3dalloc3d(nx-1,ny-1,nz-1);

    for(k=0;k<nz-1;k++)
      for(i=0;i<nx-1;i++) {
	fread(Output_DeformFld_Voxel2[k][i],sizeof(Fvector3d),ny-1,fp);

	for(j=0;j<ny-1;j++) 
		if(Output_DeformFld_Voxel2[k][i][j].x>1.0) printf("%d %d %d %g\n ",k,i, j, Output_DeformFld_Voxel2[k][i][j].x);

      }
  fclose(fp);*/

	
}


void show_usage_SHEN()
{
  printf("USAGE: ImageDisplacement <input VectorField>: nodal, DS convention (y,x,z) <output VectorField>: nodal, without the slices x=nx, y=ny, z=nz, DS convention (y,x,z)<output VectorFieldPhys>: physical voxel, DS convention (y,x,z)\n\
\t -v <int,int,int>             : nodal x,y,z size in input vector field, default : 257,257,125  \n\
");
  exit(1);
}
