package edu.jhu.pami.spring2009;

import Jama.Matrix;
import edu.jhu.bme.smile.commons.optimize.tensor.MLTensor;

public class Opt8DSimplex {

	/**
	 * Estimate tensor with 8D Downhill simplex method
	 * @param DWdata
	 * @param bvalues
	 * @param grads
	 * @param mask
	 * @return 4D volume of estimated tensors
	 */
	public static float[] estimate(Matrix imgMatrix, double b0, double sigma, double obsB0, double []obsDW, double []dInit) {

		//Initialize output
		float out[] = new float[6];
		double[] D = new double[6];

		//optimizer variables
		MLTensor tensor = new MLTensor();
		double totalLL = 0;
		double totalIter = 0;
		long totalTime = 0;


			boolean status = false;
			long time = System.currentTimeMillis();
			//TODO ?
			tensor.init(imgMatrix, b0, sigma, obsB0, obsDW, dInit);

			status = tensor.optimize8D(0);
			totalTime += (System.currentTimeMillis() - time);
			totalLL += tensor.LLvalue();
			totalIter += tensor.getIterations();


			D = tensor.getD().getColumnPackedCopy();


		for (int i=0; i<D.length; i++) out[i] = (float) D[i];
		return out;
	}


}
