package edu.jhu.pami.spring2009;

import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageData;

public class ProcessBrainData extends ProcessingAlgorithm {
	private ParamVolume volParam;
	protected ParamVolume resultVolParam;
	
	private static final String rcsid = 
		"$Id: ProcessBrainData.java,v 1.1 2009/06/27 02:56:53 jhuuser Exp $";
	private static final String cvsversion = 
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$","");

	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.setCategory("PAMI");
		inputParams.setPackage("Spring2009");
		inputParams.setName("Process Brain Data");
		inputParams.setLabel("Process Brain Data");
		
		inputParams.add(volParam=new ParamVolume("Volumes"));
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(resultVolParam=new ParamVolume("Result Volume",null,-1,-1,-1,-1));
	}

	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		ImageData resultVol=volParam.getObject();
		int rows=resultVol.getRows();
		int cols=resultVol.getCols();
		int slices=resultVol.getSlices();
		int comps=resultVol.getComponents();
		
		for (int i=0; i<rows; i++) {
			for (int j=0; j<cols; j++) {
				for (int k=0; k<slices; k++) {
					double s0 = resultVol.getDouble(i,j,k,0)+resultVol.getDouble(i,j,k,31);
					s0/=2;
					for (int l=0; l<comps; l++) {
						double s=0;
						if (s0!=0) s=resultVol.getDouble(i,j,k,l)/s0;
						resultVol.set(i,j,k,l,s);
					}
				}
			}
		}
		
//		ImageData inVol=volParam.getObject();
//		ImageData resultVol=new ImageDataFloat(151,173,1);
//		int rows=inVol.getRows();
//		int slices=inVol.getSlices();
//		System.out.println(rows+" "+slices);
//		System.out.flush();
//		int j=80;
//		for (int i=0; i<rows; i++) {
//			for (int k=0; k<slices; k++) {
//				resultVol.set(i,k,0,inVol.getDouble(i,j,k));
//			}
//		}
		
		resultVol.setName("brain_volume");
		resultVolParam.setValue(resultVol);
	}

}
