#include <iostream>
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkListSample.h"
#include "itkMembershipSample.h"
#include "itkVector.h"
#include "itkChangeLabelImageFilter.h"
#include "itkConnectedComponentImageFilter.h"
#include "itkLabelStatisticsImageFilter.h"
#include "itkStatisticsImageFilter.h"
#include "itkRelabelComponentImageFilter.h"
#include "itkCastImageFilter.h"
#include "itkPluginFilterWatcher.h"
#include "itkBinaryThresholdImageFilter.h"

#include "FilterLesionSizeCLP.h"

int main(int argc, char * argv [])
{
  PARSE_ARGS;
  
  bool violated=false;
  if (inputLesionVolume.size() == 0) { violated = true; std::cout << "  --inputLesion Required! "  << std::endl; }
  if (outputLabelVolume.size() == 0) { violated = true; std::cout << "  --outputLabel Required! "  << std::endl; }
  //if (minVolume.size() == 0) { violated = true; std::cout << "  --minVolume Required! "  << std::endl; }
  if (violated) exit(1);

  typedef signed short       PixelType;
  const unsigned int          Dimension = 3;

  typedef itk::Image< PixelType,  Dimension >   ImageType;
  typedef itk::Image< unsigned int,  Dimension >   IntImageType;
  typedef itk::ImageFileReader< ImageType  >  ReaderType;
  typedef itk::ImageFileWriter< ImageType >  WriterType;
  ReaderType::Pointer lesionReader = ReaderType::New();
  WriterType::Pointer writer = WriterType::New();

  lesionReader->SetFileName( inputLesionVolume.c_str() );
  writer->SetFileName (outputLabelVolume.c_str());
  
  itk::PluginFilterWatcher watchLesionReader(lesionReader,"ReadingLesionimage",CLPProcessInformation);

  typedef itk::BinaryThresholdImageFilter<ImageType,ImageType> BinaryThresholdType;
  BinaryThresholdType::Pointer binaryThreshold = BinaryThresholdType::New();

  typedef itk::ConnectedComponentImageFilter<ImageType, IntImageType> ConnectedFilterType;
  ConnectedFilterType::Pointer connectedComponent = ConnectedFilterType::New();
  
  itk::PluginFilterWatcher watchConnectedComponent(connectedComponent,"Finding Independent Lesion Clusters",CLPProcessInformation);

  typedef itk::RelabelComponentImageFilter<IntImageType, IntImageType> RelabelFilterType;
  RelabelFilterType::Pointer relabelComponent = RelabelFilterType::New();
  itk::PluginFilterWatcher watchRelabelComponent(relabelComponent,"Labeling Lesion Clusters",CLPProcessInformation);

  typedef itk::LabelStatisticsImageFilter< ImageType, IntImageType > LabelStatisticsFilterType;
  typedef LabelStatisticsFilterType::RealType StatisticRealType;
  LabelStatisticsFilterType::Pointer statsFilter = LabelStatisticsFilterType::New();
  itk::PluginFilterWatcher watchStatsFilter(statsFilter,"Calculating Statistics",CLPProcessInformation);

  try {  
    binaryThreshold->SetInput(lesionReader->GetOutput());
    binaryThreshold->SetLowerThreshold(lesionVoxelValue);
    binaryThreshold->SetUpperThreshold(lesionVoxelValue);
    binaryThreshold->SetOutsideValue(0);
    //connectedComponent->SetInput(lesionReader->GetOutput());
    connectedComponent->SetInput(binaryThreshold->GetOutput());
    relabelComponent->SetInput(connectedComponent->GetOutput());
    statsFilter->SetInput(lesionReader->GetOutput());
    statsFilter->SetLabelInput(relabelComponent->GetOutput());
    statsFilter->Update();
  }

  catch (itk::ExceptionObject &excep)
  {
    std::cerr << argv[0] << ": exception caught !" << std::endl;
    std::cerr << excep << std::endl;
    return EXIT_FAILURE;
  }

  typedef itk::ChangeLabelImageFilter< IntImageType, ImageType > ChangeLabelFilterType;
  ChangeLabelFilterType::Pointer changeLabelFilter = ChangeLabelFilterType::New();
  changeLabelFilter->SetInput(relabelComponent->GetOutput());

  unsigned long numLabels = statsFilter->GetNumberOfLabels();
  
  for(unsigned int i=1;i<numLabels;i++)
  {
    if(statsFilter->GetSum(i)<minVolume)
    {
      changeLabelFilter->SetChange(i,0);     
    }
    else
    {
      changeLabelFilter->SetChange(i,1);
    }
  }

//  typedef itk::CastImageFilter<IntImageType,ImageType> CastFilterType;
//  CastFilterType::Pointer castFilter = CastFilterType::New();

//  castFilter->SetInput(changeLabelFilter->GetOutput());

  itk::PluginFilterWatcher watchWriter(writer,"Writing Filtered Lesion Map",CLPProcessInformation);
  
  try {
    writer->SetInput(changeLabelFilter->GetOutput());
//    writer->SetInput(castFilter->GetOutput());
    writer->Update();
  }

  catch (itk::ExceptionObject &excep)
  {
    std::cerr << argv[0] << ": exception caught !" << std::endl;
    std::cerr << excep << std::endl;
    return EXIT_FAILURE;
  }

  return EXIT_SUCCESS;
}
