/*=========================================================================

Program:   Hierarchical Attribute Matching Mechanism for Elastic Registration 
Module:    $RCSfile: itkHammerTissueAttributeVector.h,v $
Language:  C++
Date:      $Date: 2009/01/13 20:19:20 $
Version:   $Revision: 1.4 $

Copyright (c) 

This program is developed under NIH NCBC collaboration grant
R01 EB006733, "Development and Dissemination of Robust Brain MRI
Measurement Tools". 

This software is distributed WITHOUT ANY WARRANTY; without even 
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#ifndef __itkHammerTissueAttributeVector_h
#define __itkHammerTissueAttributeVector_h

#include "itkHammerAttributeVectorBase.h"

namespace itk
{
/** \class HammerTissueAttributeVector
  * \brief Abstract base class for attribute vector used by Hammer
  *
  */
class ITK_EXPORT HammerTissueAttributeVector:
    public HammerAttributeVectorBase<unsigned char, 5 > 
{
public:

  typedef HammerTissueAttributeVector   Self;
  
  /** Length constant */
  unsigned int GetLength() const
  {
    return 5;
  }
  
  /** Dimension constant */
  unsigned int GetDimension() const
  {
    return 5;
  }
  
  /** define interface for computing similarity/difference between two
    * attribute vectors */
  virtual double ComputeSimilarity( Self & vec2, float EdgeThreshold, bool InSubvMatching)
  {
	  double  edge_diff;
	  if(InSubvMatching == false)
	  {
		  edge_diff = (float)(this->GetEdge() - vec2.GetEdge());
		  edge_diff = fabs(edge_diff);
		  if ( edge_diff>EdgeThreshold)
		  {
			  return 0;
		  }
		  else  
		  {
			  double sim = 1;
			  for (int k = 0; k < 5; k++)
			  {
				  sim *= (1.0-fabs(static_cast<double>(this->operator[](k))-static_cast<double>(vec2[k]))/255.0);
			  } 
			  return sim;
		  }
	  }
	  else
	  {
		  double sim = 1;
		  for (int k = 0; k < 5; k++)
		  {
			  sim *= (1.0-fabs(static_cast<double>(this->operator[](k))-static_cast<double>(vec2[k]))/255.0);
		  } 
		  return sim;
	  }
  }

  virtual double ComputeDifference( Self & vec2, float EdgeThreshold)
  {
    double diff = ComputeSimilarity( vec2, EdgeThreshold, false);
    if (diff == 0)
      {
      return -1;
      }
    else
      {
      return 1/diff;
      }
  }

  unsigned char GetEdge()
  {
    return this->operator[](0);
  }

  unsigned char GetTissueType()
  {
    return this->operator[](1);
  }

  unsigned char GetGeometry()
  {
    return this->operator[](2);
  }

  unsigned char GetVentricleVolume()
  {
    return this->operator[](3);
  }

  unsigned char GetCSFBackground()
  {
    return this->operator[](4);
  }

  virtual bool IsQualifiedDrivingVoxel( std::vector<float> & qualifier )
  {
    if (this->GetEdge() == 0)
      {
      return false;
      }

    if (this->GetGeometry() <= qualifier[0] 
        && (this->GetGeometry() >= qualifier[1] || this->GetGeometry() <= qualifier[2])&& this->GetVentricleVolume() <= qualifier[3] && this->GetCSFBackground() <= qualifier[5]) 
      {
      return false;
      }

    if (this->GetVentricleVolume() > qualifier[4])
      {
      return false;
      }

    return true;
  
  }

  virtual bool IsQualifiedDrivingVoxel_GR( std::vector<float> & qualifier )
  {
    if (this->GetEdge() == 0)
      {
      return false;
      }

	/*
	MdlImg[k][i][j].Edge!=0 && (MdlImg[k][i][j].Geom>MdlThreshold.Geom_UP || \
		(MdlImg[k][i][j].Geom<MdlThreshold.Geom_DN && MdlImg[k][i][j].Geom>Geom_DownsUp) || \
		MdlImg[k][i][j].VNvlm>MdlThreshold.VNvlm_UP ||\
		MdlImg[k][i][j].CSFBG>MdlThreshold.CSFBG_UP)
		*/
    if ((this->GetGeometry() > qualifier[0] 
        || (this->GetGeometry() < qualifier[1] && this->GetGeometry() > qualifier[2]) 
        || this->GetVentricleVolume() > qualifier[3] 
        || this->GetCSFBackground() > qualifier[5])&&this->GetVentricleVolume()<=qualifier[4]) 
      {
      return true;
      }
    else
      return false;
  }

  virtual bool IsQualifiedDrivingVoxel_GR_4I( std::vector<float> & qualifier )
  {

	  /*
	  Criteria[0] --> Variance_Up
	  Criteria[1] --> CannyEdge_Up
	  Criteria[2] --> cannyMinimalRequiredEdgeValue
	  */	  
	  if (this->GetEdge()>qualifier[0] || this->GetCSFBackground()>qualifier[1]) 
	  {
		  return true;
	  }
	  else
		  return false;
  }


  HammerTissueAttributeVector()
  {
  }

  ~HammerTissueAttributeVector()
  {
  }

  void PrintSelf(std::ostream& os, Indent indent) const
  {
  }

};


} // end namespace itk

#endif
