/******************************************************************************/
/*  Changed from Version 1.0                                                  */
/*  1. Subvolume matching is also added for subject driving voxels            */
/*      during correspondence detection.                                      */
/*  2. samll testing                                                          */
/*     (a) Binarize the tissue matching results  -> Good for Young Brain only */
/*     (b) The background effect in subvolume matching is also considered ->  */
/*                                                          NOT GOOD FOR ALL  */
/*  Search 'March ?? 2003' for these changes.                                 */
/******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string>
#include <vector>

#include "itkFixedArray.h"
#include "itkMatrix.h"
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkShrinkImageFilter.h"

#include "itkVector.h"
#include "../../../utilities/tclap/CmdLine.h"

#include "itkAttributeVectorImageFilter.h"

using namespace TCLAP;

#define X .525731112119133606
#define Z .850650808352039932
#define ADD     1
#define NOTADD  0
#define YYES    1
#define NNO     0
#define OOK     1
#define FFAIL   0
#define NEGINT    -1000
#define BOUNDERY  -10000

/* features for vertices */
#define BG    0            /* background */
#define CSF   10
#define VN    50
#define GM    150
#define WM    250
#define GMVN_EDGE     100   
#define GMCSFBG_EDGE  120  /* added on June 4, 2001*/
#define WMVN_EDGE     180
#define WMGM_EDGE     255

//typedef struct 
//{ 
//  unsigned char Edge; 
//  unsigned char Tiss; 
//  unsigned char Geom; 
//  unsigned char VNvlm; 
//  unsigned char CSFBG; 
//} ImgAttribute ; 

typedef itk::Vector<unsigned char, 5> ImgAttribute;

//typedef struct 
//{ 
//  unsigned char Geom_UP; 
//  unsigned char Geom_DN; 
//  unsigned char VNvlm_UP; 
//  unsigned char VNvlm_DN; 
//  unsigned char CSFBG_UP; 
//  unsigned char CSFBG_DN; 
//} Threshold ; 

typedef itk::Vector<unsigned char, 6> Threshold;

typedef float FloatType;

typedef itk::Vector<FloatType, 3>       ITKFvector3d;
typedef itk::Vector<int, 3>             Ivector3d;
typedef itk::Matrix<FloatType, 4, 4>    Matrix;
typedef itk::Image<unsigned char, 3>    ImageType;
typedef itk::Image<ITKFvector3d, 3>        DeformationFieldType;
typedef itk::Image<ImgAttribute, 3>     AttributeImageType;


//ITKFvector3d  *MdlVer;       /* focused edge points from MODEL image */
//Ivector3d  *FixedMdlVer;  /* focused edge points from MODEL image */ 
//Ivector3d  *ObjVer;       /* focused edge points from OBJECT image */ 

std::vector<ITKFvector3d>  MdlVer;       /* focused edge points from MODEL image */
std::vector<Ivector3d>  FixedMdlVer;  /* focused edge points from MODEL image */ 
std::vector<Ivector3d>  ObjVer;       /* focused edge points from OBJECT image */ 

ImgAttribute *MdlVer_Fea, *ObjVer_Fea ;
Threshold  MdlThreshold, ObjThreshold ;

int        MdlVer_Num ;   /* total number of the focused edge points */
int        SmoothingTimes ; /* for edge preserving smoothing */
int        ObjVer_Num ;   /* The number of focused edge points */


/* surface model, to be carved to the subject's space */
std::vector<ITKFvector3d>  SurfVer;
std::vector<ITKFvector3d>  SurfNorms;       /* focused edge points from OBJECT image */ 
int        SurfVer_Num, **SurfNbr, max_nbr=13 ;   /* The number of focused edge points */


/*int    FeaNUM=4 ;*/  /* the size of attributes in each voxel/vertex */
Matrix *Transform ;
float  XYZres ;

void show_usage_SHEN() ;
void AffinDeform3D(ITKFvector3d *MdlVer, Ivector3d *FixedMdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, ITKFvector3d ***DeformFld, ImgAttribute ***MdlImg, \
                   Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, \
                   int image_size, int z_size, int resolution) ;
void ShiftByGuassianWeight(ITKFvector3d In, ITKFvector3d *Tmp, ITKFvector3d Search, float level, int max) ;
void GlobalAffineUpdatePlusLocalDeformation( ITKFvector3d *verObject, ITKFvector3d *verModel, int MdlVer_Num ) ;
void SaveCurrentWarpingResultOnSegmentedObj( ImgAttribute ***ObjImg, ITKFvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder ) ;
void SaveCurrentWarpingResultOnOriginalObjImg( unsigned char ***ObjOriginalImg, ITKFvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder ) ;
void EstimatingScalingAndShiftOf3DSurfaceFromImg(ITKFvector3d *MdlVer, Ivector3d *FixedMdlVer, ImgAttribute *MdlVer_Fea, int MdlVer_Num, ITKFvector3d ***DeformFld, ImgAttribute ***ObjImg, int image_size, int z_size );
void SmoothDeformationField(ITKFvector3d ***DeformFld, int image_size, int z_size) ;

/* statistics */
void StatisticalMapping(ITKFvector3d *ver, int MdlVer_Num, float alpha) ;

/*  options */
static float Deform_RATE=0.04, Affine_Degree=0.2, Statistical_factor=0.1, MatchingDegreeOfMdlOnImgEdge=0.1, smoothFactor, ConfidenceOnLastDeformation=0.5 ;
static int   search_resolution, last_order, AddMthdOfAvoidingContraction=NOTADD, EstimateTransformOrNot=NOTADD, StatisticsEmployedOrNot=NOTADD, ObjectForce=YYES, YoungBrain=NNO, GlobalConstraint=YYES, WrongSegVNasGM ;

/* Dec 28, 1999 for adaptive-focus model */
int   image_size, z_size;

/* To stack the 3D landmarks as 1D. July 2000 */
std::vector<Ivector3d>    MyHood ;
std::vector<ITKFvector3d>    forceByFocusedPntInObj ;
int          MyHoodSize, pixelNumIn_MyHood ;
int          *multiple ;

void Select3DEdgePointsInObjectTO1D(int *ObjVer_Num, ImgAttribute ***ObjImg, int image_size, int z_size) ;
void Select3DEdgePointsInModelTO1D(int *MdlVer_Num, ImgAttribute ***MdlImg, ITKFvector3d ***DeformFld, int image_size, int z_size) ;
void SearchTheNearestVertexForEachLandmark( Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, \
					    ITKFvector3d *MdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, int image_size, int z_size ) ;

void SearchTheNearestVertexForEachLandmark_March2003(Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, \
                                                     ITKFvector3d *MdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Ivector3d *FixedMdlVer, ImgAttribute ***MdlImg, ITKFvector3d ***DeformFld,   int image_size, int z_size,  int max) ;



void WriteImg(char filename[180], unsigned char ***data, int image_size, int z_size);
void WriteImgAttribute(char filename[180], ImgAttribute ***Img, int image_size, int z_size);
void WriteDeformationField(char filename[180], ITKFvector3d ***DeformFld, int image_size, int z_size);
void OpenDeformationField(char filename[180], ITKFvector3d ***DeformFld, int image_size, int z_size);
void calculate_hood(ITKFvector3d **hood,int *nbr_size,float xres,float yres,float zres);
void calculate_hood_special(ITKFvector3d *bubble,int bubble_size, int *pixelNumInBubble, float xres,float yres,float zres);
void calculate_hood_byIncreasingRadius(Ivector3d *Hood, int HoodSize, int *pixelNumInHood, float xres,float yres,float zres);
void Get_WMedge_GmVnEdge_FromSegmentedImg(ImgAttribute ***Img);
void Compute_GeometricFeatures(ImgAttribute ***Img, int scale, float Xres, float Yres, float Zres);
int EvaluationOfRegistration( ImgAttribute ***MdlImg, ImgAttribute ***ObjImg, ITKFvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder ) ;
void ReadModelSurfVer(char SurfVerFileName[180], int *InputSurfVer);
void SaveDeformedModelSurfVer(ITKFvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder);
void show_usage_SHEN();
unsigned char InterpolatedIntensity(float ii, float jj, float kk, unsigned char ***Img, int image_size, int z_size);
void SaveCurrentWarpingResultOnSegmentedObj( ImgAttribute ***ObjImg, ITKFvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder ) ;
void SaveCurrentWarpingResultOnOriginalObjImg( unsigned char ***ObjOriginalImg, ITKFvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder );
float SimilarityBetweenFocusedPointsInMdlObjImgs( ImgAttribute *ObjVer_Fea, int l, ImgAttribute *MdlVer_Fea, int s);
float SimilarityBetweenFeaturesInImgAndFeaturesInMdl( ImgAttribute ***ObjImg, int x, int y, int z, ImgAttribute *MdlVer_Fea, int s);
float SimilarityBetweenFeaturesInMdlAndObjImgs( ImgAttribute ***ObjImg, int x, int y, int z, ImgAttribute ***MdlImg, int i, int j, int k );
void SmoothDeformationField(ITKFvector3d ***DeformFld, int image_size, int z_size);
void SmoothDeformationFieldWithEdgePreserving( Ivector3d *FixedMdlVer, int MdlVer_Num, ITKFvector3d ***DeformFld, ImgAttribute ***MdlImg, int image_size, int z_size, float ratio_iteration, int SmoothingTimes );
void AffinDeform3D(ITKFvector3d *MdlVer, Ivector3d *FixedMdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, ITKFvector3d ***DeformFld, ImgAttribute ***MdlImg, Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, int image_size, int z_size, int resolution) ;
void Select3DEdgePointsInModelTO1D(int *MdlVer_Num, ImgAttribute ***MdlImg, ITKFvector3d ***DeformFld, int image_size, int z_size);
void Select3DEdgePointsInObjectTO1D(int *ObjVer_Num, ImgAttribute ***ObjImg, int image_size, int z_size);
void SearchTheNearestVertexForEachLandmark_March2003(Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, ITKFvector3d *MdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Ivector3d *FixedMdlVer, ImgAttribute ***MdlImg, ITKFvector3d ***DeformFld,   int image_size, int z_size,  int max); 
void SearchTheNearestVertexForEachLandmark( Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ITKFvector3d *MdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, int image_size, int z_size );
void EstimatingScalingAndShiftOf3DSurfaceFromImg(ITKFvector3d *MdlVer, Ivector3d *FixedMdlVer, ImgAttribute *MdlVer_Fea, int MdlVer_Num, ITKFvector3d ***DeformFld, ImgAttribute ***ObjImg, int image_size, int z_size );
void GlobalAffineUpdatePlusLocalDeformation( ITKFvector3d *verObject, ITKFvector3d *verModel, int MdlVer_Num );
void ShiftByGuassianWeight(ITKFvector3d In, ITKFvector3d *Tmp, ITKFvector3d Search, float level, int max);
void AlignmentObjectToModel( ITKFvector3d *verMdl, ITKFvector3d *verObj, Matrix *tMdl2Obj, int MdlVer_Num ) ;
void AffineTransform3Dsurface( ITKFvector3d *ver, Matrix *tMdl2Obj, int  MdlVer_Num) ;
void Open_TrainingResults( Matrix *T1, Matrix *T2, float *T3, int SizeOfT3 ) ;
void Correct_3DsurfacebyT1T2T3(ITKFvector3d *ver, int MdlVer_Num, Matrix *T1, Matrix *T2, float  *T3, float alpha) ;
void StatisticalMapping(ITKFvector3d *ver,  int  MdlVer_Num, float alpha);
void Correct_3DsurfacebyT1T2T3(ITKFvector3d *ver, int MdlVer_Num, Matrix *T1, Matrix *T2, float  *T3, float alpha);
