// HE_ALG_Registration.h: interface for the HE_ALG_Registration class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HE_ALG_REGISTRATION_H__6D6050FE_647A_4EA1_9D55_9B16F57D4113__INCLUDED_)
#define AFX_HE_ALG_REGISTRATION_H__6D6050FE_647A_4EA1_9D55_9B16F57D4113__INCLUDED_

//#include "matrixSHEN.h"
#include "common.h"
#include <vnl/vnl_trace.h>
#include <vnl/algo/vnl_qr.h>
#include <vnl/algo/vnl_svd.h>
#include <vcl_iostream.h>
#include "Hammer_Def.h"


class HE_ALG_Registration  
{
public:
	void OpenDeformationField(char filename[180], Fvector3d ***DeformFld, int image_size, int z_size, HAMMER_Param *ptParm);
	void WriteDeformationField(char filename[180], Fvector3d ***DeformFld, int image_size, int z_size);
	void WriteImgAttribute(char filename[180], ImgAttribute ***Img, int image_size, int z_size);
	void WriteImg(char filename[180], unsigned char ***data, int image_size, int z_size);
	HE_ALG_Registration();
	virtual ~HE_ALG_Registration();
	bool ParseCommand(int argc, char *argv[], int MinParms);
	void PrintParms(HAMMER_Param *ptParm);
public:	
	void HierarchicalDeform3D_TPS_Regularization(Fvector3d *MdlVer, Ivector3d *FixedMdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Fvector3d ***DeformFld, ImgAttribute ***MdlImg, Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, int image_size, int z_size, int resolution, HAMMER_Param *ptParm);
	void GenerateBlockDeform(Fvector3d ***BlockDeformFld, vnl_matrix<double> FixedPoint, int BlockSize, int PointNum);
	double UpdateTPSParameter(vnl_matrix<double> FixedCord, vnl_matrix<double> MovingCord, double Lemda, double Lemda2);
	void PrepareTPSKernel(vnl_matrix<double> FixedPoint, vnl_matrix<double> MovingPoint, int PointNum);
	void GenerateDeformationbyTPS(Fvector3d ***PrevDeformFld, Fvector3d ***DeformFld, Fvector3d *DeformArray, Ivector3d *TemplateDrivingPoint, int Template_DrivingPixel_Num, int Image_X_Size, int Image_Y_Size, int Image_Z_Size, float Lemda, float Lemda2, TPSParm *ptParm);
    void PrintSubVolumnParm(SubVolumnParm *ptParm);
	void FindForceFromObject(Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, Fvector3d *MdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Ivector3d *FixedMdlVer, ImgAttribute ***MdlImg, Fvector3d ***DeformFld, int max, HAMMER_Param *ptHAMMER_Parm);
	void WarpSubVolume(Ivector3d *FixedMdlVer, Fvector3d ***DeformFld, Fvector3d Point_Deform, int Template_Driving_Point_Index, Ivector3d *SubVolumn, int SubVolumn_Num, int Gaussian_Sigma, SubVolumnParm *ptSubVolumn_Parm);
	void HierarchicalDeform3D(Fvector3d *MdlVer, Ivector3d *FixedMdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Fvector3d ***DeformFld, ImgAttribute ***MdlImg, Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, int image_size, int z_size, int resolution, HAMMER_Param *ptParm);
	void CorrespondenceDetection(ImgAttribute ***MdlImg, ImgAttribute ***ObjImg, ImgAttribute *MdlVer_Fea, ImgAttribute *ObjVer_Fea, Fvector3d ***DeformFld, Ivector3d Template_Driving_Point, int Driving_Point_Index, Fvector3d *Point_Deformation, Ivector3d *Search_Range, int Search_Neighbor_Size, SubVolumnParm *ptSubVolumn_Parm);
    void SoftCorrespondenceDetection(ImgAttribute ***MdlImg, ImgAttribute ***ObjImg, ImgAttribute *MdlVer_Fea, ImgAttribute *ObjVer_Fea, Fvector3d ***DeformFld, Ivector3d Template_Driving_Point, int Driving_Point_Index, Fvector3d *Point_Deformation, Ivector3d *Search_Range, int Search_Neighbor_Size, SubVolumnParm *ptSubVolumn_Parm);
	float SubVolumnMatching(ImgAttribute ***MdlImg, ImgAttribute ***ObjImg, Ivector3d Template_Driving_Point, Fvector3d Candidate, Ivector3d *SubVolumn_Searching_Neighbor, int Search_Neighbor_Size, Fvector3d ***DeformFld, float *Min_Dist, SubVolumnParm *ptSubVolumn_Parm);
	void DoMethod(); 
	void HAMMER_CORE(HAMMER_Param *ptParm);	
	float GuassianWeight(float level, float sigma);
	void ShiftByGuassianWeight(Fvector3d In, Fvector3d *Tmp, Fvector3d Search, float level, float sigma);
	void GlobalAffineUpdatePlusLocalDeformation( Fvector3d *verObject, Fvector3d *verModel, int MdlVer_Num );
	void SearchTheNearestVertexForEachLandmark_March2003(Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, Fvector3d *MdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Ivector3d *FixedMdlVer, ImgAttribute ***MdlImg, Fvector3d ***DeformFld,   int image_size, int z_size,  int max, HAMMER_Param *ptParm);
	void Select3DEdgePointsInObjectTO1D(int *ObjVer_Num, ImgAttribute ***ObjImg, int image_size, int z_size);
	void Select3DEdgePointsInModelTO1D(int *MdlVer_Num, ImgAttribute ***MdlImg, Fvector3d ***DeformFld, int image_size, int z_size);
	void AffineDeform3D(Fvector3d *MdlVer, Ivector3d *FixedMdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Fvector3d ***DeformFld, ImgAttribute ***MdlImg, Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, int image_size, int z_size, int resolution, HAMMER_Param *ptParm);
	void SmoothDeformationFieldWithEdgePreserving( Ivector3d *FixedMdlVer, int MdlVer_Num, Fvector3d ***DeformFld, ImgAttribute ***MdlImg, int image_size, int z_size, float ratio_iteration, HAMMER_Param *ptParm );
	void SmoothDeformationField(Fvector3d ***DeformFld, int image_size, int z_size,  ImgAttribute ***MdlImg, HAMMER_Param *ptParm);
	void SmoothDeformationField_FastImplementation(Fvector3d ***DeformFld, int image_size, int z_size);
	float SimilarityBetweenFeaturesInMdlAndObjImgs( ImgAttribute ***ObjImg, int x, int y, int z, ImgAttribute ***MdlImg, int i, int j, int k );
	float SimilarityBetweenFeaturesInImgAndFeaturesInMdl( ImgAttribute ***ObjImg, int x, int y, int z, ImgAttribute *MdlVer_Fea, int s);
	float SimilarityBetweenFocusedPointsInMdlObjImgs( ImgAttribute *ObjVer_Fea, int l, ImgAttribute *MdlVer_Fea, int s);
	void SaveCurrentWarpingResultOnOriginalObjImg( unsigned char ***ObjOriginalImg, Fvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder, HAMMER_Param *ptParm);
	void SaveCurrentWarpingResultOnSegmentedObj( ImgAttribute ***ObjImg, Fvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder, HAMMER_Param *ptParm);
	unsigned char InterpolatedIntensity(float ii, float jj, float kk, unsigned char ***Img, int image_size, int z_size);
	int EvaluationOfRegistration( ImgAttribute ***MdlImg, ImgAttribute ***ObjImg, Fvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder );
	void Compute_GeometricFeatures(ImgAttribute ***Img, int scale, float Xres, float Yres, float Zres);
	void Get_WMedge_GmVnEdge_FromSegmentedImg(ImgAttribute ***Img);
	void calculate_hood_byIncreasingRadius(Ivector3d *Hood, int HoodSize, int *pixelNumInHood, float xres,float yres,float zres);
	void calculate_hood_special(Fvector3d *bubble,int bubble_size, int *pixelNumInBubble, float xres,float yres,float zres);
	void calculate_hood(Fvector3d **hood,int *nbr_size,float xres,float yres,float zres);

	Ivector3d    *MyHood ;
	int     MyHoodSize, pixelNumIn_MyHood, Orig_pixelNumIn_MyHood ;
	//int		OverSmoothTimes; /* smoothing times, making deformation field oversmooth June 22 2004 */
	int		image_size, z_size;
	float   SMR_THR;  /* 0.8 */
	int		m_STEPNBR;  //=12 ;        /* 6 (May2001), 8 10*/
	float	Statistical_factor;
	int		AddMthdOfAvoidingContraction, StatisticsEmployedOrNot;
	int		Start_Search_Point;
	float	ratio_iteration;
	Fvector3d  *MdlVer;       /* focused edge points from MODEL image */
	Ivector3d  *FixedMdlVer;  /* focused edge points from MODEL image */ 
	int        MdlVer_Num ;   /* total number of the focused edge points */
	Ivector3d  *ObjVer;       /* focused edge points from OBJECT image */ 
	int		ObjVer_Num ;   /* The number of focused edge points */
	ImgAttribute	*MdlVer_Fea, *ObjVer_Fea ;
	Threshold	MdlThreshold, ObjThreshold ;
	Fvector3d	*forceByFocusedPntInObj ;
	float		*multiple ;
	Matrix *Transform ;
	float GuassianAtLevelSigma[MAX_SIGMA][MAX_LEVEL] ;
 	int   regist_CompGuassianOnce;
	int		InputSurfVer;
	int		Img_Z ;
	vnl_matrix<double> TPS_Psi, TPS_Kernel, TPS_Param, TPS_Affine;
	vnl_matrix<double> FixedCord, MovingCord, PrevFixedCord, PrevMovingCord;
	vnl_matrix<double> Q1, Q2, R, inverse_R;

private:
	//parameters in parm file
    //HAMMER_Param m_Running_Parameter;
    HAMMER_Param *p_Running_Parameter;
};

#endif // !defined(AFX_HE_ALG_REGISTRATION_H__6D6050FE_647A_4EA1_9D55_9B16F57D4113__INCLUDED_)
