#include "common.h"


void NormalizeVector(float *kern, int kern_size)
{
	int i;
	float sum = 0;
	for (i = 0; i < kern_size; i++)
		sum += kern[i];
	for ( i = 0; i < kern_size; i++)
		kern[i] /= sum;
}

void NormalizeFImg(float ***Img, int x_size, int y_size, int z_size)
{
  int i, j, k;
  float f_min, f_max;
  
  f_min=_FMAX;  f_max=_FMIN;
  for(k=0;k<z_size;k++)
    for(i=0;i<x_size;i++)
      for(j=0;j<y_size;j++)
	{
	  if(Img[k][i][j]>f_max)
	    f_max=Img[k][i][j];
	  if(Img[k][i][j]<f_min)
	    f_min=Img[k][i][j];
	}
  float ftemp=f_max-f_min;
  printf("maximum=%f   minimum=%f   span=%f\n", f_max,  f_min, ftemp);
  float before;
  
  
  for(k=0;k<z_size;k++)
    for(i=0;i<x_size;i++)
      for(j=0;j<y_size;j++)
	{
	  Img[k][i][j]=(Img[k][i][j]-f_min)/ftemp;
	}
}

void ReadUCImg(char *filename, unsigned char ***Img, int x_size, int y_size, int z_size)
{
  FILE *fp;
  int i, j, k;
#ifdef HAMMER_WIN32
  fp = myopen(filename, "rb");
#else
  fp=myopen(filename, "r");
#endif
  for(k=0;k<z_size;k++)
    for(i=0;i<y_size;i++)
      fread(Img[k][i], 1, x_size, fp);
  fclose(fp);
}

void UCImg2FImg(unsigned char ***UCImg, float ***FImg,int x_size, int y_size, int z_size, int need_normalize)
{
  int i, j, k;
  for(k=0;k<z_size;k++)
    for(i=0;i<x_size;i++)
      for(j=0;j<y_size;j++)
	{
	  FImg[k][i][j]=(float)UCImg[k][i][j];
	  /*
	  if(UCImg[k][i][j]==0)
	    continue;
	  printf("FImg %f  UCImg %d\n", FImg[k][i][j], UCImg[k][i][j]);
	  */
	}
  if(need_normalize==1)
    NormalizeFImg(FImg,x_size, y_size, z_size);
}

void FImg2UCImg(float ***FImg, unsigned char ***UCImg, int x_size, int y_size, int z_size, int need_normalize)
{
  int k,i,j;
  unsigned char c;
  for(k=0;k<z_size;k++)
    for(i=0;i<x_size;i++)
      for(j=0;j<y_size;j++)
	{
	  if(need_normalize==1)
	    c=(unsigned char)(FImg[k][i][j]*255.0);
	  else
	    c=(unsigned char)(FImg[k][i][j]);
	  /*
	  if(FImg[k][i][j]>0)
	    printf("FImg %f  UCImg %d\n", FImg[k][i][j], c);
	  */
	  if(c>255)
	    c=255;
	  if(c<0)
	    c=0;
	  UCImg[k][i][j]=c;
	}
}

void WriteUCImg(char *filename, unsigned char ***Img, int x_size, int y_size, int z_size)
{
  FILE *fp;
  int i,j,k;
#ifdef HAMMER_WIN32
  fp=myopen(filename, "wb");
#else
  fp = myopen(filename, "w");
#endif
  for(k=0;k<z_size;k++)
    for(i=0;i<y_size;i++)
      fwrite(Img[k][i], 1, x_size, fp);
  fclose(fp);
}

void ReadFloatImg(char *filename, float ***Img, int x_size, int y_size, int z_size)
{
  int i, j, k;
  FILE *fp;
#ifdef HAMMER_WIN32
  fp=myopen(filename, "rb");
#else
  fp=myopen(filename, "r");
#endif
  for(k=0;k<z_size;k++)
    for(i=0;i<y_size;i++)
      fread(Img[k][i], sizeof(float), x_size, fp);
  fclose(fp);
}

void WriteFloatImg(char *filename, float ***Img, int x_size, int y_size, int z_size)
{
  int i,j,k;
  FILE *fp;
#ifdef HAMMER_WIN32
  fp=myopen(filename, "wb");
#else
  fp=myopen(filename, "w");
#endif
  for(k=0;k<z_size;k++)
    for(i=0;i<y_size;i++)
      fwrite(Img[k][i], sizeof(float), x_size, fp);
  fclose(fp);
}

void ReadIntImg(char *filename, int ***Img, int x_size, int y_size, int z_size)
{
	int i, j, k;
	FILE *fp;
#ifdef HAMMER_WIN32
	fp=myopen(filename, "rb");
#else
	fp = myopen(filename, "r");
#endif
	for(k=0;k<z_size;k++)
		for(i=0;i<y_size;i++)
			fread(Img[k][i], sizeof(int), x_size, fp);
		fclose(fp);
}

void WriteIntImg(char *filename, int ***Img, int x_size, int y_size, int z_size)
{
	int i,j,k;
	FILE *fp;
#ifdef HAMMER_WIN32
	fp=myopen(filename, "wb");
#else
	fp = myopen(filename, "w");
#endif
	for(k=0;k<z_size;k++)
		for(i=0;i<y_size;i++)
			fwrite(Img[k][i], sizeof(int), x_size, fp);
		fclose(fp);
}

void ReadDeformationField(char *filename, Fvector3d ***Deform, int x_size, int y_size, int z_size, bool HasHeadInfo)
{
	FILE *fp;
	int i, j, k;
	int image_size, image_z_size;
#ifdef HAMMER_WIN32
	fp=myopen(filename, "rb");
#else
	fp = myopen(filename, "r");
#endif
	if(HasHeadInfo==true)
	{
		fread(&image_size,sizeof(int),1,fp); 
		printf("image_size=%d ", image_size) ;
		fread(&image_z_size,sizeof(int),1,fp); 
		printf("z_size=%d\n", image_z_size) ;
	}
	for(k=0;k<z_size;k++)
		for(i=0;i<y_size;i++)
			fread(Deform[k][i], sizeof(Fvector3d), x_size, fp);
	fclose(fp);
}

void WriteDeformationField(char *filename, Fvector3d ***Deform, int x_size, int y_size, int z_size, bool HasHeadInfo)
{
	int i, j, k;
	FILE *fp;
#ifdef HAMMER_WIN32
	fp=myopen(filename, "wb");
#else
	fp = myopen(filename, "w");
#endif
	if(HasHeadInfo == true)
	{
		fwrite(&y_size, sizeof(int), 1, fp);
		fwrite(&z_size, sizeof(int), 1, fp);
	}
	for(k=0;k<z_size;k++)
		for(i=0;i<y_size;i++)
			fwrite(Deform[k][i], sizeof(Fvector3d), x_size, fp);
	fclose(fp);
}

unsigned char InterpolatedIntensity(float ii, float jj, float kk, unsigned char ***Img, int y_size, int x_size, int z_size)
{
	float CurrentV ;
	float b,c,d, b1,c1,d1;
	int   ni,nj,nk, niP1,njP1,nkP1, GreyValue ;
	
	GreyValue = 0;
	ni = (int)ii ;
	nj = (int)jj ;
	nk = (int)kk ;
	
	niP1 = ni+1 ;
	njP1 = nj+1 ;
	nkP1 = nk+1 ;
	
	if(ni>=0 && ni<y_size-1  &&  nj>=0 && nj<x_size-1  &&  nk>=0 && nk<z_size-1 )
    {
		b = ii-ni ;        b1 = 1.-b ;
		c = jj-nj ;        c1 = 1.-c ;
		d = kk-nk ;        d1 = 1.-d ;
		
		CurrentV = ( d1*(Img[nk][ni][nj]*(b1*c1) + Img[nk][niP1][nj]*(b*c1) + Img[nk][ni][njP1]*(b1*c) + Img[nk][niP1][njP1]*(b*c)) + d*(Img[nkP1][ni][nj]*(b1*c1) + Img[nkP1][niP1][nj]*(b*c1) + Img[nkP1][ni][njP1]*(b1*c) + Img[nkP1][niP1][njP1]*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 
		
		if( CurrentV>255 )
			GreyValue = 255 ;
		else
			GreyValue = CurrentV ;
    }
	
	if(ni==y_size-1 && nj>=0 && nj<x_size-1 && nk>=0 && nk<z_size-1 || ni>=0 && ni<y_size-1 && nj==x_size-1 && nk>=0 && nk<z_size-1  || ni>=0 && ni<y_size-1 && nj>=0 && nj<x_size-1 && nk==z_size-1)
		GreyValue = Img[nk][ni][nj] ;
	
	return GreyValue ;
}

void WarpIntensityImage(unsigned char ***OriginalImage, unsigned char ***WarpedImage, Fvector3d ***Deform, int x_size, int y_size, int z_size)
{
	int i, j, k;
	float  ii, jj, kk ;

	for(k=0; k<z_size; k++)
		for(i=0; i<y_size; i++)
			for(j=0; j<x_size; j++)
			{
				ii = i + Deform[k][i][j].x ;
				jj = j + Deform[k][i][j].y ;
				kk = k + Deform[k][i][j].z ;				
				WarpedImage[k][i][j] = InterpolatedIntensity(ii, jj, kk, OriginalImage, y_size, x_size, z_size) ;			
			}
} 

void EnlargeImage(char *InputFile, char *OutputFile, int input_X, int input_Y, int input_Z, int output_X, int output_Y, int output_Z)
{
	unsigned char ***InputImg, ***OutputImg;
	int k,i,j;
	InputImg = UCalloc3d(input_Y, input_X, input_Z);
	OutputImg = UCalloc3d(output_Y, output_X, output_Z);

	printf("Read...");
	ReadUCImg(InputFile, InputImg, input_X, input_Y, input_Z);
	printf("Enlarging...");
	for(k=0;k<output_Z;k++)
		for(i=0;i<output_Y;i++)
			for(j=0;j<output_X;j++)
				OutputImg[k][i][j] = 0;
	for(k=0;k<input_Z;k++)
		for(i=0;i<input_Y;i++)
			for(j=0;j<input_X;j++)
				OutputImg[k][i][j] = InputImg[k][i][j];
	printf("Writing...");
	WriteUCImg(OutputFile, OutputImg, output_X, output_Y, output_Z);

	UCfree3d(InputImg, input_Z, input_Y);
	UCfree3d(OutputImg, output_Z, output_Y);
}

void ConvertUCImg2FImg(char *UC_Img_FileName, char *F_Img_FileName, int x_size, int y_size, int z_size)
{
	int i,j,k;
	unsigned char ***UCImg;
	float ***FImg;
	UCImg = UCalloc3d(x_size, y_size, z_size);
	FImg = Falloc3d(x_size, y_size, z_size);
	ReadUCImg(UC_Img_FileName, UCImg, x_size, y_size, z_size);
	for(k=0;k<z_size;k++)
		for(i=0;i<y_size;i++)
			for(j=0;j<x_size;j++)
			{
				FImg[k][i][j] = (float)UCImg[k][i][j];
			}
	WriteFloatImg(F_Img_FileName, FImg, x_size, y_size, z_size);
	UCfree3d(UCImg, z_size, x_size);
	Ffree3d(FImg, z_size, x_size);
}

void ConvertFImg2UCImg(char *F_Img_FileName, char *UC_Img_FileName, int x_size, int y_size, int z_size)
{
	int i,j,k;
	unsigned char ***UCImg;
	float ***FImg;
	UCImg = UCalloc3d(x_size, y_size, z_size);
	FImg = Falloc3d(x_size, y_size, z_size);
	ReadFloatImg(F_Img_FileName, FImg, x_size, y_size, z_size);
	for(k=0;k<z_size;k++)
		for(i=0;i<y_size;i++)
			for(j=0;j<x_size;j++)
			{
				UCImg[k][i][j] = (unsigned char)max(0, min(FImg[k][i][j], 255));
			}
	WriteUCImg(UC_Img_FileName, UCImg, x_size, y_size, z_size);
	UCfree3d(UCImg, z_size, x_size);
	Ffree3d(FImg, z_size, x_size);
}

float FindMaxInQueue(float *Queue, int *index, int Num)
{
	int i,d;
	float maximum;
	d = 0;
	maximum = Queue[0];
	for(i=1;i<Num;i++)
	{
		if(Queue[i]>maximum)
		{
			maximum = Queue[i];
			d = i;
		}
	}
	*index = d;
	return maximum;
}

void DownSampleImage(char *FileName, char *OutFileName, int x_size, int y_size, int z_size, int Down_Scale)
{
	int i,j,k;
	unsigned char ***OutputImg, ***InputImg;
	int output_x_size, output_y_size, output_z_size;
	output_z_size = z_size/Down_Scale;
	output_x_size = x_size/Down_Scale;
	output_y_size = y_size/Down_Scale;

	InputImg = UCalloc3d(x_size, y_size, z_size);
	OutputImg = UCalloc3d(output_x_size, output_y_size, output_z_size);
	ReadUCImg(FileName, InputImg, x_size, y_size, z_size);
	for(k=0;k<output_z_size;k++)
		for(i=0;i<output_y_size;i++)
			for(j=0;j<output_x_size;j++)
			{
				OutputImg[k][i][j] = InputImg[k*Down_Scale][i*Down_Scale][j*Down_Scale];
			}
	WriteUCImg(OutFileName, OutputImg, output_x_size, output_y_size, output_z_size);
}

void NearestUpSampleImage(char *InputFileName, char *OutputFileName, int x_size, int y_size, int z_size, int Up_Scale)
{
	int i,j,k;
	int l,m,n;
	unsigned char ***OutputImg, ***InputImg;
	int output_x_size, output_y_size, output_z_size;
	output_z_size = z_size * Up_Scale;
	output_x_size = x_size * Up_Scale;
	output_y_size = y_size * Up_Scale;

	InputImg = UCalloc3d(x_size, y_size, z_size);
	OutputImg = UCalloc3d(output_x_size, output_y_size, output_z_size);
	ReadUCImg(InputFileName, InputImg, x_size, y_size, z_size);
	for(k=0;k<z_size;k++)
		for(i=0;i<y_size;i++)
			for(j=0;j<x_size;j++)
			{
				for(l=0;l<Up_Scale;l++)	
					for(m=0;m<Up_Scale;m++)
						for(n=0;n<Up_Scale;n++)
							OutputImg[k*Up_Scale+l][i*Up_Scale+m][j*Up_Scale+n] = InputImg[k][i][j];
			}
	WriteUCImg(OutputFileName, OutputImg, output_x_size, output_y_size, output_z_size);
}
