#ifndef _3d_image_base_h_
#define _3d_image_base_h_

#include "itkImage.h"
#include "itkOrientedImage.h"
#include <itkCovariantVector.h>
#include <itkGradientImageFilter.h>

typedef itk::OrientedImage<float, 3> ImageType;
///typedef itk::Image<float, 3>         ImageType;

typedef itk::OrientedImage<unsigned char, 3> Image8Type;

// These are for computing the GVF.
typedef itk::Image<double, 3> ImageDType;
//Declare gradient and gradient image type (for GVF).
typedef itk::CovariantVector<double, 3> GradientType;
typedef itk::Image<GradientType, 3> GradientImageType;
typedef itk::GradientImageFilter<ImageDType, double, double> GradientFilterType;


#endif
