#ifndef _3d_image_util_h_
#define _3d_image_util_h_

#include <vcl_vector.h>
#include <3d_image/3d_image_base.h>

void BinaryClosingImage (ImageType::Pointer& image, const int radius);
void BinaryOpenningImage (ImageType::Pointer& image, const int radius);

void compute_histogram (const ImageType::Pointer& image, 
                        vcl_vector<float>& histVector,
                        vcl_vector<float>& binMax,
                        vcl_vector<float>& binMin,
                        int& nBin);

void HistogramEqualization (const ImageType::Pointer& image);

void BinaryMedianFilter (ImageType::Pointer& image, const int radius);

void SmoothImage (ImageType::Pointer& image, const float sigma);

void GradientAnisotropicSmooth (ImageType::Pointer& image);

//mask the input image by the mask image.
void compute_mask_img (const ImageType::Pointer& image, 
                       const Image8Type::Pointer& img_mask, 
                       ImageType::Pointer& result);

bool detect_bnd_box (const ImageType::Pointer& image, 
                     const float bg_thresh, 
                     int& xmin, int& ymin, int& zmin, 
                     int& xmax, int& ymax, int& zmax);

void compute_grid_imgs (const ImageType::Pointer& image, 
                        const int xmin, const int ymin, const int zmin, 
                        const int xmax, const int ymax, const int zmax, 
                        const int n_grid, 
                        vcl_vector<ImageType::Pointer>& image_grid,
                        vcl_vector<ImageType::IndexType>& grid_center_index);

void compute_gain_from_grids (const vcl_vector<ImageType::Pointer>& gain_field_g_grid, 
                              const ImageType::Pointer& img_y, const float bg_thresh,
                              ImageType::Pointer& gain_field_g);

void update_gain_to_image (const ImageType::Pointer& gain_field, 
                           const ImageType::Pointer& image);

double compute_diff_norm (const vcl_vector<vcl_vector<float> >& centroid_v_grid, 
                          const vcl_vector<float>& centroid_vn_grid);

//mask the final gain_field with image and bg_thresh.
void mask_gain_field (const ImageType::Pointer& image, 
                      const float bg_thresh,
                      const ImageType::Pointer& gain_field_g);

#endif
