#ifndef afcm_h_
#define afcm_h_

#include <vcl_vector.h>

#include "itkImageRegionConstIterator.h"
#include "itkImageRegionIterator.h"

#include <3d_image/3d_image_base.h>

void afcm_segmentation (const ImageType::Pointer& img_y, 
                        const int n_class, const int n_bin,
                        const float low_th, const float high_th,
                        const float bg_thresh,
                        const int gain_fit_option, 
                        const float gain_th, const float gain_min,
                        const float conv_thresh,
                        ImageType::Pointer& gain_field_g,
                        vcl_vector<ImageType::Pointer>& mem_fun_u, 
                        vcl_vector<ImageType::Pointer>& mem_fun_un, 
                        vcl_vector<float>& centroid_v);

void compute_init_centroid (const ImageType::Pointer& image, 
                            const int nClass, const int nBin,
                            const ImageType::PixelType lowThreshold,
                            const ImageType::PixelType highThreshold,
                            vcl_vector<float>& initCentroid);

// Compute new membership functions u1[], u2[], u3[].
void compute_new_mem_fun_u (const vcl_vector<float>& centroid_v,
                            const ImageType::Pointer& gain_field_g, 
                            const ImageType::Pointer& img_y,
                            const float bg_thresh,
                            vcl_vector<ImageType::Pointer>& mem_fun_u);

// Compute the new centroids v1, v2, v3.
void compute_new_centroids (const vcl_vector<ImageType::Pointer>& mem_fun_u, 
                            const ImageType::Pointer& gain_field_g, 
                            const ImageType::Pointer& img_y, 
                            vcl_vector<float>& centroid_v);

// Compute a new gain field g[].
void compute_new_gain_field (const vcl_vector<ImageType::Pointer>& mem_fun_u, 
                             const ImageType::Pointer& img_y, 
                             ImageType::Pointer& gain_field_g,
                             const int option, const float gain_th);

// Test convergence.
bool test_convergence (const vcl_vector<ImageType::Pointer>& mem_fun_u, 
                       const vcl_vector<ImageType::Pointer>& mem_fun_un, 
                       const float conv_thresh);

#endif

