/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $HeadURL: http://svn.slicer.org/Slicer3/trunk/Applications/CLI/HistogramMatching.cxx $
  Language:  C++
  Date:      $Date: 2007-01-12 02:17:38 +0900 (金, 12 1 2007) $
  Version:   $Revision: 2207 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"

#include "itkHistogramMatchingImageFilter.h"

#include "itkHistogramMatching.h"
#include "itkHistogram.h"

#include "itkScalarImageToHistogramGenerator.h"

#define VER2  // CAUTION!!!

#define MaxOfUC  255

using namespace std;


  // CAUTION!

//  std::string inputVolume;
//  std::string referenceVolume;
//  std::string outputVolume;

  int numberOfHistogramLevels;
  int numberOfMatchPoints;
  int thresholdAtMeanIntensity;



//template<class T> int DoIt( int argc, char * argv[], T )
//template<class T> 
int HistMatch::DoIt(std::string& inputVolume, std::string& referenceVolume, std::string& outputVolume)
{

  cout << "HistMatch::DoIt(T)" << endl;

  int t, shift, temp;
  float  scale, mindist, s, dist, distA, distB;

  shift = 0;
  scale = 1;

  float       global_scale = 2.5;  //CAUTION: parameter pass

 // PARSE_ARGS;

  const unsigned int Dimension = 3;

 // CAUTION 
//  typedef T InputPixelType;
//  typedef T OutputPixelType;
//  typedef T WritePixelType; 

  typedef short InputPixelType;
  typedef short OutputPixelType;
  typedef short WritePixelType;

  int threshold = 5;  // CAUTION

  int dim_x, dim_y, dim_z; // CAUTION
  dim_x = dim_y = 256;
  dim_z = 46;


  typedef itk::Image< InputPixelType,  Dimension >   InputImageType;
  typedef itk::Image< OutputPixelType, Dimension >   OutputImageType;


  // readers/writers
  typedef itk::ImageFileReader< InputImageType  >  ReaderType;
  typedef itk::ImageFileWriter< OutputImageType >  WriterType;

  // Creation of Reader and Writer filters
  //typename ReaderType::Pointer reader1 = ReaderType::New();
  //typename ReaderType::Pointer reader2 = ReaderType::New();
  //typename WriterType::Pointer writer  = WriterType::New();

  ReaderType::Pointer reader1 = ReaderType::New();
  ReaderType::Pointer reader2 = ReaderType::New();
  WriterType::Pointer writer  = WriterType::New();

 
  cout << "input: " << inputVolume.c_str() << endl;
  cout << "referenceVolume: " << referenceVolume.c_str() << endl;
  cout << "outputVolume: " << outputVolume.c_str() << endl;


  // Setup the input and output files
  reader1->SetFileName( inputVolume.c_str() );
  reader2->SetFileName( referenceVolume.c_str() );
  writer->SetFileName( outputVolume.c_str() );


  //mjkim
  InputImageType::Pointer image1;
  OutputImageType::Pointer image2;

  reader1->Update();
  reader2->Update();

  image1 = reader1->GetOutput();
  image2 = reader2->GetOutput();

  /* To ignore background, by thresholding */

   InputImageType::IndexType index;

  for (int k=0; k<dim_z; k++)
    for (int i=0; i<dim_x; i++)
      for (int j=0; j<dim_y; j++) 
	{
          index[0] = i; index[1] = j; index[2] = k;

	  if( image1->GetPixel(index)<threshold )
	    image1->SetPixel(index, 0);
	}


  for (int k=0; k<dim_z; k++)
    for (int i=0; i<dim_x; i++)
      for (int j=0; j<dim_y; j++) 
	{
          index[0] = i; index[1] = j; index[2] = k;
	  
	  if( image2->GetPixel(index)<threshold )
	    image2->SetPixel(index, 0);
        }

  cout << "image read: pass" << endl;

#ifdef VER3
  float                *histoA, *histoB, *histoB_trans, *histoA_trans;

    /* create histogram */
  histoA = (float *)malloc((MaxOfUC+1)*sizeof(float));
  histoB = (float *)malloc((MaxOfUC+1)*sizeof(float));
  for (i=0; i<(MaxOfUC+1); i++) histoA[i] = histoB[i] = 0;


  for (int k=0; k<dim_z; k++)
    for (int i=0; i<dim_x; i++)
      for (int j=0; j<dim_y; j++) 
	{
	 index[0] = i; index[1] = j; index[2] = k;
	 histoA[image1->GetPixel(index)] +=1.0;
	}

  if  (m_IsFlair == 1) ThresholdFlairHistogram(histoA);
  for (int i=0; i<(MaxOfUC+1); i++) 
    {
      histoA[i] /= (dim_z*dim_x*dim_y) ;
      printf ("histoA[%d]: %f\n", i, histoA[i]);
    }

  for (int k=0; k<dim_z; k++)
    for (int i=0; i<dim_x; i++)
      for (int j=0; j<dim_y; j++) 
	{
	  index[0] = i; index[1] = j; index[2] = k;
	  histoB[image2->GetPixel(index)] +=1.0;
	}
  
  if  (m_IsFlair == 1) ThresholdFlairHistogram(histoB);
  for (int i=0; i<(MaxOfUC+1); i++) 
    {
      histoB[i] /= (dim_z*dim_x*dim_y) ;
      printf ("histoB[%d]: %f\n", i, histoB[i]);
    }
  printf ("after getting histogram..\n");

  /* to ignore background, and normalize ...  */
  for (int i=1; i<(MaxOfUC+1); i++) 
    {
      histoA[i] = histoA[i]/(1.0-histoA[0]) ;
      printf ("histoA[%d]: %f\n", i, histoA[i]);
    }
  for (int i=1; i<(MaxOfUC+1); i++) 
    {
      histoB[i] = histoB[i]/(1.0-histoB[0]) ;
      printf ("histoB[%d]: %f\n", i, histoB[i]);
    }
  histoA[0] = histoB[0] = 0;

  /* interpolate values for those with zeros */
  LinearlyInterpolateHistogram(histoA) ;
  LinearlyInterpolateHistogram(histoB) ;

  cout << "after LinearlyInterpolateHistogram" << endl;

  /* smooth ... */
  smooth_histogram_byMedianFilter(histoA);
  smooth_histogram_byMedianFilter(histoB);

  cout << "after smooth_histogram_byMedianFilter" << endl;

  /* normalization ... */
  Vector_Normalization(histoA, (MaxOfUC+1)) ;
  Vector_Normalization(histoB, (MaxOfUC+1)) ;

  cout << "after Vector_Normalization" << endl;

  printf("\n\nhistogram created\n");
  /* PrintVector(histoA, (MaxOfUC+1)); 
     PrintVector(histoB, (MaxOfUC+1)); Aug 25 2003 */


  /* matching imgA to imgB */
  histoB_trans = (float *)malloc((MaxOfUC+1)*sizeof(float));
  histoA_trans = (float *)malloc((MaxOfUC+1)*sizeof(float));
  mindist = 99999999.9;
  for (s=0.4; s<global_scale; s+=0.01)  /* {0.5~1.5 by 0.01} */
    for (t=-150; t<150; t++)
      {
        /* consitence requirement */
        /* on A space */
        for (unsigned int i=0; i<(MaxOfUC+1); i++) histoB_trans[i] = histoB[i];
        vector_transform(histoB_trans, (MaxOfUC+1), s, t);
         /* fitting, smoothing, normalization */
         LinearlyInterpolateHistogram(histoB_trans) ;
          /*smooth_histogram_byMedianFilter(histoB_trans);*/
         Vector_Normalization(histoB_trans, (MaxOfUC+1)) ;
        distA = vector_distance(histoB_trans, histoA, (MaxOfUC+1));

        /* on B space */
        for (unsigned int i=0; i<(MaxOfUC+1); i++) histoA_trans[i] = histoA[i];
        vector_InverseTransform(histoA_trans, (MaxOfUC+1), s, t);
         /* fitting, smoothing, normalization */
         LinearlyInterpolateHistogram(histoA_trans) ;
          /*smooth_histogram_byMedianFilter(histoA_trans);*/
         Vector_Normalization(histoA_trans, (MaxOfUC+1)) ;
        distB = vector_distance(histoA_trans, histoB, (MaxOfUC+1));

        /*distA=0;*/

        dist = distA + distB ;

        if (dist < mindist) {
          mindist = dist;
          scale = s;
          shift = t;
        }
      }
  printf("\n\n(scale, shift): (%f, %d)        mindist: %f\n\n\n", scale, shift, mindist);
     /*for (i=0; i<(MaxOfUC+1); i++) histoB_trans[i] = histoB[i];
       vector_transform(histoB_trans, (MaxOfUC+1), scale, shift);
       PrintVector(histoB_trans, (MaxOfUC+1)); 
       dist = vector_distance(histoB_trans, histoA, (MaxOfUC+1));
       printf("dist=%f\n", dist) ; Aug 25 2003 */

  /* transform intensity of imgA */
  for (int k=0; k<dim_z; k++)
    for (int i=0; i<dim_x; i++)
      for (int j=0; j<dim_y; j++)
	{
	index[0] = i; index[1] = j; index[2] = k;	
        if (image1->GetPixel(index) != 0)
          {
            temp = (int)((image1->GetPixel(index) - shift)*scale + 0.5);
            if (temp <= 0)   temp = 1; /*0*/
            if (temp > MaxOfUC) temp = MaxOfUC;

            image1->SetPixel(index,  (unsigned char)temp);
          }
	}

  cout << "image calculation: pass" << endl;


  writer->SetInput( image1 );
  writer->Update();

  cout << outputVolume.c_str() << " saved" << endl;

  
#endif // VER3


#ifdef VER2

  typedef itk::Statistics::ScalarImageToHistogramGenerator<
                                 InputImageType >   HistogramGeneratorType;

  HistogramGeneratorType::Pointer histogramGenerator1 =
                                        HistogramGeneratorType::New();

  HistogramGeneratorType::Pointer histogramGenerator2 =
					HistogramGeneratorType::New();

  histogramGenerator1->SetInput(image1);
  histogramGenerator2->SetInput(image2);

  //TODO: Flair case

  histogramGenerator1->SetHistogramMin(  -0.5 );
  histogramGenerator1->SetHistogramMax( 255.5 );

  histogramGenerator1->SetNumberOfBins( 256 );
  histogramGenerator1->SetMarginalScale( 10.0 );

  histogramGenerator1->Compute();

  histogramGenerator2->SetHistogramMin(  -0.5 );
  histogramGenerator2->SetHistogramMax( 255.5 );

  histogramGenerator2->SetNumberOfBins( 256 );
  histogramGenerator2->SetMarginalScale( 10.0 );

  histogramGenerator2->Compute();


  typedef HistogramGeneratorType::HistogramType  HistogramType;

  HistogramType * histogram1 = const_cast<HistogramType *>(histogramGenerator1->GetOutput());
  HistogramType * histogram2 = const_cast<HistogramType *>(histogramGenerator2->GetOutput());


  typedef itk::Statistics::Histogram< float > myHistogramType ;
  myHistogramType::Pointer myhistogram1 = myHistogramType::New() ;  
  myHistogramType::Pointer myhistogram2 = myHistogramType::New() ;


  myHistogramType::SizeType size ;
  size.Fill(256) ;

  myHistogramType::MeasurementVectorType lowerBound ;
  myHistogramType::MeasurementVectorType upperBound ;
  lowerBound[0] = -0.5 ;
  upperBound[0] = 255.5 ;

  myhistogram1->Initialize(size, lowerBound, upperBound ) ;
  myhistogram2->Initialize(size, lowerBound, upperBound ) ;

  myHistogramType::IndexType histindex ;
  histindex[0] = 0 ;

//  std::cout << "Frequency of the bin at index " << histindex
//  << " is " << histogram->GetFrequency(histindex)
//  << ", and the bin’s instance identifier is "
//  << histogram->GetInstanceIdentifier(histindex) << std::endl ;

  unsigned int histogramSize = histogram1->Size();
  //std::cout << "Histogram size " << histogramSize << std::endl;

  if (m_IsFlair==1) ThresholdFlairHistogram(histogram1); // For Flair

  unsigned int bin;
  for( bin=0; bin < histogramSize; bin++ )
    {
   // std::cout << "bin = " << bin << " frequency = ";
   // std::cout << histogram1->GetFrequency( bin, 0 ) << std::endl;


  //  printf ("norm freq: %f",  (float)  histogram1->GetFrequency( bin, 0 )/ (float) (dim_x*dim_y*dim_z));

    myhistogram1->SetFrequency(bin, (float)  histogram1->GetFrequency( bin, 0 )/ (float) (dim_x*dim_y*dim_z));

    histindex[0] = bin ;

  //  printf ("myhistogram1->GetFrequency( bin ): %f\n", (float) myhistogram1->GetFrequency(histindex ) );
    }


  if (m_IsFlair==1) ThresholdFlairHistogram(histogram2);

  for( bin=0; bin < histogramSize; bin++ )
    {
//    std::cout << "bin = " << bin << " frequency = ";
//    std::cout << histogram2->GetFrequency( bin, 0 ) << std::endl;


   // printf ("norm freq: %f",  (float)  histogram2->GetFrequency( bin, 0 )/ (float) (dim_x*dim_y*dim_z));

    myhistogram2->SetFrequency(bin, (float)  histogram2->GetFrequency( bin, 0 )/ (float) (dim_x*dim_y*dim_z));

    histindex[0] = bin ;

   // printf ("myhistogram2->GetFrequency( bin ): %f\n", (float) myhistogram2->GetFrequency(histindex ) );
    }


   cout << "after getting histogram..." << endl;

   for( bin=1; bin < histogramSize; bin++ )
    {
	myhistogram1->SetFrequency(bin, myhistogram1->GetFrequency( bin )/(1-myhistogram1->GetFrequency( 0 )));

//	std::cout << "myhistogram1->GetFrequency(bin): " << myhistogram1->GetFrequency(bin) << endl;
    }

   for( bin=1; bin < histogramSize; bin++ )
    {
        myhistogram2->SetFrequency(bin, myhistogram2->GetFrequency( bin )/(1-myhistogram2->GetFrequency( 0 )));

//        std::cout << "myhistogram2->GetFrequency(bin): " << myhistogram2->GetFrequency(bin) << endl;
    }

   myhistogram1->SetFrequency(0, 0);
   myhistogram2->SetFrequency(0, 0);

  /* interpolate values for those with zeros */
  LinearlyInterpolateHistogram(myhistogram1) ;
  LinearlyInterpolateHistogram(myhistogram2) ;

  /* smooth ... */
  smooth_histogram_byMedianFilter(myhistogram1);
  smooth_histogram_byMedianFilter(myhistogram2);

  /* normalization ... */
  Vector_Normalization(myhistogram1, histogramSize) ;
  Vector_Normalization(myhistogram2, histogramSize) ;

  printf("\n\nhistogram created\n");
  /* PrintVector(histoA, (MaxOfUC+1)); 
     PrintVector(histoB, (MaxOfUC+1)); Aug 25 2003 */

  myHistogramType::Pointer histoB_trans = myHistogramType::New() ;
  myHistogramType::Pointer histoA_trans = myHistogramType::New() ;

  histoB_trans->Initialize(size, lowerBound, upperBound ) ;
  histoA_trans->Initialize(size, lowerBound, upperBound ) ;

  mindist = 99999999.9;

  for (s=0.4; s<global_scale; s+=0.01)  /* {0.5~1.5 by 0.01} */
    for (t=-150; t<150; t++)
      {
        /* consitence requirement */
        /* on A space */
        for (unsigned int i=0; i<histogramSize; i++) histoB_trans->SetFrequency(i, myhistogram2->GetFrequency(i));
        vector_transform(histoB_trans, histogramSize, s, t);
         /* fitting, smoothing, normalization */
         LinearlyInterpolateHistogram(histoB_trans) ;
          /*smooth_histogram_byMedianFilter(histoB_trans);*/
         Vector_Normalization(histoB_trans, histogramSize) ;
        distA = vector_distance(histoB_trans, myhistogram1, histogramSize);

        /* on B space */
        for (unsigned int i=0; i<histogramSize; i++) histoA_trans->SetFrequency(i, myhistogram1->GetFrequency(i));
        vector_InverseTransform(histoA_trans, histogramSize, s, t);
         /* fitting, smoothing, normalization */
         LinearlyInterpolateHistogram(histoA_trans) ;
          /*smooth_histogram_byMedianFilter(histoA_trans);*/
         Vector_Normalization(histoA_trans, histogramSize) ;
        distB = vector_distance(histoA_trans, myhistogram2, histogramSize);

        /*distA=0;*/

        dist = distA + distB ;

        if (dist < mindist) {
          mindist = dist;
          scale = s;
          shift = t;
        }
      }
  printf("\n\n(scale, shift): (%f, %d)        mindist: %f\n\n\n", scale, shift, mindist);
     /*for (i=0; i<(MaxOfUC+1); i++) histoB_trans[i] = histoB[i];
       vector_transform(histoB_trans, (MaxOfUC+1), scale, shift);
       PrintVector(histoB_trans, (MaxOfUC+1)); 
       dist = vector_distance(histoB_trans, histoA, (MaxOfUC+1));
       printf("dist=%f\n", dist) ; Aug 25 2003 */



  /* transform intensity of imgA */
  for (int k=0; k<dim_z; k++)
    for (int i=0; i<dim_x; i++)
      for (int j=0; j<dim_y; j++) {

	 index[0] = i; index[1] = j; index[2] = k;

        if (image1->GetPixel(index) != 0)
          {
            temp = (int)((image1->GetPixel(index) - shift)*scale + 0.5);
            if (temp <= 0)   temp = 1; /*0*/
            if (temp > MaxOfUC) temp = MaxOfUC;

            image1->SetPixel(index, (unsigned char)temp);
          }
	}
  writer->SetInput( image1 );
  writer->Update();

#endif // VER2


#ifdef VER1


  // define the histogram matching
  typedef itk::HistogramMatchingImageFilter<
                            InputImageType,
                            OutputImageType >  FilterType;

  // Create the filter
  FilterType::Pointer  filter = FilterType::New();
  
  // Setup the filter
  filter->SetInput                    ( image1 );
  filter->SetReferenceImage           ( image2 );

  thresholdAtMeanIntensity = 5;
  filter->SetThresholdAtMeanIntensity ( thresholdAtMeanIntensity );

  // Write the output
  writer->SetInput( filter->GetOutput() );
  writer->Update();

#endif // VER1

  return EXIT_SUCCESS;

}


void HistMatch::matching(std::string& inputVolume, std::string& referenceVolume, std::string& outputVolume , bool is_flair)
//int main( int argc, char * argv[] )
{


  cout << "HistMatch::matching()" << endl; 

  m_IsFlair = is_flair;

  if (m_IsFlair==1) cout << "Your input is Flair image." << endl;

  // CAUTION

//   DoIt(static_cast<short>(0) );
   DoIt(inputVolume, referenceVolume, outputVolume);

}



void HistMatch::LinearlyInterpolateHistogram(myHistogramType::Pointer histo)
{

   //cout << "HistMatch::LinearlyInterpolateHistogram(myHistogramType::Pointer histo)" << endl;

   typedef itk::Statistics::Histogram< float > myHistogramType ;
   myHistogramType::Pointer histoTmp = myHistogramType::New() ;

  unsigned int Left, Right ;
  float a;

  unsigned int histogramSize = histo->Size();
 // std::cout << "Histogram size " << histogramSize << std::endl;

  /* get new values for the positions with value 0*/
  for(unsigned int i=0; i<histogramSize; i++)
    {
      if( histo->GetFrequency(i)==0 )
        {
          for(Left=i; Left>0; Left--) /* background 0 */
            if( histo->GetFrequency(Left)!=0 ) break ;

          for(Right=i; Right<histogramSize; Right++)
            if( histo->GetFrequency(Right)!=0 ) break ;

          /* interpolate ... */
          if( histo->GetFrequency(Left)!=0 && histo->GetFrequency(Right)!=0 )
            {
              a = (float)Left/(float)(Left+Right) ;
              histo->SetFrequency(i, (1-a)*histo->GetFrequency(Left) + a*histo->GetFrequency(Right)) ;
            }
        }
    }

}


void HistMatch::smooth_histogram_byMedianFilter(myHistogramType::Pointer histo)
{

   //cout << "HistMatch::smooth_histogram_byMedianFilter" << endl;

  unsigned int   size ;  

  typedef itk::Statistics::Histogram< float > myHistogramType ;
  myHistogramType::Pointer histoTmp = myHistogramType::New() ;

  myHistogramType::SizeType histsize ;
  histsize.Fill(256) ;

  myHistogramType::MeasurementVectorType lowerBound ;
  myHistogramType::MeasurementVectorType upperBound ;
  lowerBound[0] = -0.5 ;
  upperBound[0] = 255.5 ;

  histoTmp->Initialize(histsize, lowerBound, upperBound ) ;


   size = 2;
  FloatVectorType tmp;
  tmp.SetSize(2*size+1);

  unsigned int histogramSize = histo->Size();
 // std::cout << "Histogram size " << histogramSize << std::endl;


  for (unsigned int i=0; i<histogramSize; i++) {
	histoTmp->SetFrequency(i, histo->GetFrequency(i));
   }

  for (unsigned int i=size; i<histogramSize-size; i++) {

    for (unsigned int j=-size; j<size+1; j++) {
	 tmp.SetElement(j+size, histo->GetFrequency(i+j));
	 cout <<tmp.GetElement(j+size)<< endl;
	}

    histoTmp->SetFrequency(i, medianvalue(tmp, 2*size+1));
  }

  for (unsigned int i=0; i<histogramSize; i++) histo->SetFrequency(i, histoTmp->GetFrequency(i));


}


float HistMatch::medianvalue(FloatVectorType vec, int len)
{

  //cout << "HistMatch::medianvalue()" << endl;

  cout << "len: " << len << endl;

  mysort(vec, len);

 // return vec[(len/2)];
 return vec.GetElement(len/2);

}

void HistMatch::mysort(FloatVectorType vec, int len)
{

  //cout << "HistMatch::mysort" << endl;

  //cout << "len: " << len << endl;

  int    i, j, count ;
  float  max;

 // for (i=0; i<len; i++)
//	cout << vec.GetElement(i) << " " << endl;

  for (i=0; i<len; i++) {
    FloatVectorType vec1;
    vec1.SetSize(len-i);

    for (j=i; j<len; j++) 
	//vec1[j-i] = vec[j];
	  vec1.SetElement(j-i, vec.GetElement(j));


    max = GetMax(vec1, len-i);

    vec.SetElement(i, max);

    count = 1;
    for (j=0; j<len-i; j++)
      if (vec1.GetElement(j) != max) {
        vec.SetElement(i+count, vec1.GetElement(j));
        count++;
      }
  }
}


float HistMatch::GetMax(FloatVectorType vec, int len)
{
  //cout << "HistMatch::GetMax" << endl;

  int    i ;
  float  max;

  max = -999999;
  for (i=0; i<len; i++)
    if (vec.GetElement(i) > max) max = vec.GetElement(i);

  return max;


}

void HistMatch::Vector_Normalization(myHistogramType::Pointer vec, int len)
{

  //cout <<"HistMatch::Vector_Normalization" << endl;

  int        i;
  float      total ;

  /* normalization ... */
  total = 0 ;
  for (i=0; i<len; i++)
    total += vec->GetFrequency(i) ;

  for (i=0; i<len; i++)
    vec->SetFrequency(i, vec->GetFrequency(i)/total) ;


}


void HistMatch::vector_transform(myHistogramType::Pointer vec, int len, float s, int t)
{

   //cout << "HistMatch::vector_transform" << endl;

  int        i, j, ind;
  typedef itk::Statistics::Histogram< float > myHistogramType ;
  myHistogramType::Pointer vec1 = myHistogramType::New();

  int        minV, maxV ;
  float      ProbLeft, ProbRight ;
  ProbLeft = 0;
  ProbRight = 0;

  myHistogramType::SizeType size ;
  size.Fill(256) ;

  myHistogramType::MeasurementVectorType lowerBound ;
  myHistogramType::MeasurementVectorType upperBound ;
  lowerBound[0] = -0.5 ;
  upperBound[0] = 255.5 ;

  vec1->Initialize(size, lowerBound, upperBound ) ;



  minV = 10000 ; maxV = -10000 ;
//  vec1 = (float *)malloc(len*sizeof(float));
  for (i=0; i<len; i++) 
	//vec1[i] = 0;
	vec1->SetFrequency(i, 0);

  for (j=0; j<len; j++) 
    { 
      ind = (int)((float)(j-t)*s + 0.5);
      /* used to find whether the transformation is out of domain */
      if( ind<minV )  minV = ind ;
      if( ind>maxV )  maxV = ind ;

      if (ind < 0)       
	//vec1[j] = 0 ;/*= vec[0];*/
	vec1->SetFrequency(j, 0);
 	
      if (ind > (len-1)) 
	//vec1[j] = 0 ;/*= vec[len-1];*/
	 vec1->SetFrequency(j,0);

      if ((ind >= 0) && (ind <= (len-1))) 
	//vec1[j] = vec[ind];
	vec1->SetFrequency(j,vec->GetFrequency(ind));
    }
    
  /* Prob was left in the left side */
  if( minV>0 )
    { 
      ProbLeft = 0 ;
      for (i=0; i<minV; i++) 
	//ProbLeft += vec[i] ;
	ProbLeft += vec->GetFrequency(i);
    }
    
  /* Prob was left in the right side */
  if( maxV<MaxOfUC )
    { 
      ProbRight = 0 ;
      for (i=maxV; i<MaxOfUC; i++) 
	//ProbRight += vec[i] ;
	ProbRight += vec->GetFrequency(i);
    }
    
   /* add ...  */
  vec1->SetFrequency(0, vec1->GetFrequency(0)+ProbLeft) ;
  vec1->SetFrequency(MaxOfUC, vec1->GetFrequency(MaxOfUC)+ProbRight) ;
  

  /* transfer ... */
  for (i=0; i<len; i++) 
	//vec[i] = vec1[i];
	vec->SetFrequency(i, vec1->GetFrequency(i));

}


void HistMatch::vector_InverseTransform(myHistogramType::Pointer vec, int len, float s, int t)
{

   //cout << "HistMatch::vector_InverseTransform" << endl;

  int        i, j, ind;
  int        minV, maxV ;
  float      ProbLeft, ProbRight ;
  ProbLeft = 0;
  ProbRight = 0;


  typedef itk::Statistics::Histogram< float > myHistogramType ;
  myHistogramType::Pointer vec1 = myHistogramType::New();

  myHistogramType::SizeType size ;
  size.Fill(256) ;

  myHistogramType::MeasurementVectorType lowerBound ;
  myHistogramType::MeasurementVectorType upperBound ;
  lowerBound[0] = -0.5 ;
  upperBound[0] = 255.5 ;

  vec1->Initialize(size, lowerBound, upperBound ) ;

  minV = 10000 ; maxV = -10000 ;

  for (i=0; i<len; i++) vec1->SetFrequency(i,0);
  for (j=0; j<len; j++)
    {
      ind = (int)(j/s + t + 0.5);
      /* used to find whether the transformation is out of domain */
      if( ind<minV )  minV = ind ;
      if( ind>maxV )  maxV = ind ;

      if (ind < 0)       
	//vec1[j] = 0 ;/*= vec[0];*/
	vec1->SetFrequency(j,0);

      if (ind > (len-1)) 
	//vec1[j] = 0 ;/*= vec[len-1];*/
	vec1->SetFrequency(j,0);

      if ((ind >= 0) && (ind <= (len-1))) 
	//vec1[j] = vec[ind];
	vec1->SetFrequency(j, vec->GetFrequency(ind));
    }

  /* Prob was left in the left side */
  if( minV>0 )
    {
      ProbLeft = 0 ;
      for (i=0; i<minV; i++) 
	//ProbLeft += vec[i] ;
	ProbLeft += vec->GetFrequency(i);
    }

  /* Prob was left in the right side */
  if( maxV<MaxOfUC )
    {
      ProbRight = 0 ;
      for (i=maxV; i<MaxOfUC; i++) 
	//ProbRight += vec[i] ;
	ProbRight += vec->GetFrequency(i);
    }

   /* add ...  */
   vec1->SetFrequency(0, vec1->GetFrequency(0)+ ProbLeft) ;
   vec1->SetFrequency(MaxOfUC, vec1->GetFrequency(MaxOfUC)+ProbRight) ;


  /* transfer ... */
  for (i=0; i<len; i++) 
	//vec[i] = vec1[i];
	vec->SetFrequency(i, vec1->GetFrequency(i));
}

float  HistMatch::vector_distance(myHistogramType::Pointer vec1, myHistogramType::Pointer vec2, int len)
{

  //cout << "HistMatch::vector_distance" << endl;

  int        i;
  float      dist;

  dist = 0.0;
  for (i=0; i<len; i++)
    {
      dist += (vec1->GetFrequency(i) - vec2->GetFrequency(i))*(vec1->GetFrequency(i) - vec2->GetFrequency(i)); /* overflow*/
      /*      printf("dist=%f  ", dist) ;*/
    } /*printf("\n\n") ;*/
  dist = sqrt(dist);

  return dist;
}

void HistMatch::ThresholdFlairHistogram (HistogramType* histo)
{
   cout << "HistMatch::ThresholdFlairHistogram" << endl;

  unsigned int         threshold, new_threshold;
  float                max_num, partial_area, total_area, ratio;
  unsigned int         i;

  unsigned int histogramSize = histo->Size();
  threshold = 0;

  histo->SetFrequency(0,0);
  max_num = -100.0;

  for (i=0; i<histogramSize; i++){
     if(histo->GetFrequency(i,0) > max_num) max_num = histo->GetFrequency(i,0);
     threshold = i;
  }

  total_area = 0.0;
  for (i=0; i<histogramSize; i++)
	 total_area += histo->GetFrequency(i,0);

  partial_area =  histo->GetFrequency(threshold,0);
  ratio = 0.0;

  for (i=0; i<histogramSize; i++) {
   partial_area += histo->GetFrequency(threshold+i,0) + histo->GetFrequency(threshold-i,0);
   ratio = partial_area / total_area;
   if (ratio > 0.9) break;
  }

  new_threshold = threshold - i;
  for (i=0; i<new_threshold; i++) histo->SetFrequency(i,0);


/*
//  printf("enter ThresholdFlairHistogram\n");
  histo[0] = 0.0;
  max_num = -100.0;
  for (i=0; i<MaxOfUC+1; i++) {
    if (histo[i]>max_num) {
      max_num = histo[i];
      threshold = i;
    }
  }

//  printf("threshold in flair: %d\n", threshold);

  total_area = 0.0;
  for (i=0; i<MaxOfUC+1; i++) total_area += histo[i];

  partial_area = histo[threshold];
  ratio = 0.0;
  for (i=0; i<MaxOfUC+1; i++) {
    partial_area += histo[threshold+i] + histo[threshold-i];
    ratio = partial_area / total_area;
//    printf("delta: %d\tratio: %f\n", i, ratio);
    if (ratio > 0.9) break;
  }

  new_threshold = threshold - i;
//  printf("new threshold in flair: %d\n", new_threshold);
  for (i=0; i<new_threshold; i++) histo[i] = 0;
*/
}

void  HistMatch::LinearlyInterpolateHistogram(float *histo)
{
  int i;
  int Left, Right ;
  float a;


  /* get new values for the positions with value 0*/
  for(i=0; i<(MaxOfUC+1); i++)
    {
      if( histo[i]==0 )
        {
          for(Left=i; Left>0; Left--) /* background 0 */
            if( histo[Left]!=0 ) break ;

          for(Right=i; Right<(MaxOfUC+1); Right++)
            if( histo[Right]!=0 ) break ;

          /* interpolate ... */
          if( histo[Left]!=0 && histo[Right]!=0 )
            {
              a = (float)Left/(float)(Left+Right) ;
              histo[i] = (1-a)*histo[Left] + a*histo[Right] ;
            }
        }
    }
/*
   // print
   for(i=0; i<(MaxOfUC+1); i++)
    {
       printf ("histo[%d]: %f\n", i, histo[i]);

    }
*/
}

void  HistMatch::smooth_histogram_byMedianFilter(float *histo)
{
  printf ("smooth_histogram_byMedianFilter\n");
  int        i, j, size ;
  float      *histoTmp, *tmp;

  size = 2;
  tmp = (float *)malloc((2*size+1)*sizeof(float));

  histoTmp = (float *)malloc((MaxOfUC+1)*sizeof(float));
  for (i=0; i<(MaxOfUC+1); i++) histoTmp[i] = histo[i];

  for (i=size; i<(MaxOfUC+1)-size; i++) {

    for (j=-size; j<size+1; j++) {
        tmp[j+size] = histo[i+j];
        //printf ("%f\n", tmp[j+size]);
    }

    histoTmp[i] = medianvalue(tmp, 2*size+1);
  }

  for (i=0; i<(MaxOfUC+1); i++) histo[i] = histoTmp[i];

  free(tmp);
  free(histoTmp);


}

float HistMatch::medianvalue(float *vec, int len)
{
  mysort(vec, len);
  return vec[(len/2)];
}

void  HistMatch::mysort(float *vec, int len)
{
  int    i, j, count ;
  float  *vec1, max;

  for (i=0; i<len; i++) {

    vec1 = (float *)malloc((len-i)*sizeof(float));
    for (j=i; j<len; j++) vec1[j-i] = vec[j];
    max = GetMax(vec1, len-i);
    vec[i] = max;
    count = 1;
    for (j=0; j<len-i; j++)
      if (vec1[j] != max) {
        vec[i+count] = vec1[j];
        count++;
      }
     free(vec1);
  }
}

float HistMatch::vector_distance(float *vec1, float *vec2, int len)
{
  int        i;
  float      dist;

  dist = 0.0;
  for (i=0; i<len; i++)
    {
      dist += (vec1[i] - vec2[i])*(vec1[i] - vec2[i]); /* overflow*/
      /*      printf("dist=%f  ", dist) ;*/
    } /*printf("\n\n") ;*/
  dist = sqrt(dist);

  return dist;
}

void  HistMatch::vector_transform(float *vec, int len, float s, int t)
{
  int        i, j, ind;
  float      *vec1 ;
  int        minV, maxV ;
  float      ProbLeft, ProbRight ;
  ProbLeft = 0;
  ProbRight = 0;

  minV = 10000 ; maxV = -10000 ;
  vec1 = (float *)malloc(len*sizeof(float));
  for (i=0; i<len; i++) vec1[i] = 0;
  for (j=0; j<len; j++)
    {
      ind = (int)((float)(j-t)*s + 0.5);
      /* used to find whether the transformation is out of domain */
      if( ind<minV )  minV = ind ;
      if( ind>maxV )  maxV = ind ;

      if (ind < 0)       vec1[j] = 0 ;/*= vec[0];*/
      if (ind > (len-1)) vec1[j] = 0 ;/*= vec[len-1];*/
      if ((ind >= 0) && (ind <= (len-1))) vec1[j] = vec[ind];
    }

  /* Prob was left in the left side */
  if( minV>0 )
    {
      ProbLeft = 0 ;
      for (i=0; i<minV; i++) ProbLeft += vec[i] ;
    }

  /* Prob was left in the right side */
  if( maxV<MaxOfUC )
    {
      ProbRight = 0 ;
      for (i=maxV; i<MaxOfUC; i++) ProbRight += vec[i] ;
    }

   /* add ...  */
  vec1[0] += ProbLeft ;
  vec1[MaxOfUC] += ProbRight ;


  /* transfer ... */
  for (i=0; i<len; i++) vec[i] = vec1[i];
  free(vec1);

}

void  HistMatch::vector_InverseTransform(float *vec, int len, float s, int t)
{
  int        i, j, ind;
  float      *vec1 ;
  int        minV, maxV ;
  float      ProbLeft, ProbRight;
  ProbLeft = 0;
  ProbRight = 0;

  minV = 10000 ; maxV = -10000 ;
  vec1 = (float *)malloc(len*sizeof(float));
  for (i=0; i<len; i++) vec1[i] = 0;
  for (j=0; j<len; j++)
    {
      ind = (int)(j/s + t + 0.5);
      /* used to find whether the transformation is out of domain */
      if( ind<minV )  minV = ind ;
      if( ind>maxV )  maxV = ind ;

      if (ind < 0)       vec1[j] = 0 ;/*= vec[0];*/
      if (ind > (len-1)) vec1[j] = 0 ;/*= vec[len-1];*/
      if ((ind >= 0) && (ind <= (len-1))) vec1[j] = vec[ind];
    }

  /* Prob was left in the left side */
  if( minV>0 )
    {
      ProbLeft = 0 ;
      for (i=0; i<minV; i++) ProbLeft += vec[i] ;
    }

  /* Prob was left in the right side */
  if( maxV<MaxOfUC )
    {
      ProbRight = 0 ;
      for (i=maxV; i<MaxOfUC; i++) ProbRight += vec[i] ;
    }

   /* add ...  */
   vec1[0] += ProbLeft ;
   vec1[MaxOfUC] += ProbRight ;


  /* transfer ... */
  for (i=0; i<len; i++) vec[i] = vec1[i];
  free(vec1);
}

float HistMatch::GetMax(float *vec, int len) 
{
  int    i ;
  float  max;

  max = -999999;
  for (i=0; i<len; i++)
    if (vec[i] > max) max = vec[i];

  return max;

}

void  HistMatch::Vector_Normalization(float *vec, int len)
{
  int        i;
  float      total ;

  /* normalization ... */
  total = 0 ;
  for (i=0; i<len; i++)
    total += vec[i] ;

  for (i=0; i<len; i++)
    vec[i] = vec[i]/total ;

}

void  HistMatch::ThresholdFlairHistogram(float *histo)
{
  unsigned int         i, threshold, new_threshold;
  float                max_num, partial_area, total_area, ratio;
  threshold = 0;

/*  printf("enter ThresholdFlairHistogram\n");*/
  histo[0] = 0.0;
  max_num = -100.0;
  for (i=0; i<MaxOfUC+1; i++) {
    if (histo[i]>max_num) {
      max_num = histo[i];
      threshold = i;
    }
  }

/*  printf("threshold in flair: %d\n", threshold);*/

  total_area = 0.0;
  for (i=0; i<MaxOfUC+1; i++) total_area += histo[i];

  partial_area = histo[threshold];
  ratio = 0.0;
  for (i=0; i<MaxOfUC+1; i++) {
    partial_area += histo[threshold+i] + histo[threshold-i];
    ratio = partial_area / total_area;
/*    printf("delta: %d\tratio: %f\n", i, ratio);*/
    if (ratio > 0.9) break;
  }

  new_threshold = threshold - i;
/*  printf("new threshold in flair: %d\n", new_threshold);*/
  for (i=0; i<new_threshold; i++) histo[i] = 0;

}



