/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkNumericsListSample.txx,v $
  Language:  C++
  Date:      $Date: 2009-03-04 15:23:53 $
  Version:   $Revision: 1.16 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#ifndef __itkNumericsListSample_txx
#define __itkNumericsListSample_txx

#include "itkNumericsListSample.h"

namespace itk { 
namespace Statistics {

template< class TMeasurementVector >
NumericsListSample< TMeasurementVector >
::NumericsListSample()
{
}


template< class TMeasurementVector >
const typename NumericsListSample< TMeasurementVector >::MeasurementVectorType &
NumericsListSample< TMeasurementVector >
::GetMeasurementVector(const InstanceIdentifier &identifier) const 
{
  if ( identifier < m_InternalContainer.size() )
    {
    return m_InternalContainer[identifier];
    }
  itkExceptionMacro("Identifier " << identifier 
    << " is out of range 0:" << m_InternalContainer.size() ); 
}

template< class TMeasurementVector >
void 
NumericsListSample< TMeasurementVector >
::SetMeasurement(const InstanceIdentifier &identifier, 
                 const unsigned int &dim,
                 const MeasurementType &value)
{
  if ( identifier < m_InternalContainer.size() )
    {
    m_InternalContainer[identifier][dim] = value;
    }
}

template< class TMeasurementVector >
void
NumericsListSample< TMeasurementVector >
::SetMeasurementVector(const InstanceIdentifier &identifier, 
                       const MeasurementVectorType &mv)
{
  if ( identifier < m_InternalContainer.size() )
    {
    m_InternalContainer[identifier] = mv;
    }
}

template< class TMeasurementVector >
typename NumericsListSample< TMeasurementVector >::FrequencyType 
NumericsListSample< TMeasurementVector >
::GetFrequency(const InstanceIdentifier &identifier) const
{
  if ( identifier < m_InternalContainer.size() )
    {
    return 1.0;
    }
  else
    {
    return 0.0;
    }
}

template< class TMeasurementVector >
void 
NumericsListSample< TMeasurementVector >
::PrintSelf(std::ostream& os, Indent indent) const
{
  Superclass::PrintSelf(os,indent);

  os << indent << "Internal Data Container: "
     << &m_InternalContainer << std::endl;
  os << indent << "Number of samples: " 
     << this->m_InternalContainer.size() << std::endl;
}
} // end of namespace Statistics
} // end of namespace itk 

#endif
