#ifndef __itkRemoveEyeRegion_h
#define __itkRemoveEyeRegion_h

#include <cstdio>
#include <cstdlib>
#include "math.h"
#include "set"

//#include <itkImage.h>
#include <itkOrientedImage.h>
#include <itkImageToImageFilter.h>

#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"

#include "itkNumericsListSample.h"


namespace itk {

namespace Statistics {

template<class TInputImage, class TOutputImage>
class ITK_EXPORT RemoveEyeRegion  : public ImageToImageFilter<TInputImage, TOutputImage>
{
public:

  typedef RemoveEyeRegion Self;
  typedef ImageToImageFilter<TInputImage, TOutputImage> Superclass;
  typedef SmartPointer<Self>                        Pointer;
  typedef SmartPointer<const Self>                  ConstPointer;

  /** Method for creation through the object factory. */
  itkNewMacro(Self);

  /** Run-time type information (and related methods). */
  itkTypeMacro(RemoveEyeRegion, ImageToImageFilter);

//  typedef itk::Image<short, 3> ImageType;
  typedef itk::OrientedImage<short, 3> ImageType;
  typedef ImageType::Pointer ImagePointerType;

  typedef itk::VariableLengthVector<double> DoubleVectorType;
  typedef itk::VariableLengthVector<int> IntVectorType;

  typedef int                                      IntValueType;
  typedef itk::VariableLengthVector<IntValueType>  IntMeasurementVectorType;
  typedef itk::Statistics::NumericsListSample<IntMeasurementVectorType> IntSampleType;

  typedef itk::ImageFileReader< ImageType  > ImageReaderType;


  void removeregion(std::string& filename);
  void ComputeDistImg(ImagePointerType in, ImagePointerType dist);
  void GetMaskImg(ImagePointerType img, ImagePointerType mask);
  void ClosingOperationOnBinary3DImage (ImagePointerType in, ImagePointerType out, int Radius);

  void calculate_hood_byIncreasingRadius(IntSampleType* Hood, int HoodSize, int *pixelNumInHood, float xres,float yres,float zres);
  
  int IsEmptyImg(ImagePointerType img, ImagePointerType dist_img, int dist_threshold);

  int dim_x, dim_y, dim_z;
  float res_x, res_y, res_z;

  DoubleVectorType cen;
  IntVectorType histo;

  int threshold, max_label, ind1, ind2, label_num, label_count;
  int sum, pixelNumIn_MyHood, total_volume, Radius, MyHoodSize, max_CSFcount;
  int half, CSF_threshold, EYE_threshold, partial_volume, r, iter, max_dist, dist_threshold;

  float ratio, ratio_threshold, tmp, smooth_factor, EYE_ratio_threshold, CSF_ratio_threshold, CSF_ratio, tmp_ratio;
  float totalx, totaly, totalz, ratio_distance;


  

  ImagePointerType in, diff_img, mask_img, closed_img, opened_img ,tmp_img, dist;


private:
  RemoveEyeRegion(const Self&); //purposely not implemented
  void operator=(const Self&); //purposely not implemented


protected:
  RemoveEyeRegion();
  ~RemoveEyeRegion();
  void PrintSelf(std::ostream& os, Indent indent) const;

};

} //namespace Statistics
} // namespace itk



#ifndef ITK_MANUAL_INSTANTIATION
#include "itkRemoveEyeRegion.txx"
#endif



#endif 
