#include <iostream>
#include <sstream>
#include <vector>
#include <string>

#include "stdlib.h"
#include "stdio.h"
#include "math.h"
#include "set"


#include <math.h>
#include <stdlib.h>

#include <itkOrientedImage.h>
#define ORIENT


class myAffTrans 
{

public:

#ifdef ORIENT
  typedef itk::OrientedImage<short, 3> ImageType;
#else
  typedef itk::Image<short, 3> ImageType;
#endif // ORIENT
  typedef ImageType::Pointer ImagePointerType;


int myregistration(ImagePointerType outputimage);

#ifdef NOT
int mytransformation(ImagePointerType outputimage);
#endif // NOT

//template<class T> int DoIt();
int  DoIt(ImagePointerType outputimage);

void SetHistogramBin(int histbin);
void SetSpatialSamples(int spatialsample);
void SetIteration(int iter);
void SetTransScale(double transscale);

void SetInitTransform(std::string& inittrans);
void SetOutputTransform(std::string& outtrans);
void SetFixedImage(ImagePointerType fixedimage);
void SetMovingImage(ImagePointerType movingimage);
void SetAdditionalMovingImage(ImagePointerType addmovingimage);
void SetOutputImageFilename(std::string& outimagename);
void SetAdditionalImageFilename(std::string& addimagename);

//ImagePointerType GetRegisteredImage();

myAffTrans();
~myAffTrans();


private:

    int m_HistogramBins;
    int m_SpatialSamples;
    int m_Iterations;
    double m_TranslationScale ;
    std::string m_InitialTransform;
    std::string m_OutputTransform;
//    std::string m_FixedImageFileName;
//    std::string m_MovingImageFileName;

   ImagePointerType m_FixedImage;
   ImagePointerType m_MovingImage;
   ImagePointerType m_AddMovingImage;

   ImagePointerType m_OutputImage;

   std::string m_ResampledImageFileName;
   std::string m_AddImageFilename;

//    bool echoSwitch;
//    bool xmlSwitch;
//    std::string processInformationAddressString;


protected:


};
