#ifndef __itkSkullStripping_h
#define __itkSkullStripping_h

#if defined(_MSC_VER)
#pragma warning ( disable : 4996 )
#endif

#include <cstdio>
#include <cstdlib>
#include "math.h"
#include "set"

#include "itkPoint.h"
#include "itkImage.h"
#include "itkOrientedImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkImageToImageFilter.h"

#include "itkNearestNeighborInterpolateImageFunction.h"
#include "itkLinearInterpolateImageFunction.h"
#include "itkSignedMaurerDistanceMapImageFilter.h" 
#include "itkSphereSpatialFunction.h"
#include "itkFloodFilledSpatialFunctionConditionalIterator.h"
#include "itkFloodFilledImageFunctionConditionalIterator.h"
#include "itkVotingBinaryIterativeHoleFillingImageFilter.h" 
#include "itkBinaryThresholdImageFunction.h"

#include "itkBinaryDilateImageFilter.h"
#include "itkBinaryErodeImageFilter.h"
#include "itkBinaryBallStructuringElement.h"

#include "itkScalarImageToHistogramGenerator.h"

#include "vtkSphereSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkRenderWindow.h"
#include "vtkRenderer.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkProperty.h"
#include "vtkTriangleFilter.h"
#include "vtkPlatonicSolidSource.h" 
#include "vtkIdList.h"
#include "vtkPolyData.h"
#include "vtkPolyDataWriter.h"
#include "vtkXMLPolyDataWriter.h"

#include "vtkPolyDataPointSampler.h"

namespace itk {

namespace Statistics {

template<class TInputImage, class TOutputImage>
class ITK_EXPORT SkullStripping : public ImageToImageFilter<TInputImage, TOutputImage>
{
public:

  typedef SkullStripping Self;
  typedef ImageToImageFilter<TInputImage, TOutputImage> Superclass;
  typedef SmartPointer<Self>                        Pointer;
  typedef SmartPointer<const Self>                  ConstPointer;

//unsigned int ImageDimension = 3;
//typedef signed short PixelType;
// MJ_TEMP
//typedef short PixelType;
// MJ_TEMP
//typedef itk::OrientedImage< PixelType, ImageDimension > ImageType;

    /** ImageDimension enumeration */
    itkStaticConstMacro(ImageDimension, unsigned int,
                        TInputImage::ImageDimension);
    typedef TInputImage ImageType;
    typedef typename TInputImage::PixelType PixelType;
    
    typedef unsigned char LabelPixelType;
    typedef  itk::OrientedImage<LabelPixelType, ImageDimension> LabelImageType;
    typedef  typename LabelImageType::Pointer LabelImagePointer;
    typedef  itk::OrientedImage<double, ImageDimension> FloatImageType;
    typedef itk::ImageFileReader< ImageType  > ImageReaderType;

    typedef itk::Statistics::ScalarImageToHistogramGenerator< ImageType >   GeneratorType;
    typedef float        HistogramMeasurementType;

    typedef typename GeneratorType::HistogramType HistogramType;

    typedef typename ImageType::Pointer ImagePointerType;


  /** Method for creation through the object factory. */
  itkNewMacro(Self);

  /** Run-time type information (and related methods). */
  itkTypeMacro(SkullStripping, ImageToImageFilter);

  void Update();

  typename LabelImageType::Pointer BinaryErodeFilter3D ( LabelImageType * img , unsigned int ballsize );
  typename LabelImageType::Pointer BinaryDilateFilter3D ( LabelImageType *img , unsigned int ballsize );
  typename LabelImageType::Pointer BinaryOpeningFilter3D ( LabelImageType * img , unsigned int ballsize );
  typename LabelImageType::Pointer BinaryClosingFilter3D ( LabelImageType * img , unsigned int ballsize );

  void PolyDataToLabelMap( vtkPolyData* polyData, LabelImageType *label);
  PixelType FindWhiteMatterPeak ( HistogramType* histogram );
  void ComputeVertexNeighbors(vtkIdType iVertexId, vtkPolyData* pMesh, std::vector<vtkIdType>& pIdRet);
  vtkPolyData* TessellateIcosahedron(int level);


 
  void SetInputVolume(ImageType *inputvolume);
  void SetOutputVolumeFilename(std::string& maskedbrainfilename);
  void SetOutputMaskFilename(std::string& maskfilename);

  ImagePointerType  image;
  std::string m_MaskedBrainFilename;
  std::string m_MaskFilename;


private:

  SkullStripping(const Self&); //purposely not implemented
  void operator=(const Self&); //purposely not implemented


protected:

  SkullStripping();
  ~SkullStripping();
  void PrintSelf(std::ostream& os, Indent indent) const;


};

} //namespace Statistics
} // namespace itk







#ifndef ITK_MANUAL_INSTANTIATION
#include "itkSkullStripping.txx"
#endif
  
#endif
