#ifndef __itkWMLAdaptiveBooster_h
#define __itkWMLAdaptiveBooster_h

#include "itkNumericsListSample.h" 
#include "itkImageToListAdaptor.h"
#include <itkBinaryThresholdImageFilter.h>
#include <itkImageToImageFilter.h>
#include <itkRegionGrowImageFilter.h>
#include "SVMTrainApplication.h"
#include "SVMTestApplication.h"

#include <itkOrientedImage.h>

#define ORIENT


namespace itk {

template<class TImage, class TMeasurementVector >
class ITK_EXPORT WMLAdaptiveBooster : 
  public Statistics::ImageToListAdaptor<TImage, TMeasurementVector >

{
public:
  /** Standard class typedefs. */
  typedef WMLAdaptiveBooster                  Self;

  typedef Statistics::ImageToListAdaptor<TImage, TMeasurementVector > Superclass;
  typedef SmartPointer<Self>                        Pointer;
  typedef SmartPointer<const Self>                  ConstPointer;

  /** Method for creation through the object factory. */
  itkNewMacro(Self);

  /** Run-time type information (and related methods). */
  itkTypeMacro( WMLAdaptiveBooster, ImageToListAdaptor);


  // MJ_TEMP
    typedef  TImage ImageType; 
  //typedef itk::OrientedImage<short, 3> ImageType;

  // vector types
  typedef itk::VariableLengthVector<double> DoubleVectorType;
  typedef itk::VariableLengthVector<int> IntVectorType;
  typedef itk::VariableLengthVector<char> CharVectorType;

  typedef float                                      FloatValueType;
  typedef itk::VariableLengthVector<FloatValueType>       FloatMeasurementVectorType;
  typedef itk::Statistics::NumericsListSample<FloatMeasurementVectorType> FloatSampleType;
  typedef FloatSampleType::Pointer FloatSamplePointerType;

  typedef double                                      DoubleValueType;
  typedef itk::VariableLengthVector<DoubleValueType>       DoubleMeasurementVectorType;
  typedef itk::Statistics::NumericsListSample<DoubleMeasurementVectorType> DoubleSampleType;
  typedef DoubleSampleType::Pointer DoubleSamplePointerType;

  typedef int                                      IntValueType;
  typedef itk::VariableLengthVector<IntValueType>  IntMeasurementVectorType;
  typedef itk::Statistics::NumericsListSample<IntMeasurementVectorType> IntSampleType;


  typedef vnl_vector<double> VnlVectorType;
  typedef vnl_matrix<double> VnlMatrixType;
  typedef vnl_vector<int> VnlIntVectorType;
  typedef vnl_matrix<int> VnlIntMatrixType;



  typedef typename ImageType::Pointer ImagePointerType;

  typedef float                                      ValueType;
  typedef itk::VariableLengthVector<ValueType>       MeasurementVectorType;

  typedef itk::OrientedImage<float, 3> FloatImageType;
  typedef FloatImageType::Pointer FloatImagePointerType;

  typedef itk::OrientedImage<int, 3> IntImageType;
  typedef IntImageType::Pointer IntImagePointerType;

  typedef std::vector<ImagePointerType> ImageVectorType;
  typedef std::vector<FloatImagePointerType> FloatImageVectorType;

  typedef std::string Filename;
  typedef std::list<std::string> FilenameList;
  typedef std::list<std::string>::const_iterator FilenameListConstIter;


//  int WMLTestSingleImageKeepAllFunctionValue_NoSmooth(int id, Filename& svmFilename, ImagePointerType outimg);
//  int WMLTestSingleImageKeepAllFunctionValue_NoSmooth(int id, ImagePointerType T1Image, ImagePointerType T2Image, ImagePointerType PDImage, ImagePointerType FLImage, ImagePointerType MaskImage, ImagePointerType outimg, std::string& testfilename, std::string& svmtestoutfile, std::string& svmfilename, int have_mask);

  void WMLTestSingleImageKeepAllFunctionValue_NoSmoothPre(int id, ImagePointerType T1Image, ImagePointerType T2Image, ImagePointerType PDImage, ImagePointerType FLImage, ImagePointerType MaskImage, int have_mask, IntSampleType* list);

  void WMLTestSingleImageKeepAllFunctionValue_NoSmooth(int id, std::ostringstream& testfilename, std::ostringstream& svmtestoutfile,  std::ostringstream& svmfilename);

 // 0318
  int WMLTestSingleImageKeepAllFunctionValue_NoSmooth_NoMask(ImagePointerType T1Image, ImagePointerType T2Image, ImagePointerType PDImage, ImagePointerType FLImage, ImagePointerType FLThresholdImage, ImagePointerType outimg, std::ostringstream& testfilename, std::ostringstream&  svmtestoutfile, std::ostringstream& svmfilename);

  void InvertImgFloat(FloatImagePointerType img, FloatImagePointerType out);
  void ThresholdImage(FloatImagePointerType inimg, float threshold, int id, std::ostringstream& filename);
  void WMLGetAutoManualMaskDiff(ImageVectorType rator1Img, ImageVectorType rator2Img);

  void labelThisPoint(int k, int i, int j, ImagePointerType inpImg, ImagePointerType inpFlag, int label, ImagePointerType VoxelInStack);  

  void RegionGrowing(ImagePointerType in, int nbrSize, int GreySelected, int RegionPointNum, int GrowingOnPlan, int id); // OpeningCloseRegiongrowing3DBinaryImg_special in the original source

  void NeighboringSimilarPointsSearch(long int *PointNum, IntImagePointerType Detected_Region, int order, ImagePointerType src, ImagePointerType status, int i, int j, int k, int GreySelected, IntSampleType* Stack, ImagePointerType VoxelInStack, int nbrSize, int GrowingOnPlan); 


  void MaskOutImg(ImagePointerType img, ImagePointerType mask, float threshold, int id);
  float get_label_overlap_degree(int label, ImagePointerType img, ImagePointerType mask);

  int  IsValidVoxel_Neighbor(ImagePointerType img, itk::Index<3>  pt);


   FloatImageVectorType SVMTestImage;
   FloatImagePointerType 	FinalTestImage;
   

   ImageVectorType m_T1Image;
   ImageVectorType m_T2Image;
   ImageVectorType m_PDImage;
   ImageVectorType m_FLImage;
   // 0318
   ImageVectorType m_FLThresholdImage;
   ImageVectorType m_MaskImage;
   ImageVectorType m_PremaskImage;
   ImageVectorType m_MaskOpenImage;
  
   ImageVectorType m_AutoMaskImage;



  int m_Radius;
  int bubble_size;
  int pixelNumInBubble;
  IntSampleType::Pointer bubble;

  DoubleSampleType::Pointer  DiffStack;  
  int dim_x, dim_y, dim_z;
  double res_x, res_y, res_z;

  int m_total_line_number, m_feature_length;

  int m_total_voxel_number;

  unsigned int m_NumImages;

  IntSampleType::Pointer pos;
  IntSampleType::Pointer total_lesion_features; 
  IntSampleType::Pointer total_nonlesion_features; 
  IntSampleType::Pointer reduced_total_features;

  IntSampleType::Pointer current_features; 
  IntSampleType::Pointer reduced_current_features;  

  IntVectorType total_label;


 SVMTrainer Trainer;
 SVMTester Tester;

  itkSetMacro(total_voxel_number, int);
  itkGetMacro(total_voxel_number, int);


  itkSetMacro(threshold, float);
  itkGetMacro(threshold, float);

  IntSampleType::Pointer voxel_list;  
  IntSampleType::Pointer test_voxel_list;
 
  int m_average_manual_seg_voxel_number;
  float m_threshold;

  DoubleVectorType  m_err;  

  int m_PreIter;

  IntVectorType m_MaskVoxels;

  IntVectorType m_Nonlesion_Voxel_Number;


protected:

  WMLAdaptiveBooster();
  ~WMLAdaptiveBooster() {}
  void PrintSelf(std::ostream& os, Indent indent) const;

private:
  WMLAdaptiveBooster(const Self&); //purposely not implemented
  void operator=(const Self&); //purposely not implemented


};


} // end namespace itk

#ifndef ITK_MANUAL_INSTANTIATION
#include "itkWMLAdaptiveBooster.txx"
#endif

#endif
