#ifndef __itkWMLTestingProcessor_h
#define __itkWMLTestingProcessor_h

#include <itkImage.h>
#include <itkImageToImageFilter.h>

#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIterator.h"
#include "itkSmoothingRecursiveGaussianImageFilter.h"


#include <itkOrientedImage.h>

#define ORIENT



namespace itk {

namespace Statistics {

template<class TInputImage, class TOutputImage>
//class ITK_EXPORT WMLPreprocessor : public ImageToImageFilter<TInputImage, TOutputImage>
class ITK_EXPORT WMLTestingProcessor : public WMLProcessorBase<TInputImage, TOutputImage>
{
public:

  typedef WMLTestingProcessor Self;
//  typedef ImageToImageFilter<TInputImage, TOutputImage> Superclass;
  typedef WMLProcessorBase<TInputImage, TOutputImage> Superclass;
  typedef SmartPointer<Self>                        Pointer;
  typedef SmartPointer<const Self>                  ConstPointer;

#ifdef ORIENT
  typedef itk::OrientedImage<float, 3> FloatImageType;
#else
  typedef itk::Image<float, 3> FloatImageType;
#endif // ORIENT
  typedef FloatImageType::Pointer FloatImagePointerType;

#ifdef ORIENT
  typedef itk::OrientedImage<short, 3> ImageType;
#else
  typedef itk::Image<short, 3> ImageType;
#endif // ORIENT
  typedef ImageType::Pointer ImagePointerType;

  typedef itk::VariableLengthVector<double> DoubleVectorType;
  typedef itk::VariableLengthVector<int> IntVectorType;


  /** Method for creation through the object factory. */
  itkNewMacro(Self);

  /** Run-time type information (and related methods). */
//  itkTypeMacro(WMLPreprocessor, ImageToImageFilter);
 itkTypeMacro(WMLTestingProcessor, WMLProcessorBase);

  typedef std::vector<ImagePointerType> ImageVectorType;

  void SetT1Image (ImagePointerType T1Image);
  void SetT2Image (ImagePointerType T2Image);
  void SetPDImage (ImagePointerType PDImage);
  void SetFLImage (ImagePointerType FLImage);

  void SetNumImages(int numimg);

  void Update();

 int WMLTestSingleImageKeepAllFunctionValue_NoSmooth(ImagePointerType T1Image, ImagePointerType T2Image, ImagePointerType PDImage, ImagePointerType FLImage, ImagePointerType outimg, std::string& testfilename, std::string& svmtestoutfile, std::string& svmfilename );


  int m_NumImages;


private:
  WMLTestingProcessor(const Self&); //purposely not implemented
  void operator=(const Self&); //purposely not implemented


protected:
  WMLTestingProcessor();
 ~WMLTestingProcessor();
  void PrintSelf(std::ostream& os, Indent indent) const;

};

} // namespace itk
} // namespace Statistics

#ifndef ITK_MANUAL_INSTANTIATION
#include "itkWMLTestingProcessor.txx"
#endif

#endif
