#!/usr/bin/perl

####################################################################
#                                                                  #
#   This program iteratively corrects inhomogeneity in MRI images  #
#   last modified: Sep 27, 2007                                    #
#   Author: Zhiqiang Lao                                           #
#   Comments: Zhiqiang.Lao@uphs.upenn.edu                          #
#                                                                  #
####################################################################

$argc = @ARGV;
&show_usage if ( $argc < 1 );

$sys_path = $ENV{'PATH'};
$package_path = &my_get_string("-p", *ARGV);
$bin_path = "$package_path" . "/bin/";
$script_path = "$package_path" . "/scripts/";
$dependencies_path = "$package_path" . "/dependencies/";
$ENV{PATH}="$PATH:$sys_path:$bin_path:$script_path:$dependencies_path";

############################################################
#              Reading input parameters                    #
############################################################
$iter        = &my_get_string_with_default("-i", *ARGV, "1");
$default_temp_path = "\/tmp\/";
$temp_path   = &my_get_string_with_default("-d", *ARGV, $default_temp_path);
print "iteration: $iter\n";
$input_prefix = substr($ARGV[0], 0, length($ARGV[0])-4);
print "temp path: $temp_path\n";

chdir("$temp_path\/");
############################################################
#           Iteratively correct inhomogeneity              #
############################################################
$cmd = "SgiHeaderConvert.pl $input_prefix.hdr tmp.hdr > tmp.dat"; system($cmd) == 0 or die "$cmd failed: $?";
open TMP_DAT, "<tmp.dat";
$tmp_rec = <TMP_DAT>; @dim = split(' ', $tmp_rec);
$tmp_rec = <TMP_DAT>; @res = split(' ', $tmp_rec);
print "dim: ($dim[1], $dim[2], $dim[3])     res: ($res[1], $res[2], $res[3])\n";
close TMP_DAT;
unlink("tmp.dat");

$cmd = "cp $ARGV[0] tmp.img"; system($cmd) == 0 or die "$cmd failed: $?";
for ($i=0; $i<$iter; $i++) {
  $cmd = "n3BiasCorrection_lao.pl -i tmp.img -o out.img -p$temp_path -d$dim[1],$dim[2],$dim[3] -v$res[1],$res[2],$res[3] -g100 -t0.0005 -a100";system($cmd) == 0 or die "$cmd failed: $?";
  $cmd = "\\mv out.img tmp.img"; system($cmd) == 0 or die "$cmd failed: $?";
}
$cmd = "\\mv tmp.img $ARGV[1]"; system($cmd) == 0 or die "$cmd failed: $?";
unlink("out.imp");

#############################################################################
#############################################################################
#                  Main program stops here !!!                              #
#############################################################################
#############################################################################

# ***************************************************************************
# call format: my_get_string_with_default($option, *argument_list, $default)
# ***************************************************************************
sub my_get_string_with_default
  {
    $option = $_[0];
    (*arg_list) = $_[1];
    $default = $_[2];

    local($count) = 0;
    while ($count < ($#arg_list + 1))
      {
        if (index($arg_list[$count], $option) != -1)
          {
            print "current path: $arg_list[$count]\n";
            return (substr($arg_list[$count], 2));
          }
        $count = $count + 1;
      }
    return $default;
  }


# ******************************************************************************
# call format: exec_cmd_parallel_limited_cpu(*cmd, $number_process, $number_cpu)
# ******************************************************************************
sub exec_cmd_parallel_limited_cpu  {

  my($number_process,$number_cpu);

  (*lcmd)         = $_[0];
  $number_process = $_[1];
  $number_cpu     = $_[2];
  
  my($number_process_remain);
  $number_process_remain = $number_process % $number_cpu;
  $number_task = ($number_process - $number_process_remain) / $number_cpu;
  
  my($i,$j);
  @cmd_here = ();
  for ($i=0; $i<$number_task; $i++) {
    for ($j=0; $j<$number_cpu; $j++) {
      $cmd_here[$j] = $lcmd[$i*$number_cpu+$j];
    }
    &exec_cmd_parallel(*cmd_here, $number_cpu);
  }

  if ($number_process_remain != 0) {
    for ($j=0; $j<$number_process_remain; $j++) {
      $cmd_here[$j] = $lcmd[$number_process-$number_process_remain+$j];
    }
    &exec_cmd_parallel(*cmd_here, $number_process_remain);
  }
}

# ***************************************************************************
# call format: exec_cmd_parallel(*cmd, $number_process)
# ***************************************************************************
sub exec_cmd_parallel
  {
    my($number_process);
    (*llcmd) = $_[0];
    ($number_process) = $_[1];
    print "number of process: $number_process\n";

    for ($t=0; $t<1; $t++) {
      print "$llcmd[$t]\n";
    }

    my(@lkidpid,$p);
    @lkidpid = ();
    for ($p=0; $p<$number_process; $p++) {
      if (!defined($lkidpid[$p] = fork())) {
	die "cannot fork: $!";
      } elsif ($lkidpid[$p] == 0) {
	exec("$llcmd[$p]");
	exit;
      }
      sleep 10;
    }

    for ($p=0; $p<$number_process; $p++) {
      waitpid($lkidpid[$p], 0);
    }
  }

# **********************************************************************************
# call format: my_get_string($option, *argument_list)
# **********************************************************************************
sub my_get_string
{
   $option = $_[0];
   (*arg_list) = $_[1];

   local($count) = 0;
   while ($count < ($#arg_list + 1))
   {
      if (index($arg_list[$count], $option) != -1)
      {
         print "current path: $arg_list[$count]\n";
         return (substr($arg_list[$count], 2));
      }
      $count = $count + 1;
   }
}

# **********************************************************************************
# call format: my_get_string_list_with_default($option, *argument_list, *default)
# **********************************************************************************
sub my_get_string_list_with_default
  {
   $option = $_[0];
   (*arg_list) = $_[1];
   (*default) = $_[2];

   local($count) = 0;
   while ($count < ($#arg_list + 1)) 
     {
       if (index($arg_list[$count], $option) != -1)
	 {
	   $tmp_str = substr($arg_list[$count], 2);
	   @lst = split(/,/, substr($arg_list[$count], 2));
	   return (@lst);
	 }
       $count = $count + 1;
     }
   print "count: $count\n";
   return (@default);
 }

# **********************************************************************************
# call format: get_file_linenumber(file)
# **********************************************************************************
sub get_file_linenumber
  {
    $file = $_[0];

    open TMP, "$file";
    local($tmp_count) = 0;
    while ($record = <TMP>)
      {
	$tmp_count = $tmp_count + 1;
      }
    close TMP;

    return $tmp_count;
  }


sub show_usage
{
  print "\nUsage: $0 input_img output_img [options]\n";
  print " -p<string> : path where this package installed\n";
  print " -d<string> : path to intermediate result (default: /tmp)\n";
  print " -i <int>   : # of iteration (default: 1)\n";
  print "input_img should come along with header file\n";
  print "\n contact: Zhiqiang.Lao\@uphs.upenn.edu\n";
  exit(1);
}
