#!/usr/bin/perl

########################################################################################################################
#                                                                                                                      #
#         This includes the preprocessing applied to multispectral MRI (T1, T2, PD, FLAIR)                             #
#         last modified: Dec 28, 2007                                                                                  #
#         Author: Zhiqiang Lao, Eva Zacharaki                                                                          #
#         Comments: Zhiqiang.Lao@uphs.upenn.edu, Eva.Zacharaki@uphs.upenn.edu                                          #
#                                                                                                                      #
########################################################################################################################

$argc = @ARGV;
&show_usage if ( $argc < 1 );


$intensity_model_path = &my_get_string("-m", *ARGV);
$output_path = &my_get_string("-o", *ARGV);
$package_path = &my_get_string("-p", *ARGV);

$current_dir = `pwd`; chop($current_dir);
$current_dir = "$current_dir/";
$temp_path = "$package_path" . "/tmp/";
print "current dir: $current_dir\n";
print "package path: $package_path\n";
print "temp path: $temp_path\n";

############################################################
#              Reading input parameters                    #
############################################################
$sub_path    = &my_get_string_with_default("-s", *ARGV, $current_dir);
#$temp_path   = &my_get_string_with_default("-d", *ARGV, $current_dir);
$ACPC    = &my_get_string_with_default("-a", *ARGV, 0);
$NOTdelete    = &my_get_string_with_default("-v", *ARGV, 0);

$t1Img = $ARGV[0]; $t1Img_prefix = substr($t1Img, 0, length($ARGV[0])-4);
$t2Img = $ARGV[1]; $t2Img_prefix = substr($t2Img, 0, length($ARGV[1])-4);
$pdImg = $ARGV[2]; $pdImg_prefix = substr($pdImg, 0, length($ARGV[2])-4);
$flImg = $ARGV[3]; $flImg_prefix = substr($flImg, 0, length($ARGV[3])-4);

print "t1Img: $t1Img\tt1Img_prefix: $t1Img_prefix\n";
print "t2Img: $t2Img\tt2Img_prefix: $t2Img_prefix\n";
print "pdImg: $pdImg\tpdImg_prefix: $pdImg_prefix\n";
print "flImg: $flImg\tflImg_prefix: $flImg_prefix\n";

############################################################
#              create intermediate folder                  #
############################################################
$t1Img_cbq_img = "$t1Img_prefix" . "_cbq.img";
$t1Img_cbq_hdr = "$t1Img_prefix" . "_cbq.hdr";
$temp_sub_folder = int(100000*rand ());
$temp_folder = "$temp_path"; 	# $temp_folder = "$temp_path\/$temp_sub_folder";
mkdir($temp_folder, 0755);
chdir("$temp_folder");
print "The preprocessing will be performed in $temp_folder\n";

if (!-e "$t1Img_prefix.img") { $cmd = "cp $sub_path/$t1Img_prefix.img ."; system($cmd) == 0 or die "$cmd failed: $?";}
if (!-e "$t1Img_prefix.hdr") { $cmd = "cp $sub_path/$t1Img_prefix.hdr ."; system($cmd) == 0 or die "$cmd failed: $?";}
if (!-e "$t1Img_cbq_img")    { $cmd = "cp $sub_path/$t1Img_cbq_img .";    system($cmd) == 0 or die "$cmd failed: $?";}
if (!-e "$t1Img_cbq_hdr")    { $cmd = "cp $sub_path/$t1Img_cbq_hdr .";    system($cmd) == 0 or die "$cmd failed: $?";}
if (!-e "$t2Img_prefix.img") { $cmd = "cp $sub_path/$t2Img_prefix.img ."; system($cmd) == 0 or die "$cmd failed: $?";}
if (!-e "$t2Img_prefix.hdr") { $cmd = "cp $sub_path/$t2Img_prefix.hdr ."; system($cmd) == 0 or die "$cmd failed: $?";}
if (!-e "$pdImg_prefix.img") { $cmd = "cp $sub_path/$pdImg_prefix.img ."; system($cmd) == 0 or die "$cmd failed: $?";}
if (!-e "$pdImg_prefix.hdr") { $cmd = "cp $sub_path/$pdImg_prefix.hdr ."; system($cmd) == 0 or die "$cmd failed: $?";}
if (!-e "$flImg_prefix.img") { $cmd = "cp $sub_path/$flImg_prefix.img ."; system($cmd) == 0 or die "$cmd failed: $?";}
if (!-e "$flImg_prefix.hdr") { $cmd = "cp $sub_path/$flImg_prefix.hdr ."; system($cmd) == 0 or die "$cmd failed: $?";}


if ($ACPC){
  if (-e "$sub_path/angles.deg") {
	if (!-e "angles.deg") { $cmd = "cp $sub_path/angles.deg .";system($cmd) == 0 or die "$cmd failed: $?";}
  } else {
	warn "The $sub_path/angles.deg does not exist. Assuming no acpc-alignment (zero rotation)!\n";
	open oFH, ">angles.deg"; print oFH "0.0 0.0 0.0"; close oFH;
  }
}


############################################################
#                     Coregistration                       #
#           (FLAIR is used as reference space)             #
############################################################
print "* Registering T1, T2, PD to Flair ...\n";
$cmd = "flirt -in $t1Img_prefix.hdr -ref $flImg_prefix.hdr -out $t1Img_prefix.coreg.hdr -omat $t1Img_prefix.coreg.mat -bins 256 -cost corratio -searchrx -90 90 -searchry -90 90 -searchrz -90 90 -dof 12 -interp trilinear";
system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "flirt -in $t2Img_prefix.hdr -ref $flImg_prefix.hdr -out $t2Img_prefix.coreg.hdr -omat $t2Img_prefix.coreg.mat -bins 256 -cost normmi -searchrx -90 90 -searchry -90 90 -searchrz -90 90 -dof 12 -interp trilinear";
system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "flirt -in $pdImg_prefix.hdr -ref $flImg_prefix.hdr -applyxfm -init $t2Img_prefix.coreg.mat -out $pdImg_prefix.coreg.hdr";
system($cmd) == 0 or die "$cmd failed: $?";

# setup link for FL image, so that it name convertion is the same as T1, T2, PD
$cmd = "cp $flImg_prefix.img $flImg_prefix.coreg.img";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "cp $flImg_prefix.hdr $flImg_prefix.coreg.hdr";system($cmd) == 0 or die "$cmd failed: $?";

############################################################
#                     Smoothing images                     #
############################################################
print "* Smoothing ...\n";
$cmd = "extractVentricle4perl $t1Img_prefix.coreg.img $t1Img_prefix.coreg.smooth.img -b0.5";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "extractVentricle4perl $t2Img_prefix.coreg.img $t2Img_prefix.coreg.smooth.img -b0.5";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "extractVentricle4perl $pdImg_prefix.coreg.img $pdImg_prefix.coreg.smooth.img -b0.5";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "extractVentricle4perl $flImg_prefix.coreg.img $flImg_prefix.coreg.smooth.img -b0.5";system($cmd) == 0 or die "$cmd failed: $?";

###########################################################################################
#                                                                                         #
#     Skull-stripping T2,PD,FLAIR images according to brain mask in T1 space              #
#                                    (5 steps)                                            #
###########################################################################################


###########################################################################################
#     Skull-stripping step 1 -----> generate brain mask in acpc aligned space             #
###########################################################################################
print "* Skull stripping ...\n";
$cmd = "extractVentricle4perl $t1Img_cbq_img brain.lao.mask.img -t1";                                                        system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "OpeningCloseingRegiongrowing3DBinaryImg brain.lao.mask.img brain.lao.mask.close.img -t1 -r2";                        system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "OpeningCloseingRegiongrowing3DBinaryImg brain.lao.mask.close.img brain.lao.mask.close.rg.img -t2 -n20000 -m1 -g1658";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "OpeningCloseingRegiongrowing3DBinaryImg brain.lao.mask.close.rg.img brain.lao.mask.close.rg.open.img -t0 -r2";       system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "cp $t1Img_cbq_hdr brain.lao.mask.close.rg.open.hdr";                                                                 system($cmd) == 0 or die "$cmd failed: $?";

##########################################################################################################
#     Skull-stripping step 2 -----> transform brain mask from acpc aligned space to t1 space             #
##########################################################################################################
if ($ACPC) {
	open ANGLE, "angles.deg";
	$aaa = <ANGLE>;
	close ANGLE;
	@angle = split(' ', $aaa);
	$angle[0] = -$angle[0];  $angle[1] = -$angle[1];  $angle[2] = -$angle[2];
	print "Rotation of brain mask (extracted from t1_cbq) for acpc alignment.\n"; 
	$cmd = "anslice4volrot -r $angle[0] $angle[1] $angle[2] -b brain.lao.mask.close.rg.open.img brain.lao.mask.t1space";system($cmd) == 0 or die "$cmd failed: $?";
}
else{
	print "t1 is supposed to be in the same space as t1_cbq => no rotation\n"; 
	$cmd = "mv brain.lao.mask.close.rg.open.img   brain.lao.mask.t1space.img";system($cmd) == 0 or die "$cmd failed: $?";
}

##########################################################################################################
#     Skull-stripping step 3 -----> transform brain mask from t1 space to flair space                    #
##########################################################################################################
$cmd = "cp $t1Img_prefix.hdr brain.lao.mask.t1space.hdr"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "flirt -in brain.lao.mask.t1space.hdr -ref $flImg_prefix.hdr -applyxfm -init $t1Img_prefix.coreg.mat -out brain.lao.mask.flspace.hdr"; system($cmd) == 0 or die "$cmd failed: $?";

##########################################################################################################
#     Skull-stripping step 4 -----> threshold brain mask in flair space to get actual mask               #
##########################################################################################################
$cmd = "extractVentricle4perl brain.lao.mask.flspace.img brain.lao.mask.flspace.threshold.img -t150"; system($cmd) == 0 or die "$cmd failed: $?";


#####################################################################################################################################
#     Skull-stripping step 5 -----> use actual brain mask in flair space to skull strip all modalities in flair space               #
#####################################################################################################################################
$cmd = "MaskOutImg $t1Img_prefix.coreg.smooth.img brain.lao.mask.flspace.threshold.img $t1Img_prefix.coreg.smooth.brain.img -t1"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "MaskOutImg $t2Img_prefix.coreg.smooth.img brain.lao.mask.flspace.threshold.img $t2Img_prefix.coreg.smooth.brain.img -t1"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "MaskOutImg $pdImg_prefix.coreg.smooth.img brain.lao.mask.flspace.threshold.img $pdImg_prefix.coreg.smooth.brain.img -t1"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "MaskOutImg $flImg_prefix.coreg.smooth.img brain.lao.mask.flspace.threshold.img $flImg_prefix.coreg.smooth.brain.img -t1"; system($cmd) == 0 or die "$cmd failed: $?";


#####################################################################
#     Inhomogeneity corrrection for correcting evenodd effect       #
#####################################################################
print "* Inhomogeneity correction ...\n";
$cmd = "InhomoCorrection_improve_again $t1Img_prefix.coreg.smooth.brain.img $t1Img_prefix.coreg.smooth.brain.img -t33 -c0";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "InhomoCorrection_improve_again $t2Img_prefix.coreg.smooth.brain.img $t2Img_prefix.coreg.smooth.brain.img -t33 -c0";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "InhomoCorrection_improve_again $pdImg_prefix.coreg.smooth.brain.img $pdImg_prefix.coreg.smooth.brain.img -t33 -c0";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "InhomoCorrection_improve_again $flImg_prefix.coreg.smooth.brain.img $flImg_prefix.coreg.smooth.brain.img -t33 -c0";system($cmd) == 0 or die "$cmd failed: $?";


##########################################################################################################
#     Inhomogeneity corrrection using N3 (Nonparametric Nonuniform intensity Normalization)              #
##########################################################################################################
$cmd = "cp $flImg_prefix.hdr $t1Img_prefix.coreg.smooth.brain.hdr"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "cp $flImg_prefix.hdr $t2Img_prefix.coreg.smooth.brain.hdr"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "cp $flImg_prefix.hdr $pdImg_prefix.coreg.smooth.brain.hdr"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "cp $flImg_prefix.hdr $flImg_prefix.coreg.smooth.brain.hdr"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "inhomocorrectionn3lao.pl $t1Img_prefix.coreg.smooth.brain.img $t1Img_prefix.coreg.smooth.brain.correct.img -i6 -d$temp_folder";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "inhomocorrectionn3lao.pl $t2Img_prefix.coreg.smooth.brain.img $t2Img_prefix.coreg.smooth.brain.correct.img -i6 -d$temp_folder";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "inhomocorrectionn3lao.pl $pdImg_prefix.coreg.smooth.brain.img $pdImg_prefix.coreg.smooth.brain.correct.img -i6 -d$temp_folder";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "inhomocorrectionn3lao.pl $flImg_prefix.coreg.smooth.brain.img $flImg_prefix.coreg.smooth.brain.correct.img -i9 -d$temp_folder";system($cmd) == 0 or die "$cmd failed: $?";


##########################################################################################################
#     Intensity normalization based on historgram matching                                               #
##########################################################################################################
print "* Histogram matching ...\n";
$intensity_model_path = "$package_path" . "/model/ACCORD_Intensity/";

$t1_model  = "$intensity_model_path" . "t1.model.resample.img";
$t2_model  = "$intensity_model_path" . "t2.model.resample.img";
$pd_model  = "$intensity_model_path" . "pd.model.resample.img";
$fl_model  = "$intensity_model_path" . "flair.model.resample.img";

print "t1_model: $t1_model\n";
print "t2_model: $t2_model\n";
print "pd_model: $pd_model\n";
print "fl_model: $fl_model\n";

print "MatchHistogramsOfImgA2ImgB_special $t1Img_prefix.coreg.smooth.brain.correct.img $t1_model $t1Img_prefix.coreg.smooth.brain.correct.match.img -s5.0 -t5\n";

$cmd = "MatchHistogramsOfImgA2ImgB_special $t1Img_prefix.coreg.smooth.brain.correct.img $t1_model $t1Img_prefix.coreg.smooth.brain.correct.match.img -s5.0 -t5";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "MatchHistogramsOfImgA2ImgB_special $t2Img_prefix.coreg.smooth.brain.correct.img $t2_model $t2Img_prefix.coreg.smooth.brain.correct.match.img -s5.0 -t5";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "MatchHistogramsOfImgA2ImgB_special $pdImg_prefix.coreg.smooth.brain.correct.img $pd_model $pdImg_prefix.coreg.smooth.brain.correct.match.img -s5.0 -t5";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "MatchHistogramsOfImgA2ImgB_special $flImg_prefix.coreg.smooth.brain.correct.img $fl_model $flImg_prefix.coreg.smooth.brain.correct.match.img -s5.0 -f";system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "cp $flImg_prefix.hdr $t1Img_prefix.coreg.smooth.brain.correct.match.hdr"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "cp $flImg_prefix.hdr $t2Img_prefix.coreg.smooth.brain.correct.match.hdr"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "cp $flImg_prefix.hdr $pdImg_prefix.coreg.smooth.brain.correct.match.hdr"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "cp $flImg_prefix.hdr $flImg_prefix.coreg.smooth.brain.correct.match.hdr"; system($cmd) == 0 or die "$cmd failed: $?";


##########################################################################################################
#     Remove eye tissue in skull-stripped FLAIR image                                                    #
##########################################################################################################
print "*  Removing eye tissue ...\n";
$cmd = "WMLRemoveEyeInFlair_improve_again $flImg_prefix.coreg.smooth.brain.correct.match.img $flImg_prefix.coreg.smooth.brain.correct.match.noeye.img -i35 -r0.1,0.998";system($cmd) == 0 or die "$cmd failed: $?";


##########################################################################################################
#                     Generate premask in FLAIR space                                                    #
##########################################################################################################
$cmd = "cp $flImg_prefix.hdr $flImg_prefix.coreg.smooth.brain.correct.match.noeye.hdr"; system($cmd) == 0 or die "$cmd failed: $?";
$cmd = "fast -t1 -c 6 -od $flImg_prefix.coreg.smooth.brain.correct.match.noeye $flImg_prefix.coreg.smooth.brain.correct.match.noeye";system($cmd) == 0 or die "$cmd failed: $?";
# keep as lesion.premask the brain part segmented with label=6 :
$cmd = "extractVentricle4perl $flImg_prefix.coreg.smooth.brain.correct.match.noeye_seg.img $flImg_prefix.lesion.premask.img -s6";system($cmd) == 0 or die "$cmd failed: $?";


print "\nThe preprocessing finished.\n\n";

##########################################################################################################
#                   				clean 			                         #
##########################################################################################################
$cmd = "\\rm tmp* *coreg.img  *coreg.hdr *smooth.img  *brain.img *brain.hdr *correct.img  brain.lao.mask.* ";
if (!$NOTdelete) {
#	system($cmd) == 0 or die "$cmd failed: $?";
#mjkim
	print "Temp files NOT deleted.\n";
}

chdir($current_dir);

#############################################################################
#############################################################################
#                  Main program stops here !!!                              #
#############################################################################
#############################################################################



#############################################################################
#############################################################################
#                  Followings are subroutines                               #
#############################################################################
#############################################################################

###############################################################################
# call format: my_get_string_with_default($option, *argument_list, $default)  #
###############################################################################
sub my_get_string_with_default
  {
    $option = $_[0];
    (*arg_list) = $_[1];
    $default = $_[2];

    local($count) = 0;
    while ($count < ($#arg_list + 1))
      {
        if (index($arg_list[$count], $option) != -1)
          {
            print "current path: $arg_list[$count]\n";
            return (substr($arg_list[$count], 2));
          }
        $count = $count + 1;
      }
    return $default;
  }



####################################################################################
#            call format: my_get_string($option, *argument_list)                   #
####################################################################################
sub my_get_string
  {
    $option = $_[0];
    (*arg_list) = $_[1];

    local($count) = 0;
    while ($count < ($#arg_list + 1))
      {
	if (index($arg_list[$count], $option) != -1)
	  {
	    print "current path: $arg_list[$count]\n";
	    return (substr($arg_list[$count], 2));
	  }
	$count = $count + 1;
      }
  }


####################################################################################
# call format: my_get_string_list_with_default($option, *argument_list, *default)  #
####################################################################################
sub my_get_string_list_with_default
  {
   $option = $_[0];
   (*arg_list) = $_[1];
   (*default) = $_[2];

   local($count) = 0;
   while ($count < ($#arg_list + 1)) 
     {
       if (index($arg_list[$count], $option) != -1)
	 {
	   $tmp_str = substr($arg_list[$count], 2);
	   @lst = split(/,/, substr($arg_list[$count], 2));
	   return (@lst);
	 }
       $count = $count + 1;
     }
   print "count: $count\n";
   return (@default);
 }


####################################################################################
#                  call format: get_file_linenumber(file)                          #
####################################################################################
sub get_file_linenumber
  {
    $file = $_[0];

    open TMP, "$file";
    local($tmp_count) = 0;
    while ($record = <TMP>)
      {
	$tmp_count = $tmp_count + 1;
      }
    close TMP;

    return $tmp_count;
  }


####################################################################################
#                             call format: show_uage                               #
####################################################################################
sub show_usage
{
  print "******************************************************************\n";
  print "*           White Matter Lesion Segmentation Protocol            *\n";
  print "*                                                                *\n";
  print "*          -by Zhiqiang Lao                                      *\n";
  print "*                                                                *\n";
  print "*        Section for Biomedical Image Analysis                   *\n";
  print "*        Department of Radiology, University of Pennsylvania     *\n";
  print "*        3600 Market ST, Suite 380                               *\n";
  print "*        Philadelphia, PA 19104                                  *\n";
  print "*                                                                *\n";
  print "******************************************************************\n";
  print "\n\nUsage: $0 t1_img t2_img pd_img flair_img [options]\n\n";
  print "Additionally to the 4 input images, it is assumed that the t1_cbq.img should exist,\n";
  print "which is the t1 image with the cerebellum removed (in the same space).\n\n";
  print "-s<string>                        : path to input image (default: .)\n";
  print "-d<string>                        : path to output image (default: /tmp)\n";
  print "-m<string>                        : path for the intensity model\n";
  print "-a<int>                           : give 1, if the t1_cbq is acpc aligned and the t1 is not;\n";
  print "                                    In this case, the file \"angles.deg\" should exist.\n";
  print "                                    (default: 0; both in same space, no \"angles.deg\" required); \n";
  print "-v<int>                           : give 1, if you don't want to delete the intermediate files (default: 0)\n";
  print "\n contact: Eva.Zacharaki\@uphs.upenn.edu\n";
  exit(1);
}
