#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "dbh.h"

#define UNITS "mm"

void make_hdr(char *fname,
	      int width,
	      int height,
	      int depth,
	      int numvol,
	      char *datatype,
	      int max,
	      int min, /* file x y z t datatype max min */
	      float voxel[3],
	      int flipped)
{
    int i;
    struct dsr hdr;
    FILE *fp;
    static char DataTypes[9][12] = {"UNKNOWN","BINARY","CHAR","SHORT", 
				    "INT","FLOAT","COMPLEX","DOUBLE","RGB"};
    
    static int DataTypeSizes[9] = {0,1,8,16,32,32,64,64,24};
    
    memset(&hdr,0, sizeof(struct dsr));
    for(i=0;i<8;i++)
    	hdr.dime.pixdim[i]=0.0;
   
    hdr.dime.vox_offset = 0.0;
    hdr.dime.roi_scale   = 1.0;
    hdr.dime.funused1    = 0.0;
    hdr.dime.funused2    = 0.0;
    hdr.dime.cal_max     = 0.0;
    hdr.dime.cal_min     = 0.0;
  
    
    hdr.dime.datatype = -1;

    for(i=1;i<=8;i++)
    	if(!strcmp(datatype,DataTypes[i]))
    	{
    		hdr.dime.datatype = (1<<(i-1));
    		hdr.dime.bitpix = DataTypeSizes[i];
    		break;
    	}
    		
    if(hdr.dime.datatype <= 0)
    {
    	printf("MakeHeader: <%s> is an unacceptable datatype \n\n", datatype);
        exit(0);
    }
 
    if((fp=fopen(fname,"w"))==0)
    {
        printf("unable to create: %s\n",fname);
        exit(0);
    }

    hdr.dime.dim[0] = 4;  /* all Analyze images are taken as 4 dimensional */
    hdr.hk.regular = 'r';
    hdr.hk.sizeof_hdr = sizeof(struct dsr);

    hdr.dime.dim[1] = width;   /* slice width  in pixels */
    hdr.dime.dim[2] = height;  /* slice height in pixels */
    hdr.dime.dim[3] = depth;   /* volume depth in slices */
    hdr.dime.dim[4] = numvol;  /* number of volumes per file */

    hdr.dime.glmax  = max;     /* maximum voxel value  */
    hdr.dime.glmin  = min;     /* minimum voxel value */
    
/*	Set the voxel dimension fields: 
       A value of 0.0 for these fields implies that the value is unknown.
         Change these values to what is appropriate for your data
         or pass additional command line arguments     */      
         
    hdr.dime.pixdim[1] = voxel[0]; /* voxel x dimension */
    hdr.dime.pixdim[2] = voxel[1]; /* voxel y dimension */
    hdr.dime.pixdim[3] = voxel[2]; /* pixel z dimension, slice thickness */
    
/*   Assume zero offset in .img file, byte at which pixel
       data starts in the image file */

    hdr.dime.vox_offset = 0.0; 
    
/*   Planar Orientation;    */
/*   Movie flag OFF: 0 = transverse, 1 = coronal, 2 = sagittal
     Movie flag ON:  3 = transverse, 4 = coronal, 5 = sagittal  */  

    hdr.hist.orient     = 3*flipped;
    
/*   up to 3 characters for the voxels units label; i.e. 
    	mm., um., cm.               */

    strcpy(hdr.dime.vox_units,UNITS);
   
/*   up to 7 characters for the calibration units label; i.e. HU */

    strcpy(hdr.dime.cal_units," ");  
    
/*     Calibration maximum and minimum values;  
       values of 0.0 for both fields imply that no 
       calibration max and min values are used    */

    hdr.dime.cal_max = 0.0; 
    hdr.dime.cal_min = 0.0;

    fwrite(&hdr,sizeof(struct dsr),1,fp);
    fclose(fp);
}

