#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <math.h>
#include <strings.h>
#include <mvcd.h>
#include <cres.h>
#include <matrixSHEN.h>  /*by SHEN*/

#define BASIC_R        0

void  ReadImg(char filename[80], unsigned char ***vol, Ivector3d dim);
void  WriteImg(char filename[80], unsigned char ***data, Ivector3d dim);
void  ReadImgF(char filename[80], float ***vol, Ivector3d dim);
void  WriteImgF(char filename[80], float ***data, Ivector3d dim);
void  ThresholdImage(int argc, char **argv, int format, float threshold, Ivector3d dim);
void  show_usage(int argc, char **argv) ;
void  GenerateDistanceMap(int argc, char **argv, Ivector3d dim, Fvector3d res);
void  binary3DDilation(unsigned char ***mask_in, unsigned char ***mask_out, Ivector3d dim, unsigned char ***SE, 
		       Ivector3d dim_SE, Ivector3d cen, int label);
void  binary3DDilation_improve(unsigned char ***ar, Fvector3d res, int dilationSize, Ivector3d dim, unsigned char ***out);
void  PrintSE(unsigned char ***SE);
int   GetImgZDim(char file[1000], Ivector3d dim);
int   GetImgZDim_float(char file[1000], Ivector3d dim);
float gaussian(float x, float s);
int   IsPtInLst(Fvector3d pt, Ivector3d *lst, int lst_len);
void  calculate_hood_special(Fvector3d *bubble,int bubble_size, int *pixelNumInBubble, Fvector3d res);
void  calculate_hood_special_improve(Ivector3d *bubble,int bubble_size, int *pixelNumInBubble, Fvector3d res);
void  Smooth3DImageShapeBased(int argc, char *argv[], float Smooth_Sigma, int SmoothTimes, int FocusIntensity, Ivector3d dim, 
			      Fvector3d res);

int main(int argc,char *argv[])
{
  Ivector3d        dim, delta;
  Fvector3d        res;
  int              c, CSF_range[2], GM_range[2], WM_range[2], i, j, k, format, method, SmoothTimes, FocusIntensity;
  float            threshold, ***in_float, Smooth_Sigma;
  unsigned char    ***in, ***out;
  FILE             *fp;

  if(argc<2) show_usage(argc, argv);

  CSF_range[0] = 0;        CSF_range[1] = 50;
  GM_range[0] = 50;        GM_range[1] = 150;
  WM_range[0] = 150;       WM_range[1] = 255;

  dim.x = dim.y = 256;        dim.z = 124;
  format = 0;
  method = 0;
  res.x = res.y = 0.9375;     res.z = 1.5;
  Smooth_Sigma = 1.0;
  SmoothTimes = 1;

  while((c=getopt(argc-2,argv+2,"d:v:t:f:m:p:")) != -1) {
    switch(c) {
    case 'd':
      sscanf(optarg, "%d,%d", &dim.x, &dim.y);
      break;
      
    case 'v':
      sscanf(optarg, "%f,%f,%f", &res.x, &res.y, &res.z);
      break;

    case 't':
      threshold = atof(optarg);
      break;

    case 'f':
      format = atoi(optarg);
      break;

    case 'm':
      method = atoi(optarg);
      break;

    case 'p':
      /*Smooth_Sigma=atof(optarg);*/
      sscanf(optarg, "%f,%d,%d", &Smooth_Sigma, &SmoothTimes, &FocusIntensity);
      break;
      
    default:
      break;
    }
  }

  if (format == 0) dim.z = GetImgZDim(argv[1], dim);
  if (format == 1) dim.z = GetImgZDim_float(argv[1], dim);
  printf("dimension: (%d, %d, %d)\n", dim.x, dim.y, dim.z);
  printf("resolution: (%f, %f, %f)\n", res.x, res.y, res.z);
  printf("threshold: %f\n", threshold);
  printf("format: %d\n", format);
  printf("method: %d\n", method);

  switch (method) {
  case 0:
    ThresholdImage(argc, argv, format, threshold, dim);
    break;

  case 1:
    GenerateDistanceMap(argc, argv, dim, res);
    break;

  case 2:
    Smooth3DImageShapeBased(argc, argv, Smooth_Sigma, SmoothTimes, FocusIntensity, dim, res);
    break;

  default:
    break;
  }

  return 0;
}

void ThresholdImage(int argc, char **argv, int format, float threshold, Ivector3d dim)
{
  unsigned char    ***in, ***out;
  float            ***in_float;
  FILE             *fp;
  int              i, j, k;

  switch (format) {
  case 0:
    fp = fopen(argv[1], "r");
    fseek(fp,0,SEEK_END);
    dim.z = (ftell(fp))/(dim.x*dim.y);
    fclose(fp);
    break;

  case 1:
    fp = fopen(argv[1], "r");
    fseek(fp,0,SEEK_END);
    dim.z = (ftell(fp))/(dim.x*dim.y*sizeof(float));
    fclose(fp);
    break;

  default:
    break;
  }
  printf("dimension: (%d, %d, %d)\n", dim.x, dim.y, dim.z);
  printf("threshold: %f\n", threshold);
  printf("format: %d\n", format);

  out = UCalloc3d(dim.x, dim.y, dim.z);
  switch (format) {
  case 0: // byte
    in = UCalloc3d(dim.x, dim.y, dim.z);
    ReadImg(argv[1], in, dim);
    
    for (k=0; k<dim.z; k++)
      for (i=0; i<dim.x; i++)
	for (j=0; j<dim.y; j++)
	  if (in[k][i][j]>(int)threshold) out[k][i][j] = 255;
	  else out[k][i][j] = 0;
    UCfree3d(in, dim.z, dim.x);
    break;

  case 1: // float
    in_float = Falloc3d(dim.x, dim.y, dim.z);
    ReadImgF(argv[1], in_float, dim);
    
    for (k=0; k<dim.z; k++)
      for (i=0; i<dim.x; i++)
	for (j=0; j<dim.y; j++) 
	  if (in_float[k][i][j]>=threshold) out[k][i][j] = 255;
	  else out[k][i][j] = 0;
    Ffree3d(in_float, dim.z, dim.x);
    break;

  default:
    break;
  }
  WriteImg(argv[2], out, dim);
  UCfree3d(out, dim.z, dim.x);
}

void GenerateDistanceMap(int argc, char **argv, Ivector3d dim, Fvector3d res)
{
  FILE             *fp;
  unsigned char    ***SE, ***InMsk, ***DstMap, ***tmpmask1, ***tmpmask2;
  Ivector3d        dim_SE, cen, cen_SE;
  int              i, j, k, d;
  char             filename[100];
  //  Fvector3d        res;

  printf("enter GenerateDistanceMap\n");
  printf("dimension: (%d, %d, %d)\n", dim.x, dim.y, dim.z);

  InMsk = UCalloc3d(dim.x, dim.y, dim.z);
  ReadImg(argv[1], InMsk, dim);
  printf("%s read ok\n", argv[1]);

  dim_SE.x = 3;  dim_SE.y = 3;  dim_SE.z = 3;
  SE = UCalloc3d(dim_SE.x, dim_SE.y, dim_SE.z);
  for (k=0; k<3; k++)
    for (i=0; i<3; i++)
      for (j=0; j<3; j++) SE[k][i][j] = 0;

  SE[0][1][1]=1;
  SE[1][1][0]=1;  SE[1][1][1]=1;  SE[1][1][2]=1;  SE[1][0][1]=1;  SE[1][2][1]=1;
  SE[2][1][1]=1;

  cen_SE.x = 1;  cen_SE.y = 1;  cen_SE.z = 1;

  tmpmask1 = UCalloc3d(dim.x, dim.y, dim.z);
  tmpmask2 = UCalloc3d(dim.x, dim.y, dim.z);
  DstMap   = UCalloc3d(dim.x, dim.y, dim.z);

  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++) {
	DstMap[k][i][j]   = InMsk[k][i][j];
	tmpmask1[k][i][j] = InMsk[k][i][j];
	tmpmask2[k][i][j] = InMsk[k][i][j];
      }

  for (d=1; d<80; d++) {
    printf("dist = %d ", d);fflush(stdout);
    //    binary3DDilation(tmpmask1, tmpmask2, dim, SE, dim_SE, cen, 255);//WriteImg("tmp1.img", tmpmask2, dim);
    binary3DDilation_improve(tmpmask1, res, 1, dim, tmpmask2);
    for (k=0; k<dim.z; k++)
      for (i=0; i<dim.x; i++)
	for (j=0; j<dim.y; j++) 
	  if ((tmpmask1[k][i][j] == 0) && (tmpmask2[k][i][j] != 0)) DstMap[k][i][j] = d;
    //    sprintf(filename, "DstMap.%d.img", d);
    //    WriteImg(filename, DstMap, dim);
    //    PrintSE(SE);

    for (k=0; k<dim.z; k++)
      for (i=0; i<dim.x; i++)
	for (j=0; j<dim.y; j++) tmpmask1[k][i][j] = tmpmask2[k][i][j];
    //    WriteImg("DstMap.img", DstMap, dim);exit(1);
  }
  printf("\n");
  WriteImg(argv[2], DstMap, dim);
  printf("%s saved\n", argv[2]);

  UCfree3d(tmpmask1, dim.z, dim.x);
  UCfree3d(tmpmask2, dim.z, dim.x);
  UCfree3d(InMsk, dim.z, dim.x);
  UCfree3d(DstMap, dim.z, dim.x);
  UCfree3d(SE, 3, 3);
}

void PrintSE(unsigned char ***SE)
{
  int        i, j, k;

  for (k=0; k<3; k++) {
    for (i=0; i<3; i++) {
      for (j=0; j<3; j++) printf("%d ", SE[k][i][j]);
      printf("\n");
    }
    printf("\n\n");
  }
}

void binary3DDilation(unsigned char ***mask_in, unsigned char ***mask_out, Ivector3d dim, unsigned char ***SE, Ivector3d dim_SE, Ivector3d cen, int label)
{
  int        i, j, k, ii, jj, kk, iii, jjj, kkk;
  
  for (k=0; k<dim.z; k++)
    for (i=0; i<dim.x; i++)
      for (j=0; j<dim.y; j++) 
	if (mask_in[k][i][j] == label)
	  for (kk=0; kk<3; kk++)
	    for (ii=0; ii<3; ii++)
	      for (jj=0; jj<3; jj++)
		if (SE[kk][ii][jj]==1) {
		  
		  iii = ii - cen.x + i; jjj = jj - cen.y + j; kkk = kk - cen.z + k;
		  if ((iii>=0) && (iii<dim.x) && (jjj>=0) && (jjj<dim.y) && (kkk>=0) && (kkk<dim.z)) mask_out[kkk][iii][jjj] = label;
		  //		  printf("(i, j, k): (%d, %d, %d) -----> (iii, jjj, kkk): (%d, %d, %d)\n", i, j, k, iii, jjj, kkk);exit(1);
		}
}

void binary3DDilation_improve(unsigned char ***ar, Fvector3d res, int dilationSize, Ivector3d dim, unsigned char ***out)
{
  float            ratio, rat2;
  Ivector3d        *index;
  int              nbhd_size, Rz, kk, ii, jj, i, j, k, temp1, temp2, zs, xs;

  ratio = res.x / res.z;
  rat2 = ratio * ratio;
  
  /**** Determine the structuring element ***/
  index=Ivector3dalloc1d(10000);
  nbhd_size=0;
  Rz=(int) (dilationSize*ratio+0.5);
  if(Rz==0) Rz=1;
  for(kk=-Rz;kk<=Rz;kk++) {
    temp1=(int) (sqrt((double) (Rz*Rz-kk*kk)/rat2)+0.5);
    for(ii=-temp1;ii<=temp1;ii++) {
      temp2=(int) (sqrt((double) (temp1*temp1-ii*ii))+0.5);
      for(jj=-temp2;jj<=temp2;jj++) {
	index[nbhd_size].z=kk;	index[nbhd_size].x=ii;	index[nbhd_size].y=jj;
	nbhd_size++;
      }
    }
  }
  
  printf("nbhd_size=%d\n",nbhd_size);
  for(k=0;k<dim.z-0;k++){
    printf(".");fflush(stdout);
    for(i=0;i<dim.x-0;i++){
      for(j=0;j<dim.y-0;j++){
	if(ar[k][i][j] != 0){
	  
	  for(ii=0;ii<nbhd_size;ii++){
	    if(k+index[ii].z>=0 && k+index[ii].z<dim.z && 
	       i+index[ii].x>=0 && i+index[ii].x<dim.x && 
	       j+index[ii].y>=0 && j+index[ii].y<dim.y){
	      out[k+index[ii].z][i+index[ii].x][j+index[ii].y]=255;
	      //	      status[k+index[ii].z][i+index[ii].x][j+index[ii].y]=1;
	    }
	  }
	}
      }
    }
  }
  printf("\n");
  free(index);
}


void show_usage(int argc, char **argv)
{
  printf("USAGE: %s <input_img> <output_img> \n\
\t   -d<int>,<int>             : image dimension XY (default: 256,256)\n\
\t   -v<float>,<float>,<float> : image resolution (default: 0.9375,0.9375,1.5)\n\
\t   -t<int>                   : threshold (default: 50)\n\
\t   -p <float,int,int>      : blur 3D image by shape-based Guassian filter (1.0) and smoothing time (2), with strongness of intensity to focus (6=20/3). Here, the boundary voxels will not blurred by bacground\n\
\t   -m<int>                   : type of operation (default: 0)\n\
\t                               0 threshold image\n\
\t                               1 create distance map for input mask image\n\
\t                               2 smooth with edge preserving\n\
\t   -f<int>                   : image format 0: byte 1: float (default: 0)\n\
", argv[0]);
  exit(1);
}

void ReadImg(char filename[80], unsigned char ***vol, Ivector3d dim)
{
   FILE   *fp;
   int    i, j, k;

   fp = fopen(filename, "r");
   for (k=0; k<dim.z; k++)
      for (i=0; i<dim.x; i++)
         fread(vol[k][i], 1, dim.y, fp);
   fclose(fp);
}

void ReadImgF(char filename[80], float ***vol, Ivector3d dim)
{
   FILE   *fp;
   int    i, j, k;

   fp = fopen(filename, "r");
   for (k=0; k<dim.z; k++)
      for (i=0; i<dim.x; i++)
         fread(vol[k][i], sizeof(float), dim.y, fp);
   fclose(fp);
}


void WriteImg(char filename[80], unsigned char ***data, Ivector3d dim)
{
  FILE  *fp;
  int   i, k ;

  fp=fopen(filename,"w");
  for(k=0;k<dim.z;k++)
    for(i=0;i<dim.x;i++) fwrite(data[k][i],1,dim.y,fp);
  fclose(fp);
}

void WriteImgF(char filename[80], float ***data, Ivector3d dim)
{
  FILE  *fp;
  int   i, k ;

  fp=fopen(filename,"w");
  for(k=0;k<dim.z;k++)
    for(i=0;i<dim.x;i++) fwrite(data[k][i],sizeof(float),dim.y,fp);
  fclose(fp);
}

void Smooth3DImageShapeBased(int argc, char *argv[], float Smooth_Sigma, int SmoothTimes, int FocusIntensity, 
			     Ivector3d dim, Fvector3d res)
{
  unsigned char         ***src;
  FILE                  *fp;
  float                 ***Density, ***outp, src_nonZeroNum, src_TotalIntensities, Current_nonZeroNum, Current_TotalIntensities;

  /* variables for Guassian filetering */
  int                   i, j, k, l, ii, jj, kk, efficient, num, filter_width;   /* length of 1-D gaussian mask */
  float                 a,b,c,d;        /* mask generation intermediate vars*/
  float                 ti,tj,tk,total,weights, r, ***G, TotalWeight, filterCoefficientThreshold, iii, jjj, kkk;

  filterCoefficientThreshold = 0.1; /* 0.005 */
  printf("\n\nStarting ...\nSmooth_Sigma=%f\nfilterCoefficientThreshold=%f\n", Smooth_Sigma, filterCoefficientThreshold);

  /* apply for memory */ 
  src     = UCalloc3d(dim.x, dim.y, dim.z);
  outp    = Falloc3d(dim.x, dim.y, dim.z);
  Density = Falloc3d(dim.x,dim.x, dim.z);

  /* read data */ 
  ReadImg(argv[1], src, dim);

  /* reset ... */
  for(k=0; k<dim.z; k++)
    for(i=0; i<dim.x; i++)
      for(j=0; j<dim.y; j++) outp[k][i][j] = 0;
	
  /* calc coeffs for 1-dimensional G, dG/dn and Delta-squared G filters */
  for(i=0; i<100; i++) {
    a=gaussian(i, Smooth_Sigma);
    if(a<filterCoefficientThreshold) {  filter_width=i; break; }
  }
  filter_width --;
  printf("filter_width=%d\n", filter_width);
  
  G = Falloc3d(filter_width*2+1, filter_width*2+1, filter_width*2+1);
  for(kk=-filter_width; kk<=filter_width; kk++)
    for(ii=-filter_width; ii<=filter_width; ii++)
      for(jj=-filter_width; jj<=filter_width; jj++) {

	iii = (float)ii*res.x; jjj = (float)jj*res.y; kkk = (float)kk*res.z;
	r = sqrt(iii*iii+jjj*jjj+kkk*kkk);
	
	a=gaussian(r, Smooth_Sigma);
	if(a>filterCoefficientThreshold || r<2.) 
	  G[kk+filter_width][ii+filter_width][jj+filter_width]=a/(6.283185*Smooth_Sigma*Smooth_Sigma);
      }

  /* normalize ... */
  weights = 0;
  for(kk=-filter_width; kk<=filter_width; kk++)
    for(ii=-filter_width; ii<=filter_width; ii++)
      for(jj=-filter_width; jj<=filter_width; jj++) weights += G[kk+filter_width][ii+filter_width][jj+filter_width];
  
  for(kk=-filter_width; kk<=filter_width; kk++) 
    for(ii=-filter_width; ii<=filter_width; ii++)
      for(jj=-filter_width; jj<=filter_width; jj++) G[kk+filter_width][ii+filter_width][jj+filter_width] /= weights;

  /* print */
  for(kk=-filter_width; kk<=filter_width; kk++) {
    for(ii=-filter_width; ii<=filter_width; ii++) {
      for(jj=-filter_width; jj<=filter_width; jj++) printf(" %f ", G[kk+filter_width][ii+filter_width][jj+filter_width]);      
      printf("\n");
    }
    printf("\n");
  }
  //  exit(1);

  /* beginning ... */  
  /* produce x-, y- and z- convolutions with gaussian filter */
  for(k=0; k<dim.z; k++)
    for(i=0; i<dim.x; i++)
      for(j=0; j<dim.y; j++) Density[k][i][j] = src[k][i][j];

  for( num=0; num<SmoothTimes; num++ ) {
    printf("The %dth smoothing time ...\n", num);
    //    for( i=0; i<dim.x; i++ ) {
    for( k=0; k<dim.z; k++ ) {
      if(k%1==0) printf("k=%d\n", k);
	  
      for( i=0; i<dim.x; i++ )
	for( j=0; j<dim.y; j++ ) {
	  if( src[k][i][j]>FocusIntensity ) {
	    total = 0;
	    TotalWeight = 0;
	    for(kk=-filter_width; kk<=filter_width; kk++)
	      for(ii=-filter_width; ii<=filter_width; ii++)
		for(jj=-filter_width; jj<=filter_width; jj++) {
		  //		for(kk=-filter_width; kk<=filter_width; kk++) {
		  if(k+kk>=0 && k+kk<dim.z && i+ii>=0 && i+ii<dim.x && j+jj>=0 && j+jj<dim.y) {
		    if(src[k+kk][i+ii][j+jj]>FocusIntensity ) {
		      //	      TotalWeight += G[ii+filter_width][jj+filter_width][kk+filter_width];
		      //	      total +=  G[ii+filter_width][jj+filter_width][kk+filter_width]*Density[k+kk][i+ii][j+jj]; 
		      TotalWeight += G[kk+filter_width][ii+filter_width][jj+filter_width];
		      total +=  G[kk+filter_width][ii+filter_width][jj+filter_width]*Density[k+kk][i+ii][j+jj];
		    }
		  }
		}
	    total /= TotalWeight;
	    outp[k][i][j] = total;
	  } else outp[k][i][j] = Density[k][i][j];
	}
    }
      
    /* switching ... */
    for( k=0; k<dim.z; k++ )
      for( i=0; i<dim.x; i++ )
	for( j=0; j<dim.y; j++ ) Density[k][i][j] = outp[k][i][j];
	//	for( k=0; k<dim.z; k++ ) Density[k][i][j] = outp[k][i][j];
  }

  /* total intensities normalization */
  src_nonZeroNum = 0;
  src_TotalIntensities = 0;
  Current_nonZeroNum = 0;
  Current_TotalIntensities = 0;
  for(k=0; k<dim.z; k++)
    for(i=0; i<dim.x; i++)
      for(j=0; j<dim.y; j++) {
      //      for(k=0; k<dim.z; k++) {
	if( outp[k][i][j]>0 ) {
	  Current_nonZeroNum ++;
	  Current_TotalIntensities += outp[k][i][j];
	}
	if( src[k][i][j]>0 ) {
	  src_nonZeroNum ++;
	  src_TotalIntensities += src[k][i][j];
	}
      }
  printf("original: average=%f, num=%f\n",     src_TotalIntensities/src_nonZeroNum,     src_nonZeroNum);
  printf("current:  average=%f, num=%f\n", Current_TotalIntensities/Current_nonZeroNum, Current_nonZeroNum);
  for( k=0; k<dim.z; k++ )
    for( i=0; i<dim.x; i++ )
      for( j=0; j<dim.y; j++ ) outp[k][i][j] *= (src_TotalIntensities/Current_TotalIntensities);
      //      for( k=0; k<dim.z; k++ ) outp[k][i][j] *= (src_TotalIntensities/Current_TotalIntensities);
  
  /* write the smoothed image */
 for( k=0; k<dim.z; k++ )
   for( i=0; i<dim.x; i++ )
     for( j=0; j<dim.y; j++ ) {
      //      for( k=0; k<dim.z; k++ )	{
       if( outp[k][i][j]>255. ) src[k][i][j] = 255;
       else src[k][i][j] = (unsigned char)(outp[k][i][j]+0.5);
     }
 
 WriteImg(argv[2], src, dim);
 
 /* free */
 UCfree3d(src, dim.z, dim.x);
 Ffree3d(outp, dim.z, dim.x);
 Ffree3d(Density, dim.z, dim.x);
}

int GetImgZDim(char file[1000], Ivector3d dim)
{
  FILE        *fp;

  fp = fopen(file, "r");
  fseek(fp,0,SEEK_END);
  dim.z = (ftell(fp))/(dim.x*dim.y);
  fclose(fp);

  return dim.z;
}

int GetImgZDim_float(char file[1000], Ivector3d dim)
{
  FILE        *fp;

  fp = fopen(file, "r");
  fseek(fp,0,SEEK_END);
  dim.z = (ftell(fp))/(dim.x*dim.y*sizeof(float));
  fclose(fp);

  return dim.z;
}

float gaussian(float x, float s)
{
  return(exp((-x*x)/(2*s*s)));
}
