function dtis = wfu_get_dtis(subjectdir,type,imglist)

%   Find DTI images if they exist
%   FORMAT dtis = wfu_get_dtis(subjectdir,type,imglist)
%   
%   dtis        - analyze/nifti dti images
%   type        - type='dir' when input is a subject directory
%                 type='list' when input is a list of dti images 
%   imglist     - structure containing an 'imgfiles' field with dti names 
%                 (e.g. list.imgfiles{1} = 'subject_1_dti.img')
%________________________________________________________________________

dtis = {};
dircon = wfu_directory_configuration; 
dtidatadir = fullfile(subjectdir,dircon.dtidata); 

switch type
    case 'dir'
        files = dir(dtidatadir);
        for i = 1:length(files)
            if ~files(i).isdir
                file            = fullfile(dtidatadir,files(i).name); 
                [path,name,ext] = fileparts(file);
                if strcmp(ext,'.info')
                    infotext = wfu_read_info(file);
                    if any(infotext.SeriesDescription)
                        stop = find(infotext.SeriesDescription=='_');
                        if ~isempty(stop) & (stop>1)
                            sname = infotext.SeriesDescription(1:stop-1); 
                            if strcmp(sname,'DTI') | strcmp(sname,'TENSOR')
                                [dtipath,dtiname] = fileparts(file); 
                                dtis{end+1} = fullfile(dtipath,[dtiname '.img']);
                            end
                        else
                            % field does not contain "DTI" or "TENSOR" % 
                            return
                        end
                    else
                        % SeriesDescription field does not exist % 
                        disp('No SeriesDescription field in .info file to identify DTIs'); 
                    end
                end
            end
        end
    case 'list'
        for i = 1:length(imglist.imgfiles)
            if exist(imglist.imgfiles{i})
                dtis{end+1} = imglist.imgfiles{i}; 
            else
                disp('DTI image provided in list does not exist');
            end
        end
end

return

