function DIR = wfu_FE_directory(subjectdir,wfujob,cleanout) 

%   Create the directory structure for fixed effects
%   FORMAT DIR = wfu_FE_directory(subjectdir,wfujob,cleanout)
%   
%   DIR         - structure containing full paths to all 
%                 subject subdirectories and standard
%                 filenames
%   subjectdir  - main subject directory
%   wfujob      - structure containing user-defined parameters
%   cleanout    - clean out new directories before processing 1/0
%_________________________________________________________________

OK      = 1; 
nruns   = length(wfujob.refs); 
DIR     = wfu_batchdirectory_configuration(subjectdir,length(wfujob.refs),wfujob); 

if wfujob.fixedeff.enabled 
    OK(end+1) = wfu_batch_mkdir(DIR.fix,cleanout);
    for f = 1:length(wfujob.fixedeff.refs)
        OK(end+1) = wfu_batch_mkdir(DIR.fixparadigm{f},cleanout);
        %OK(end+1) = wfu_batch_mkdir(DIR.fixspmspec{f},cleanout); 
        %OK(end+1) = wfu_batch_mkdir(DIR.fixspmest{f},cleanout); 
        OK(end+1) = wfu_batch_mkdir(DIR.fixspm{f},cleanout);
        OK(end+1) = wfu_batch_mkdir(DIR.fixref{f},cleanout); 
    end
end

if all(OK)
    OK = 1;
else
    OK = 0;
end
