function fixjobs = wfu_FE_ref2job(DIR,wfujob)

%   Create fixed effects batch job from reference function
%   FORMAT fixjobs = wfu_FE_ref2job(DIR,wfujob)
%   
%   fixjobs - job structure from which launchable batch jobs
%             can be created
%   DIR     - structure containing full paths to all subject 
%             subdirectories and standard filenames
%____________________________________________________________
 
if wfujob.fixedeff.enabled
    stats       = {};
    statcount   = 1;
    for f = 1:length(wfujob.fixedeff.refs) 
        fix = wfujob.fixedeff.refs{f};
        [fix,wfujob] = wfu_merge_defaults(fix,wfujob); 
	consess = [];
        %--- specification ---%
        fmri_spec = wfujob.fixedeff.model.fmri_spec;
        for s = 1:length(fix.runids)
            run                     = fix.runids(s);
            runref                  = wfujob.refs{run};
            fmri_spec.sess(s)       = wfujob.fixedeff.model.fmri_spec.sess(1); 
            fmri_spec.sess(s).scans = wfujob.finalimgs{run};
            for c = 1:runref.conditions
                fmri_spec.sess(s).cond(c)           = wfujob.fixedeff.model.fmri_spec.sess(1).cond(1); 
                fmri_spec.sess(s).cond(c).name      = runref.names{c}; 
                fmri_spec.sess(s).cond(c).onset     = runref.SPMons{c}';
                fmri_spec.sess(s).cond(c).duration  = runref.SPMdur{c}'; 
            end
        end
        fmri_spec.timing.RT         = runref.tr; 
        fmri_spec.dir{1}            = DIR.fixspm{f};
        try fmri_spec.bases         = wfujob.fixedeff.model.fmri_spec.bases;
            catch fmri_spec.bases       = wfujob.fixedeff.model.fmri_spec.bases; 
        end
        stats{statcount}.fmri_spec  = fmri_spec;  
        statcount                   = statcount + 1;
        
        %--- estimation ---% 
        fmri_est                    = wfujob.fixedeff.model.fmri_est;
        fmri_est.dir{1}             = DIR.fixspm{f}; 
        fmri_est.spmmat{1}          = DIR.F.fixspmmat{f};
        stats{statcount}.fmri_est   = fmri_est; 
        statcount                   = statcount + 1;
        
        %--- contrasts ---% 
        for c = 1:length(fix.contrast_names)
            con=[]; weight=[]; spmmat=[]; 
            switch fix.contrast_types{c}
                case 'T'
                    for i = 1:length(fix.contrast_values{c}) 
                        weight = fix.contrast_values{c}{i};
                        if isempty(con), blank = ''; else blank = ' '; end 
                        con = [con,blank,weight];
                    end
                    consess{c}.tcon.convec  = con; 
                    consess{c}.tcon.name    = fix.contrast_names{c}; 
                    
                case 'F'
                    for i = 1:length(fix.contrast_values{c}) 
                        weight = fix.contrast_values{c}{i};
                        if isempty(con), blank = ''; else blank = ' '; end 
                        con = [con,blank,weight];
                    end
                    consess{c}.fcon.convec  = {con}; 
                    consess{c}.fcon.name    = fix.contrast_names{c};   
            end
        end
        stats{statcount}.con.spmmat{1}  = DIR.F.fixspmmat{f}; 
        stats{statcount}.con.consess    = consess;
        statcount = statcount + 1;
    end
end

if ~isempty(stats)
    fixjobs{1}.stats = stats;
end
