function [success,ufid] = wfu_U_scriptwrite( ...
    ufname,logfile,bchpath,tasktype,datapath, ...
    cleanup,subject,unixout,xfname,launchscript, ...
    cpufinder,cpuout,compfile,wkdir,matout,varargin)
%=================================================================
%   Writes a u-file 
%   FORMAT [success,ufid] = wfu_U_scriptwrite( ...
%       ufname,logfile,bchpath,tasktype,datapath, ...
%       cleanup,subject,unixout,xfname,launchscript, ...
%       cpufinder,cpuout,compfile,wkdir,matout)
%
%   success     - successful writing of mfile (1/0)
%   ufid        - file ID of u-file to be written
%
%   ufname      -
%   logfile     - 
%   bchpath     -
%   tasktype    - type of processing step (e.g. 'realignment')
%   datapath    - directory of .img files ('.../RUN1/normalized')
%   cleanup     - flag to write .img file removal into script (1/0)
%   subject     - name of subject 
%   unixout     - 
%   xfname      - 
%   launchscript- 
%   cpufinder   -
%   cpuout      -
%   compfile    - name of completion file for run (smoothing only)
%   wkdir       - 
%   matout      - 
%=================================================================
success = 0;

%----- Open mfile to write -----%
ufid = fopen(ufname,'wt');
if ufid==-1 
    error(sprintf('U-file %s\n\tcould not be opened for writing',ufname));
    return; 
end
rsh_string = ['echo yes | '];
redirect=' 2>> ';
reply = wfu_rsh_server(fullfile(datapath,'anyfile'));
rsh_datapath = datapath;
if reply.rsh
	rsh_string = ['rsh ' reply.server ' '' echo yes | '];
	redirect=''' 2>> ';
	rsh_datapath = fullfile(reply.rsh_path,datapath(reply.index:end));
end


%----- Write  -----%
fprintf(ufid, '#!/usr/bin/ksh \n');
fprintf(ufid, 'echo Running on `hostname` >> %s \n',logfile);
%fprintf(ufid, '. $HOME/.idlspm/.global.ksh \n');
fprintf(ufid, '. $WFU_PATH/global.site.ksh \n');
fprintf(ufid, 'umask $batch_umask \n');
fprintf(ufid, 'cd %s \n',bchpath);
switch tasktype
    case 'realignment'
        if cleanup
            cmd = ' rm -f ';
            rfiles  = fullfile(rsh_datapath,['r*',subject,'*']);
            sfiles  = fullfile(rsh_datapath,['s*',subject,'*']);
            wfiles  = fullfile(rsh_datapath,['w*',subject,'*']);
            psfiles = fullfile(rsh_datapath,['*.ps']);

            fprintf(ufid, '#----------------------------# \n');
            fprintf(ufid, '# Clean normalized directory # \n');
            fprintf(ufid, '# Perform SPM realign        # \n');
            fprintf(ufid, '#----------------------------# \n');
            fprintf(ufid,'%s%s %s %s %s \n',rsh_string,cmd,rfiles,redirect,unixout);
            fprintf(ufid,'%s%s %s %s %s \n',rsh_string,cmd,sfiles,redirect,unixout);
            fprintf(ufid,'%s%s %s %s %s \n',rsh_string,cmd,wfiles,redirect,unixout);
            fprintf(ufid,'%s%s %s %s %s \n',rsh_string,cmd,psfiles,redirect,unixout);
        else
            %%%%%Need to copy the original .mat in the next step if it exists
            fprintf(ufid, '#---------------------# \n');
            fprintf(ufid, '# Perform SPM realign # \n');
            fprintf(ufid, '#---------------------# \n');
        end
	data  = varargin{1};
	rsh_data = data;
	if reply.rsh, rsh_data = fullfile(reply.rsh_path,data(reply.index:end)); end;
	[dp,dn,dext] = fileparts(rsh_data);
	original_mat = fullfile(dp, [dn '.mat.hold']);
	mucked_mat = fullfile(dp, [dn '.mat']);	
	cpfiles = [original_mat ' ' mucked_mat ' '];
	cpcmd=' cp ';
	fprintf(ufid,'%s%s %s %s %s \n',rsh_string,cpcmd,cpfiles,redirect,unixout);
        
    case 'shadow_normalization_T1'
        fprintf(ufid, '#----------------------------------# \n');
        fprintf(ufid, '#         Shadow Transform:        # \n');
        fprintf(ufid, '#    T1-->T1 parameter estimation  # \n');
        fprintf(ufid, '#----------------------------------# \n');
        
    case 'shadow_normalization_EPI'
        fprintf(ufid, '#----------------------------------# \n');
        fprintf(ufid, '#          Shadow Transform:       # \n');
        fprintf(ufid, '#       apply parameters to EPI    # \n');
        fprintf(ufid, '#----------------------------------# \n');
        
    case 'EPI_normalization'
        fprintf(ufid, '#------------------------------------# \n');
        fprintf(ufid, '#  EPI-->EPI-template normalization  # \n');
        fprintf(ufid, '#------------------------------------# \n');
        
    case 'smoothing'
        fprintf(ufid, '#------------------------------------# \n');
        fprintf(ufid, '#         Clean data directory       # \n');
        fprintf(ufid, '#       Smooth normalized images     # \n');
        fprintf(ufid, '#------------------------------------# \n');
        
    case 'model'
	if cleanup
		cmd = ' rm -f ';
	    	[spm_mat] = fileparts(rsh_datapath);
		spm_mat = fullfile(spm_mat,'spm_mat');
		spm_spec = fullfile(spm_mat,'spm_spec');
		spm_est = fullfile(spm_mat,'spm_est');
            	spm_mat_files  = fullfile(spm_mat,['*']);  
		spm_spec_files  = fullfile(spm_spec,['*']);
		spm_est_files  = fullfile(spm_est,['*']);          
            	fprintf(ufid, '#----------------------------# \n');
            	fprintf(ufid, '# Clean spm_mat directories # \n');
		fprintf(ufid,'%s%s %s %s %s \n',rsh_string,cmd,spm_mat_files,redirect,unixout);
		fprintf(ufid,'%s%s %s %s %s \n',rsh_string,cmd,spm_spec_files,redirect,unixout);
		%fprintf(ufid,'%s%s %s %s %s \n',rsh_string,cmd,spm_est_files,redirect,unixout);
                fprintf(ufid, '#----------------------------# \n');
	end         

        fprintf(ufid, '#------------------------------------# \n');
        fprintf(ufid, '#          Compute SPM stats         # \n');
        fprintf(ufid, '#------------------------------------# \n');

    case 'fixed_effects_model'
        runsaredone = varargin{1}.F.runsaredone; 
        %fprintf(ufid, 'waitfor %s %s \n',runsaredone,bchpath); 
        fprintf(ufid, 'wait_for %s %s \n',runsaredone,bchpath); 

end

fprintf(ufid, 'batchpath=`echo %s` \n',bchpath);
fprintf(ufid, 'lhost=`hostname` \n');
fprintf(ufid, 'mxfile=`echo %s` \n',xfname);
fprintf(ufid, 'outputfile=`echo %s` \n',matout);
try
	mydisplay=getenv('batch_display')
catch
	mydisplay='alexia'
end
if isempty(mydisplay), mydisplay='alexia'; end;
fprintf(ufid, 'mydisplay=`echo %s` \n',mydisplay);
fprintf(ufid, '%s $mydisplay $mxfile $outputfile 19 \n\n',launchscript);

fprintf(ufid, 'running=`ls $batchpath  | grep running` \n');
fprintf(ufid, 'len=${#running} \n');
fprintf(ufid, 'if test $len -eq 0 \n');
fprintf(ufid, '\tthen exit \n');
fprintf(ufid, 'fi \n\n');

switch tasktype
    case 'smoothing'
        compdir         = fileparts(compfile); 
        nruns           = varargin{1};
        donelog         = varargin{2};
        fixspmdir       = varargin{3}; 
	[compdir,compn,compe] = fileparts(donelog); 
        fprintf(ufid, 'echo "%s completed" > %s \n',tasktype,compfile);
        %fprintf(ufid, '$script_path/check_completion %s %s \n\n',wkdir,compdir);
        
        fprintf(ufid, 'SWRdone=`ls -1 %s | wc -l` > /dev/null \n',fullfile(compdir,'*SWR_completed'));
        fprintf(ufid, 'if test $SWRdone -eq %i \n',nruns);
        fprintf(ufid, '\tthen echo "PREPROCESSING FOR %i RUNS COMPLETED FOR %s" > %s \n',nruns,subject,donelog); 
        if ~isempty(fixspmdir)
            for q = 1:length(fixspmdir)
                fprintf(ufid, '\tcd %s \n',fixspmdir{q});
                fprintf(ufid, '\tquick_start > %s \n',fullfile(compdir,['fixed_effects_launch_' num2str(q)]) );
                fprintf(ufid, 'cd - \n');
            end
        end
        fprintf(ufid, 'fi \n\n');

    case 'model'
        compdir = fileparts(compfile);
        fprintf(ufid, 'echo "%s completed" > %s \n',tasktype,compfile);
        fprintf(ufid, '$script_path/check_completion %s %s \n\n',wkdir,compdir);
end

fprintf(ufid, '%s %s >> %s 2>> %s \n',cpufinder,ufname,unixout,cpuout);
fprintf(ufid, 'exit \n');

%----- Make executable -----% 
unix(sprintf('chmod 777 %s',ufname)); 

%----- Close ufile -----%
status = fclose(ufid);
if status~=0 
    error(sprintf('U-file %s\n\tcould not be closed after writing',ufname));
else
    success = 1; 
end
return
