function [success,xfid] = wfu_X_scriptwrite( ...
    xfname,matname,ufname,bchpath,matcodedir,SPMXdir,oldmatcodedir, ...
    tasktype,varargin);

%   Write ???_x.m file for autoprocessing 
%   FORMAT sucess = wfu_dispatch(wfujob)
%
%   success     - 
%   xfid        -
%   xfname      -
%   matname     - 
%   ufname      -
%   bchpath     -
%   jpgName     - 
%   tasktype    - 
%   matcodedir  -
%   SPMXdir     -   
%   oldmatcodedir   -
%
%   NOTE: _x.m files are called by their respective _u files 
%         during autoprocessing. _x.m files run the lowest
%         level scripts (e.g. rbatch.m) and kill processing if 
%         any significant error occurs
%_____________________________________________________________
success = 0; 

%----- Open file to write -----%
xfid = fopen(xfname,'wt');
if xfid==-1 
    error(sprintf('X-file %s\n\tcould not be opened for writing',xfname));
    return 
end

%----- Write xfile -----%
fprintf(xfid, 'licensefilein = []; \n');
fprintf(xfid, 'batchdir = ''%s''; \n\n',bchpath);

%fprintf(xfid, 'addpath(''%s''); \n',oldmatcodedir);
%fprintf(xfid, 'addpath(genpath(''%s'')); \n',SPMXdir);
%fprintf(xfid, 'addpath(genpath(''%s'')); \n',spm('dir'));
%fprintf(xfid, 'addpath(genpath(''%s'')); \n',getenv('WFU_PATH'));
%fprintf(xfid, 'addpath(''%s''); \n\n',matcodedir);

%for distributed script
fprintf(xfid, 'wfu_startup([],5); \n');

%for internal
%fprintf(xfid, 'gospm(5); \n');


fprintf(xfid, '[reply,licensefile] = wfu_batch_license(licensefilein,0,batchdir); \n');
fprintf(xfid, 'if ~reply \n\texit; \nend \n'); 
fprintf(xfid, 'licensefilein = licensefile; \n\n');
fprintf(xfid, 'spm_defaults; \n');

switch tasktype 
    case 'shadow_normalization_EPI'
        snmat = varargin{1}; 
        fprintf(xfid, 'wfu_waitfor(''%s''); \n',snmat); 
    case 'fixed_effects_model'
        runsaredone = varargin{1}.F.runsaredone; 
        fprintf(xfid, 'wfu_waitfor(''%s''); \n',runsaredone);         
end

fprintf(xfid, 'disp(''Launching %s with spm_jobman (SPM5)''); \n',matname); 
fprintf(xfid, 'spm_jobman(''run'',''%s''); \n',matname); 
fprintf(xfid, 'fatalerr = wfu_batch_error(''%s'');\n',matname);
fprintf(xfid, 'if fatalerr \n\texit; \nend \n'); 
fprintf(xfid, 'pause(5); \n\n');

% switch tasktype
%     case 'model'
%         nruns = varargin{1};
%         fprintf(xfid, 'wfu_check_stats(',matname); 


%-------------------------------------------------
%Print a small Jpeg for email for some processes
%-------------------------------------------------
print_jpeg = 1;
%if findstr(tasktype,'realign')
%if findstr(tasktype,'model')
%if findstr(tasktype,'norm')
%if findstr(tasktype,'coreg')
if findstr(tasktype,'shadow'), print_jpeg= 0; end
if findstr(tasktype,'smooth'), print_jpeg= 0; end


if findstr(tasktype,'model')
	DIR = varargin{1};
	wfujob = varargin{2};
	runindex = varargin{3};
	wfu_params.batchdir = char(bchpath);
	wfu_params.swd = DIR.spm{runindex};
	if findstr(tasktype,'fixed'), 	wfu_params.swd = char(DIR.fixspm{runindex}); end;
	ref = wfujob.refs{runindex};
	if ~isfield(ref,'u'), ref.u = 0.05; end
	if ~isfield(ref,'k'), ref.k = 0; end
	if ~isfield(ref,'correction'), ref.correction = 'none'; end
	if ~isfield(ref,'slices'), ref.slices = 0; end
	if ~isfield(ref,'sections'), ref.sections = 1; end
	if ~isfield(ref,'list'), ref.list = 1; end
	if isfield(DIR,'spms'), wfu_params.spms = DIR.spms; end
	wfu_params.u = ref.u;
	wfu_params.k = ref.k;
	wfu_params.correction = ref.correction;
	wfu_params_file = fullfile(bchpath,'wfu_params.mat');
	save(wfu_params_file,'wfu_params');
	fprintf(xfid,'load(''%s'');\n',wfu_params_file);
    fprintf(xfid,'try\n');
    fprintf(xfid,'\tdisp(''Attempting to write JPGs with wfu_auto_display'');\n');
	fprintf(xfid,'\twfu_auto_display(wfu_params);\n');
	fprintf(xfid,'catch\n');
    fprintf(xfid,'\tdisp(sprintf(''Error using wfu_auto_display: %%s\\n'',lasterr));\n');
    fprintf(xfid,'end\n\n');
    print_jpeg = 0;
    if findstr(bchpath,'clinical')
	disp('Clinical DICOM detected');
	if ~isfield(ref,'dicom_generate'), ref.dicom_generate = 1; end
	if ~isfield(ref,'dicom_send'), ref.dicom_send = 1; end
	if ~ref.dicom_generate, ref.dicom_send = 0; end
	if ~isfield(ref,'fuse_image'), ref.fuse_image = 1; end
	if ~isfield(ref,'auto_threshold'), ref.auto_threshold = 1; end
	if ~isfield(ref,'normalized_target'), ref.normalized_target = 0; end
	%if  isfield(ref,'threshold'), dicom_flags.threshold = ref.threshold; end

	%This option not implemented yet  - look to dicom magilla for potential incorporation
%	if ref.normalized_target, dicom_flags.fuse.anatomic = how should I locate the normalized file?;  end
	
	dicom_flags.threshold.enabled = 1;
	dicom_flags.threshold.autocutoff = ref.auto_threshold;
	if ~dicom_flags.threshold.autocutoff
		dicom_flags.threshold.u = ref.u; %minimum cutoff
		dicom_flags.threshold.k = ref.k;   %cluster extent
		dicom_flags.threshold.correction = ref.correction;  
	end
	dicom_flags.threshold.swd = wfu_params.swd;
	dicom_flags.fuse.enabled = ref.fuse_image;
	dicom_flags.fuse.normalized_target = ref.normalized_target;		%Not implemented yet - see dicom magilla
	dicom_flags.convert.enabled = ref.dicom_generate;
	dicom_flags.send.enabled = ref.dicom_send;

	wfu_dicom_file = fullfile(bchpath,'wfu_dicom_params.mat');
	save(wfu_dicom_file,'dicom_flags','wfu_params');
	fprintf(xfid,'load(''%s'');\n',wfu_dicom_file);
	fprintf(xfid,'try\n');
    	fprintf(xfid,'\tdisp(''Attempting DICOM conversions with wfu_dicom_magilla'');\n');
		fprintf(xfid,'\twfu_dicom_magilla(dicom_flags);\n');
		fprintf(xfid,'catch\n');
   	fprintf(xfid,'\tdisp(sprintf(''Error using wfu_dicom_magilla: %%s\\n'',lasterr));\n');
    	fprintf(xfid,'end\n\n');
      end



end
	
if print_jpeg	
	fprintf(xfid,'tasktype=''%s'';\n',tasktype);
	fprintf(xfid,'JpegFile=fullfile(batchdir, [''Jpeg_'' tasktype]);\n');
	fprintf(xfid, 'disp([''Printing small '' JpegFile ''.jpg'']); \n'); 

	fprintf(xfid,'global defaults \n');
	fprintf(xfid,'opt = {''-djpeg20'' ''-painters'' ''-r50'' ''-append'' ''-noui''};\n');
	fprintf(xfid,'defaults.ui.print.opt = opt;\n');
	fprintf(xfid,'defaults.ui.print.ext = ''.jpg'';\n');
	fprintf(xfid,'spm_print(JpegFile);\n');
end


fprintf(xfid, '[reply,licensefile] = wfu_batch_license(licensefilein,1,batchdir); \n');
fprintf(xfid, 'if reply \n\twfu_nixcmd(''%s''); \nend \n\n',ufname);
fprintf(xfid, 'disp([''Completed '',''%s'']); \n',matname);
fprintf(xfid, 'exit;'); 


%----- Close xfile -----%
status = fclose(xfid);
if status~=0 
    error(sprintf('X-file %s\n\tcould not be closed after writing',matname));
else
    success = 1; 
end
return 
