function [wfujob,fixjobs] = wfu_autoSPM5(subjectdir,cleanout,onerun,anatflag,plist,email_address)

%   Writes scripts for and launches processing of MR data
%   in SPM5
%
%   FORMAT wfu_autoSPM5(subjectdir,cleanout)
%
%   subjectdir	String with full path of dir to process
%   cleanout	(1/0) Delete old files/directories before processing begins
%   onerun      Vector of specified runs to process
%   anatflag    (1/0) Process anatomical normalization (default 1)
%   plist       List of 4D.img and corresponding reference functions, tab
%              	or space delimited, refs can be actual ref filenames or
%               ids. Alternatively, if a .paradigms file is found in the
%               subject directory, this will be used like the plist file.
%               This file should have the list of 4D.imgs and corresponding
%               ref ids to use if .paradigms file is found, this is used as
%               the plist.
%
%   EXAMPLE wfu_autoSPM5('/ansir1/subject001',1);
%
%   NOTES  (1) defaults.analyze.multivol should be set to '1'
%          (2) wfujob = wfu_defaults if no parameters from GUI
%          (3) wfujob must be saved (job.mat) if you want to
%              come back and change fixed effects later
%____________________________________________________________
%--- load newest release of SPM5
%gospm(5); %internal release
wfu_startup([],5); %external release
%--- turn on normalization unless otherwise specified ---%
if ~exist('anatflag','var'), anatflag = 1; end
%--- if only one run desired, turn off normalization ---%
if nargin == 3, anatflag = 0; end
%--- process all runs unless otherwise specified ---%
if nargin < 3, onerun = []; end
if nargin < 1, disp('No subject directory given to wfu_autoSPM5. Exiting...'); return; end;
if nargin < 2, cleanout=1; end
if nargin >= 5 & ~isempty(plist), insidejob = 0; else insidejob = 1; plist = []; end
if ~exist('email_address','var'), email_address = ''; end

jobs    = {};
fixjobs = {};
wfujob  = wfu_defaults; %only if no gui arguments
if ~iscell(subjectdir), wfujob.subjectdir = {subjectdir}; end


%--- Look for a .paradigms file defining 4D images and refids in the
%--- subjectdir. If found, use the outside_job pathway

if isempty(plist)
    plistfilter = fullfile(subjectdir,'*.paradigms');
    plist_struc = dir(plistfilter);
    if length(plist_struc)
        insidejob = 0;
        plist = fullfile(subjectdir,plist_struc.name);
    end
end

%---  If running at wfu site, read .info files to determine epis  ---%
%---  If running elsewhere, read list of pfiles and corresponding ---%
%---                    reference functions                       ---%

if insidejob
    %%%%% Find EPIs if they exist %%%%%
    [wfujob.epis,nruns,wfujob.pfiles] = wfu_get_epis(subjectdir,'dir');
    disp('DONE wfu_get_epis');
    if ~isempty(wfujob.pfiles)
        refs = wfu_id_refs(wfujob.pfiles);
        disp('DONE wfu_id_refs');
    else
        refs = '';
    end
    %%%%% Find DTIs if they exist %%%%%
    wfujob.dtis = wfu_get_dtis(subjectdir,'dir');
    disp('DONE wfu_get_dtis');
    if ~isempty(wfujob.dtis)
        dtiflag = 1;
    end
else %outside job
    disp(['Using paradigms file: ', plist]);
    [imgfiles,srefs]            = textread(plist,'%s%s');
    refs                        = wfu_find_refs(srefs);
    imgfilesandrefs.refs        = refs;
    imgfilesandrefs.imgfiles    = imgfiles;
    [wfujob.epis,nruns]         = wfu_get_epis(subjectdir,'list',imgfilesandrefs);
    wfujob.pfiles               = wfujob.epis;
    wfujob.dtis                 = '';
end

%%%%%%%%%% fMRI Processing starts if refs exist %%%%%%%%%%
%refs = [];
if ~isempty(refs)
    [wfujob,refs] = prune_wfujob(wfujob,refs);
    wfujob.refs   = wfu_read_refs(refs);

    %========create paradigms.flist file
    parafile = fullfile(subjectdir,'paradigms.flist');
    if ~exist(parafile,'file'),
        disp('Generating paradigms.flist');
        pfid = fopen(parafile,'wt');
        fprintf(pfid,[ num2str(length(wfujob.refs)) ' \n']);
        for i=1:length(wfujob.refs), fprintf(pfid,[wfujob.refs{i}.paradigm_name ' \n']); end
        fclose(pfid);
    end
    disp('DONE wfu_read_refs');

    %====== Eventually, wfujob should be modified based on parameters set ======%
    %====== in paradigm reference function here.                          ======%
    wfujob = wfu_modifyjob(wfujob);
    DIR  = wfu_base_directory(subjectdir,length(wfujob.refs),length(wfujob.dtis),cleanout);
    disp('DONE wfu_base_directory');
    
    datafield  	= wfu_copy_epis(DIR,wfujob.epis);       % returns data filenames
    wfujob.data = datafield.data;
    wfujob.vols = datafield.vols;
    disp('DONE wfu_copy_epis');
    %save('/ansir1/maldjian/MYJOBS1.mat','DIR','wfujob');

     [mainjobs,wfujob,DIR] = wfu_ref2job(DIR,wfujob);
    disp('DONE wfu_ref2job');

    if wfujob.fixedeff.enabled
        %newfix      = 160.2;    % this will be used for autoREF, ask paul about the reference function button
        %wfujob      = wfu_fixed_effects(wfujob,newfix)
        wfujob     	= wfu_fixed_effects(wfujob);
        disp('DONE wfu_fixed_effects');
        if wfujob.fixedeff.enabled
            DIR      	= wfu_FE_directory(subjectdir,wfujob,cleanout);
            disp('DONE wfu_FE_directory');
            fixjobs    	= wfu_FE_ref2job(DIR,wfujob);
            disp('DONE wfu_FE_ref2job');
        end
    end

    %save('/ansir1/maldjian/MYJOBS2.mat','mainjobs','fixjobs','DIR','wfujob');
    %-----------Launch the T1 normalization first---------------------
    runvector = [];
    if anatflag
        fixedflag                   = 0;
        wfu_priority(DIR.bchanat);
        [anatulist,ulist,fixulist] 	= wfu_scriptmaker(mainjobs,fixjobs,DIR,wfujob,runvector,anatflag,fixedflag);
        [mainquick,fixquick]        = wfu_final_prep(anatulist,ulist,fixulist,DIR,wfujob,runvector,email_address);
        wfu_launch_quickq(mainquick);
    end


    %-----------Now Launch each run separately---------------------
    fixedflag = 0;
    anatflag = 0;
    if ~isempty(onerun)
        runvector = onerun;
    else
        runvector = [1:DIR.nruns];
    end

    for i = 1:length(runvector)
        runnum = runvector(i);
        wfu_priority(DIR.bchrun{runnum});
        [anatulist,ulist,fixulist]	= wfu_scriptmaker(mainjobs,fixjobs,DIR,wfujob,runnum,anatflag,fixedflag);
        [mainquick,fixquick]        = wfu_final_prep(anatulist,ulist,fixulist,DIR,wfujob,runnum,email_address);
        wfu_launch_quickq(mainquick);
    end

    %%% Fixed Effects: NOT launched now, started by last smooth_u file %%%
    fixedflag                   = 1;
    runvector                   = [];
    [anatulist,ulist,fixulist]	= wfu_scriptmaker(mainjobs,fixjobs,DIR,wfujob,runvector,anatflag,fixedflag);
    [mainquick,fixquick]     	= wfu_final_prep(anatulist,ulist,fixulist,DIR,wfujob,runvector,email_address);

elseif wfujob.fixedeff.enabled
    
    %%%%%%%%% For fixed effects without fMRI processing %%%%%%%%%
    fedir       = '/ansir13/abaer/fetest'; 
    flist       = '/ansir13/abaer/fetest/meredith_test.flist';
    fixedref    = '/ansir13/abaer/fetest/meredith_test.se_ref';
    runrefs     = wfu_fe_scriptwrite(fedir,flist,fixedref);
    fixtext     = wfu_read_refs(fixedref); 
    %%% pretend runs from diff subjects are multiple runs from same %%%
    wfujob.refs             = runrefs;
    wfujob.fixedeff.refs{1} = fixtext{1};
    DIR                     = wfu_batchdirectory_configuration(fedir,0,wfujob,'');
    runcount                = 1; 
    for i = 1:length(wfujob.refs)
        wfujob.fixedeff.refs{1}.runids(i) = runcount;
       
        % not sure how to get these % 
        wfujob.finalimgs{i}               = ''; 
        runcount = runcount + 1; 
    end
    [wfujob,refs] = prune_wfujob(wfujob,refs);
    DIR = wfu_combo_FE_directory(fedir,wfujob,cleanout); disp('DONE wfu_combo_FE_directory');
    
    %%% make preliminary job structure %%%
    fixjobs	= wfu_FE_ref2job(DIR,wfujob);                disp('DONE wfu_FE_ref2job');
    
%     %%% correct job structure %%%
%     fixjobs = wfu_combine_runs(fixjobs); 
    
end %if ~isempty(refs) 
    
    
%   if isnumeric(refnum), refnum = cellstr(refnum); end
%     for n = 1:length(refnum);
%         ref = wfu_paradigm_lookup(refnum{n});
%         if ~isempty(ref)
%             refstruct   = wfu_read_refs(ref);
%             reftext     = refstruct{1};
%             for runpar = 1:length(reftext.combined_paradigms)
%                 for r = 1:length(wfujob.refs)
%                     [path,name,ext] = fileparts(wfujob.refs{r}.refname);
%                     if strcmp(reftext.combined_paradigms{runpar},name);
%                         reftext.runids(runpar) = r;
%                     end
%                 end
%             end
%             [reftext,wfujob] = wfu_merge_defaults(reftext,wfujob);
%             fixed{end+1}     = reftext;
%         else
%             error(sprintf('Paradigm code %.2f is not valid.',refnum{n}));
%         end
%     end


%%%%%%%%%% DTI processing %%%%%%%%%%
if ~isempty(wfujob.dtis)
    scriptnames       = wfu_autodti(subjectdir,email_address);
    %dtiquickstartlist = wfu_dti_final_prep(scriptnames,subjectdir);
    %wfu_launch_quickq(dtiquickstartlist)
end

%%%%%%%%% Final display - either it ran or it didn't %%%%%%%%%%
if isempty(refs) & isempty(wfujob.dtis)
    error(sprintf('No EPI or DTI data to process in wfu_autoSPM5. Autoprocessing terminated.'));
else
    disp('DONE wfu_autoSPM5');
end 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Subfunction %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function wfu_launch_quickq(mainquick)
% launches the quickq
% mainquick is just a list of directories
% quick_start file should already be there
cwd = pwd;
if ~isempty(mainquick)
    for i = 1:length(mainquick)
        disp(mainquick{i});
        cd(mainquick{i});
        [a,b] = unix('./quick_start &');
    end
end
cd(cwd);
return


%%%%%%%%%%%%%%%%%%%%%%%%%%% subfunction %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function refs = wfu_find_refs(srefs)
%finds the ref file associated with a ref id
refs=[];
for i = 1:length(srefs)
    %check if this is already a filename
    if sum(isletter(srefs{i}))
        refs{i} = srefs{i};
    else
        refs{i} = wfu_paradigm_lookup(srefs{i});
    end
end
return


%%%%%%%%%%%%%%%%%%%%%%%%%% subfunction %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [wfujob,refs] = prune_wfujob(wfujob,refs)
%removes pfiles without refids
wfujob1 = wfujob;
refs1 = refs;
wfujob.epis = [];
wfujob.pfiles = [];
refs = [];
index = 0;
for i = 1:length(refs1)
    if ~isempty(refs1{i})
        index = index + 1;
        wfujob.epis{index} = wfujob1.epis{i};
        wfujob.pfiles{index} = wfujob1.pfiles{i};
        refs{index} = refs1{i};
    end
end
return
