function wfu_auto_display(wfu_params)
%Program will cycle through all contrasts in the SPM, and generate jpegs of glass brain
%wfu_params is a structure containing:
%swd = stats directory
%batchdir - directory where jpegs will get written
%Ic = contrast number
%	correction ('FWE' | 'FDR' | 'none' )
%	u = p value
%	k = extent threshold (voxels)

%------------------------------------------
%Set some defaults if they didn't come in
%------------------------------------------
global defaults
defaults.modality = 'FMRI';
if ~isfield(wfu_params,'correction'), wfu_params.correction = 'none'; end;
if ~isfield(wfu_params,'u'), wfu_params.u = 0.001; end;
if ~isfield(wfu_params,'k'), wfu_params.k = 0; end;
if ~isfield(wfu_params,'batchdir'), wfu_params.batchdir = []; end;
if ~isfield(wfu_params,'list'), wfu_params.list = 1; end;
if ~isfield(wfu_params,'slices'), wfu_params.slices = 0; end;
if ~isfield(wfu_params,'sections'), wfu_params.sections = 1; end;

%wfu_params.u = 0.05;

tdir = fullfile(spm('Dir'),'templates');
T1files = dir(fullfile(tdir,'T1.*'));
T1file = fullfile(tdir,T1files(1).name);
if ~isfield(wfu_params,'spms'), wfu_params.spms = T1file; end;


pd0 = struct('opt',{{'-dpsc2'  '-append'}},'append',true,'ext','.ps');
pd = struct('opt',{{'-dpsc2' }},'append',false,'ext','.ps');
pd = struct('opt',{{'-dpsc2'  '-append'}},'append',true,'ext','.ps');

load(fullfile(wfu_params.swd,'SPM.mat'));
nIC = size(SPM.xCon);
nIC = nIC(2);
global defaults;
nmax = 4;
nprint = 1;
if nIC < nmax, nprint = nIC; end;
for i = 1:nprint
	wfu_params.Ic = i;
	%-------------------
	%Print PS file
	%-------------------
	tasktype=SPM.xCon(i).name;
	defaults.ui.print = pd;
	PsFile=fullfile(wfu_params.swd, ['SPM_' tasktype]);
	filtered_File=fullfile(wfu_params.swd, ['filtered_' tasktype '.img']);
	unix(['rm -f ' PsFile '.ps' ]);
	disp(['Printing  ' PsFile '.ps']); 
	wfu_params.psfile = PsFile;
	%if ~isfield(wfu_params,'filtered_file'), wfu_params.filtered_file = filtered_File; end;
	wfu_params.filtered_file = filtered_File;
	wfu_spm_results_ui('wfu_params',wfu_params);
	%spm_print(PsFile);
	%-------------------Print small Jpeg to batchdir if it exists-------------
	if ~isempty(wfu_params.batchdir)
		JpegFile=fullfile(wfu_params.batchdir, ['Jpeg_' tasktype]);
		disp(['Printing small ' JpegFile '.jpg']); 
		opt = {'-djpeg30' '-painters' '-r50' '-append' '-noui'};
		defaults.ui.print.opt = opt;
		spm_print(JpegFile);
	end
end
defaults.ui.print = pd0;
