function [DIR,OK] = wfu_base_directory(subjectdir,nruns,ndti,cleanout) 

%   Make autoprocessing directory structure
%   FORMAT [DIR,OK] = wfu_base_directory(subjectdir,cleanout,nruns)
%   
%   DIR         - structure containing full paths to all 
%                 subdirectories created by this function
%   OK          - directory structure created sucessfully y/n (1/0) 
%   subjectdir  - full path of subject directory
%   cleanout    - if flag is set (cleanout=1), subdirectories
%                 that already exist will have their contents
%                 erased.
%
%   NOTE: this program creates a directory structure as 
%   defined in the file wfu_directory_structure.m 
%__________________________________________________________________
OK  = [];
DIR = [];
if nargin < 4, cleanout = 0; end
if nargin < 3, ndti = 0; end
if nargin < 2, nruns = 0; end

if nruns<1 & ndti<1
    error(sprintf('Run count is zero (no epi runs or dti series).\nAutoprocessing terminated.'));
    return
else
    
    %%%%%%%%%% First, make epi directories %%%%%%%%%%
    DIR = wfu_batchdirectory_configuration(subjectdir,nruns);
    if nruns > 0
        OK(end+1)   = wfu_batch_mkdir(DIR.bch,cleanout);
        OK(end+1)   = wfu_batch_mkdir(DIR.bchanat,cleanout);
        OK(end+1)   = wfu_batch_mkdir(DIR.log,0);             %don't want to erase logs from wfu_DICOM
        OK(end+1)   = wfu_batch_mkdir(DIR.logcomp,cleanout);
        OK(end+1)   = wfu_batch_mkdir(DIR.logbch,0);
        OK(end+1)   = wfu_batch_mkdir(DIR.vbm,cleanout);
        for i = 1:nruns
            OK(end+1)   = wfu_batch_mkdir(DIR.bchrun{i},cleanout);
            OK(end+1)   = wfu_batch_mkdir(DIR.run{i},cleanout);
            OK(end+1)   = wfu_batch_mkdir(DIR.norm{i},cleanout);
            OK(end+1)   = wfu_batch_mkdir(DIR.spm{i},cleanout);
            %OK(end+1)   = wfu_batch_mkdir(DIR.spmest{i},1);   %must remove SPM.mat or autoprocessing hangs up
            %OK(end+1)   = wfu_batch_mkdir(DIR.spmspec{i},1);  %must remove SPM.mat or autoprocessing hangs up
        end
    end
    
    %%%%%%%%%% Then, make DTI directories %%%%%%%%%%
    if ndti > 0
        for i = 1:ndti
            OK(end+1)   = wfu_batch_mkdir(DIR.dti{i},cleanout);
            OK(end+1)   = wfu_batch_mkdir(DIR.bchdti{i},cleanout);
        end
    end

    %%%%%%%%%%%% if any mkdir commands were unsucessful, OK = 0 %%%%%%%%%%
    if all(OK)
        OK = 1;
    else
        OK = 0;
    end
    
end



