function fatalerr = wfu_batch_error(batchfile)

fatalerr = 0; 

if ~isempty(lasterr)
    batchdir    = fileparts(batchfile);
    batch_log   = fullfile(batchdir,'batch_log');
    kill_file   = fullfile(batchdir,'kill');
    
    %============== LIST ACCEPTABLE ERRORS HERE ================%
    fatalerr = 1;
    
    %--- non-fatal read_hdr.m error in normalization ---%
    if any(strfind(lasterr,'/read_hdr')) & any(strfind(lasterr,'Error reading header'))
        fatalerr = 0; 
    end
    
    %--- non-fatal try/catch's in spm_jobman ---%
    if any(strfind(lasterr,'Attempt to reference field of non-structure array'))
    	fatalerr = 0;
    end
    if any(strfind(lasterr,'Undefined function or method ''prod'' for input arguments of type ''logical'''))
    	fatalerr = 0;
    end
    
    %--- non-fatal error in realignment ---%
    if any(strfind(lasterr,'Undefined function or variable ''textscan'''))
        fatalerr = 0; 
    end
    if any(strfind(lasterr,'Reference to non-existent field ''model'''))
       fatalerr = 0; 
    end
    if any(strfind(lasterr,'Reference to non-existent field ''xKXs'''))
       fatalerr = 0; 
    end
    if any(strfind(lasterr,'Error using ==> uitools/private/prefutils>getFieldRequired'))
       fatalerr = 0; 
    end
    %===========================================================%
    
    
    if fatalerr
        %--- write the error to the batch log ---%
        fid = fopen(batch_log,'a');
        fprintf(fid,'\n------------------------------------------\n');
        fprintf(fid,'\nMATLAB ERROR DETECTED\n\n');
        fprintf(fid,lasterr);
        fprintf(fid,'\n------------------------------------------\n');
        fclose(fid);
        %--- create a kill file to stop batch execution stream ---%
        fid = fopen(kill_file,'w');
        fprintf(fid,'\n------------------------------------------\n');
        fprintf(fid,'\nKILLED BY MATLAB ERROR\n\n');
        fprintf(fid,batchfile);
        fprintf(fid,lasterr);
        fprintf(fid,'\n------------------------------------------\n');
        fclose(fid);
    end
else
    return
end

	
