function [reply, licensefile] = wfu_batch_license(licensefilein,kill,batchdir)
licensefile=licensefilein;
batch_log = fullfile(batchdir,'batch_log');
running_file = fullfile(batchdir,'running.matlab');

current=pwd;
cd(batchdir);
pid = get_pid;
if isempty(licensefile)
        k = spm_select('List',batchdir,'spmbatchlicense*');
	if isempty(k) licensefile = 'no_license_file_here'; end;
	if k licensefile = fullfile(batchdir,k(1,:));  end;
end;
reply = exist(licensefile,'file');


already_running = 1;
if ~kill
%----------------------------------------
%- check if we are already running file 
%----------------------------------------
	%flist = ls;
	%already_running = findstr(flist,running_file);
	%already_running = spm_get('files',batchdir,'running.matlab');
	
    already_running = spm_select('List',batchdir,'running.matlab');
    if isempty(already_running)
	%------------------------------------------------------------------------------------
	%- create a running file to prevent multiple tries at matlab license for this stream
	%-------------------------------------------------------------------------------------
		[a,lhost]= unix('hostname');
		fid = fopen(running_file,'w');
		fprintf(fid,'------------------------------------------\n');
		fprintf(fid,lhost);
		fprintf(fid,'MATLAB RUNNING\n');
		fprintf(fid,batchdir);
		fprintf(fid,'------------------------------------------\n');
		fclose(fid);
	end;
end;

%flist = ls;
%kill_file = findstr(flist,'kill');
%kill_file = spm_get('files',batchdir,'kill');

kill_file = spm_select('List',batchdir,'kill');
if kill_file reply = 0; end;

%--------------------------------------------
%- if no license file, update batch_log
%--------------------------------------------
if ~reply | (already_running & ~kill)
	fid = fopen(batch_log,'a');
	fprintf(fid,'------------------------------------------\n');
	if ~reply
		fprintf(fid,'ERROR NO LICENSE FILE DETECTED BY MATLAB\n');
		if kill_file fprintf(fid,'ERROR KILL FILE DETECTED BY MATLAB\n'); end;
		%delete('running_file');
	end
	if already_running
		fprintf(fid,'MATLAB ALREADY RUNNING\n');
		reply = 0;
	end;
	fprintf(fid,'------------------------------------------\n');
	fclose(fid);
end;

if reply
	[s,w] = unix('hostname');
	sk = size(w);
	hostname = w(1:sk(2) - 1);
	%killcmd = ['rsh ' hostname ' "kill -9 '  pid '" ' ];
	killcmd = ['rsh ' hostname ' '  char(39) 'kill -9 '  pid char(39) ];
	if kill killcmd = '';  end;
	fid = fopen(licensefile,'w');
	fprintf(fid,killcmd);
	fclose(fid);
end;
%if kill delete(running_file);  end;

	
