function ok = wfu_batch_mkdir(directory,cleanout,rmstring) 

%   Makes directory if one does not already exist, if one does
%   exists and 'cleanout' flag is set, contents are deleted
%   FORMAT ok = wfu_batch_mkdir(directory,cleanout)
%   
%   ok          - directory created successfully (1/0) 
%   directory   - full path of directory to create 
%   cleanout    - erase directory contents? y/n (1/0) 
%   rmstring    - if cleanout==1, user can pass strings to 
%                 look for and remove files
%                 e.g. rmstring = {'*.img','*.hdr'} will
%                 remove any files in 'directory' that have 
%                 the extension .img or .hdr
%
%   NOTE: this function executes a unix 'rm' command to clean
%   out directories and cannot be used on a PC. This function
%   assumes that only the ./ and ../ directories exist in 
%   an "empty" directory.
%____________________________________________________________

if nargin < 3
    npass       = 1; 
    rmstring{1} = '*'; 
else
    npass = length(rmstring); 
end 

if exist(directory,'dir')
    if cleanout 
        for p = 1:npass
            delStr = sprintf('rm -rf %s',fullfile(directory,rmstring{p}));
	    [a,b] =unix(delStr); 
            %eval(delStr);
            if length(dir(directory)) > 2
                %warning(sprintf('Directory contents could not be deleted properly: ''%s''',directory)); 
                ok = 0;
            else
                ok = 1; 
            end
        end
    else
        if length(dir(directory)) > 2
            %warning(sprintf('Directory is not empty: ''%s''\nFlag is not set to erase contents.',directory));
            ok = 0;
        else
            ok = 1; 
        end
    end
else
    %--- mkdir ---%
    mkdirStr = sprintf('!mkdir -p %s',directory);
    eval(mkdirStr); 
    if exist(directory,'dir')
        ok = 1; 
    else
        ok = 0;
        warning(sprintf('Directory was not created:\n%s',directory)); 
        disp(msg);    
    end
end
