function status = wfu_batch_que(ulist,DIR,wfujob,quetype,runvector,email_address)

%   Write batch ques and batch flists for spm autoprocessing 
%   FORMAT status = wfu_batch_que(ulist,DIR,wfujob,quetype)
%   
%   status  - successful writing of files 1/0
%   ulist   - cell array of *_u files that will be written to
%             batch_que and batch.flist 
%   DIR     - structure containing full paths to all subject
%             subdirectories and standard filenames
%   wfujob  - stucture containing job-specific parameters 
%   quetype - type of batch_que to write:
%             'all_runs' | 'fixed_effects' 
%____________________________________________________________

status  = 1;
nques   = length(ulist);
startq=1;
endq=nques;
if ~exist('email_address','var'), email_address = ''; end
email_address1    = wfujob.refs{1}.email;
switch quetype 
	case 'anat'
		endq=1;
        case 'one_run'
           startq=runvector;
	   endq=runvector; 
end
for q = startq:endq    
    switch quetype 
	case 'anat'
            bchque   = DIR.F.anat.batchque{1};
            bchflist = DIR.F.anat.flist{1}; 
	case 'one_run'
            bchque   = DIR.F.batchque{runvector};
            bchflist = DIR.F.flist{runvector};
	    email_address1    = wfujob.refs{runvector}.email; 
        case 'all_runs'
            bchque   = DIR.F.batchque{q};
            bchflist = DIR.F.flist{q};
	    email_address1    = wfujob.refs{q}.email; 
        case 'fixed_effects' 
            bchque      = DIR.F.fixbatchque{q};
            bchflist    = DIR.F.fixflist{q};
            fullflist   = DIR.F.fixfullflist{q}; 
            %--- write ref function flist ---%
            refid = fopen(fullflist,'wt');
            if refid==-1, error(sprintf('FIXED EFFECTS ref function flist:\n\t%s\ncould not be opened for writing',fullflist));   
            end
            count = length(wfujob.fixedeff.refs{q}.runids);
            fprintf(refid,'\t%i',count); 
            for i = 1:count
                run = wfujob.fixedeff.refs{q}.runids(i); 
                [path,name,ext] = fileparts(wfujob.finalimgs{run}{1});
                runimage        = fullfile(path,[name,'.img']); 
                fprintf(refid,'\n%s',runimage); 
            end
            fclose(refid);
    end
    
    count = length(ulist{q});
    %--- batch que ---% 
    qfid = fopen(bchque,'wt');
    if qfid==-1, error(sprintf('Batch que:\n\t%s\ncould not be opened for writing',bchque));   
    end
    for i = 1:count
        if i~=1
            fprintf(qfid,'\n'); 
        end
        fprintf(qfid,'%s',ulist{q}{i}); 
    end
    fclose(qfid);
    
    %--- batch flist ---%
    ffid = fopen(bchflist,'wt');
    if ffid==-1, error(sprintf('Batch que:\n\t%s\ncould not be opened for writing',bchflist)); 
    end
    fprintf(ffid,'\t%i',count); 
    for i = 1:count
        fprintf(ffid,'\n%s',ulist{q}{i}); 
    end
    fclose(ffid);

   %--- batch email ---%
    [p,n,e] = fileparts(bchflist);
    bchemail = fullfile(p,'batch_email');
    %[blank,username] = unix('whoami');
    %username = deblank(getenv('USER'));
    %if isempty(username), username = deblank(getenv('username')); end
    %if ~strcmp(deblank(username),'fmri'), email_address=[deblank(username) '@wfubmc.edu']; end  
    if isempty(email_address), email_address = email_address1; end
    ffid = fopen(bchemail,'wt');
    if ffid==-1, error(sprintf('Batch email:\n\t%s\ncould not be opened for writing',bchemail)); 
    end
    fprintf(ffid,'%s',email_address); 
    fclose(ffid);



end

