function DIR = wfu_batchdirectory_configuration(subjectdir,nruns,wfujob,ndti)

%   Define the directory/file structure for autoprocessing.
%   FORMAT DIR = wfu_batchdirectory_configuration(subjectdir,nruns)
%   
%   DIR         - structure containing full paths to all 
%                 subject subdirectories and standard
%                 filenames
%   subjectdir  - full path of base subject directory
%   nruns       - number of fmri pfiles in subject directory
%   wfujob      - 
%   ndti     - number of dti files to be processed 
%
%   NOTE: Virtually all files and directories used by SPM5 
%         autoprocessing are defined in this structure. File 
%         and directory names can be changed without incident. 
%         Directory structure can theoretically be changed, but
%         such changes have yet to be tested.
%______________________________________________________________
if nargin < 4 | isempty(ndti),   ndti    = 0;   end 
if nargin < 3 | isempty(wfujob), wfujob  = '';  end
if nargin < 2 | isempty(nruns),  nruns   = 0;   end 

DIR.spmxdir     = spm('dir');
DIR.matcode     = fileparts(which(mfilename)); % /ansir2/WFU/distribution/WFU/wfu_batch
DIR.oldmatcode  = '/ansir2/IDLSPM/distribution/IDLSPM_WFU/appl/IDL_SPM97/SPM99F/matlabcode';
pth             = getenv('WFU_PATH');
if isempty(pth)
    error(sprintf('WFU_PATH is undefined for this user: %s',getenv('USER')));
    %DIR.shelldir = '/ansir2/WFU/distribution/WFU/WFU_SGE'; 
else
    DIR.shelldir = fullfile(pth,'WFU_SGE');
end

[p,subject] = fileparts(subjectdir); 
DIR.nruns   = nruns; 
DIR.subject = subjectdir;                                   % /subject_001
if strcmp(spm('Ver'), 'SPM5')
	DIR.analyze = fullfile(subjectdir,'nifti');             % /subject_001/nifti
else
	DIR.analyze = fullfile(subjectdir,'analyze');             % /subject_001/analyze
end
DIR.bch     = fullfile(subjectdir,'batch');                 % /subject_001/batch
DIR.bchanat = fullfile(subjectdir,'batch','anatomic');      % /subject_001/batch/anatomic
DIR.config  = fullfile(subjectdir,'config');                % /subject_001/config
DIR.dicom   = fullfile(subjectdir,'locs');                  % /subject_001/locs
DIR.log     = fullfile(subjectdir,'log');                   % /subject_001/log 
DIR.logcomp = fullfile(subjectdir,'log','completion_log');  % /subject_001/log/completion_log
DIR.logbch  = fullfile(subjectdir,'log','batch');           % /subject_001/log/batch
DIR.vbm     = fullfile(subjectdir,'VBM');                   % /subject_001/VBM
DIR.fixparadigm = [];

DIR.F.anat.batchque{1}        	= fullfile(DIR.bchanat,'batch_que');
DIR.F.anat.flist{1}          	= fullfile(DIR.bchanat,'batch.flist');
DIR.F.anat.logfile{1}        	= fullfile(DIR.bchanat,'batch_log');
DIR.F.anat.unixout{1}         	= fullfile(DIR.bchanat,'output_unix');
DIR.F.anat.matout{1}          	= fullfile(DIR.bchanat,'output_matlab');
DIR.F.anat.cpuout{1}          	= fullfile(DIR.bchanat,'output_cpufinder');
DIR.F.anat.quickstart{1}      	= fullfile(DIR.bchanat,'quick_start');

uniqueID                        = num2str(wfu_randnum(1000,10000)); 
DIR.F.anat.matname{1}.shadowT1 	= fullfile(DIR.bchanat,['norm_shadowT1_',uniqueID,'.mat']);
DIR.F.anat.xname{1}.shadowT1   	= fullfile(DIR.bchanat,['norm_shadowT1_',uniqueID,'_x.m']);
DIR.F.anat.uname{1}.shadowT1   	= fullfile(DIR.bchanat,['norm_shadowT1_',uniqueID,'_u']);



for i = 1:nruns
    DIR.bchrun{i}   = fullfile(DIR.bch,sprintf('RUN%i',i));     % /subject_001/batch/RUN(1,2,3)
    DIR.run{i}      = fullfile(subjectdir,sprintf('RUN%i',i));  % /subject_001/RUN(1,2,3)
    DIR.norm{i}     = fullfile(DIR.run{i},'normalized');        % /subject_001/RUN1/normalized
    DIR.spm{i}      = fullfile(DIR.run{i},'spm_mat');           % /subject_001/RUN1/spm_mat
    %DIR.spmest{i}   = fullfile(DIR.run{i},'spm_mat');           % /subject_001/RUN1/spm_mat
    %DIR.spmspec{i}  = fullfile(DIR.spmest{i},'spm_spec');       % /subject_001/RUN1/spm_spec
end

 
for r = 1:nruns
    uniqueID                    = num2str(wfu_randnum(1000,10000)); 
    DIR.F.matname{r}.realign    = fullfile(DIR.bchrun{r},['realign_',uniqueID,'.mat']);
    DIR.F.xname{r}.realign      = fullfile(DIR.bchrun{r},['realign_',uniqueID,'_x.m']);
    DIR.F.uname{r}.realign      = fullfile(DIR.bchrun{r},['realign_',uniqueID,'_u']);
    
%     %- Shadow T1 is only done once. Multiple names are assigned (1 per run)just for consistency
    uniqueID                    = num2str(wfu_randnum(1000,10000)); 
    DIR.F.matname{r}.shadowT1   = fullfile(DIR.bchanat,['norm_shadowT1_',uniqueID,'.mat']);
    DIR.F.xname{r}.shadowT1     = fullfile(DIR.bchanat,['norm_shadowT1_',uniqueID,'_x.m']);
    DIR.F.uname{r}.shadowT1     = fullfile(DIR.bchanat,['norm_shadowT1_',uniqueID,'_u']);
    
%    uniqueID                    = num2str(wfu_randnum(1000,10000)); 
   % DIR.F.matname{r}.shadowT1   = fullfile(DIR.bchrun{1},['norm_shadowT1_',uniqueID,'.mat']);
   % DIR.F.xname{r}.shadowT1     = fullfile(DIR.bchrun{1},['norm_shadowT1_',uniqueID,'_x.m']);
   % DIR.F.uname{r}.shadowT1     = fullfile(DIR.bchrun{1},['norm_shadowT1_',uniqueID,'_u']);

    
    uniqueID                    = num2str(wfu_randnum(1000,10000));  
    DIR.F.matname{r}.shadowEPI  = fullfile(DIR.bchrun{r},['norm_shadowEPI_',uniqueID,'.mat']);
    DIR.F.xname{r}.shadowEPI    = fullfile(DIR.bchrun{r},['norm_shadowEPI_',uniqueID,'_x.m']);
    DIR.F.uname{r}.shadowEPI    = fullfile(DIR.bchrun{r},['norm_shadowEPI_',uniqueID,'_u']);
    
    uniqueID                    = num2str(wfu_randnum(1000,10000)); 
    DIR.F.matname{r}.normEPI    = fullfile(DIR.bchrun{r},['norm_EPI_',uniqueID,'.mat']);
    DIR.F.xname{r}.normEPI      = fullfile(DIR.bchrun{r},['norm_EPI_',uniqueID,'_x.m']);
    DIR.F.uname{r}.normEPI      = fullfile(DIR.bchrun{r},['norm_EPI_',uniqueID,'_u']);
   
    uniqueID                    = num2str(wfu_randnum(1000,10000)); 
    DIR.F.matname{r}.smooth     = fullfile(DIR.bchrun{r},['smooth_',uniqueID,'.mat']);
    DIR.F.xname{r}.smooth       = fullfile(DIR.bchrun{r},['smooth_',uniqueID,'_x.m']);
    DIR.F.uname{r}.smooth       = fullfile(DIR.bchrun{r},['smooth_',uniqueID,'_u']);
    
    uniqueID                    = num2str(wfu_randnum(1000,10000)); 
    DIR.F.matname{r}.model      = fullfile(DIR.bchrun{r},['model_',uniqueID,'.mat']);
    DIR.F.xname{r}.model        = fullfile(DIR.bchrun{r},['model_',uniqueID,'_x.m']);
    DIR.F.uname{r}.model        = fullfile(DIR.bchrun{r},['model_',uniqueID,'_u']);
    
    DIR.F.batchque{r}           = fullfile(DIR.bchrun{r},'batch_que');
    DIR.F.flist{r}              = fullfile(DIR.bchrun{r},'batch.flist');
    DIR.F.logfile{r}            = fullfile(DIR.bchrun{r},'batch_log');
    DIR.F.unixout{r}            = fullfile(DIR.bchrun{r},'output_unix');
    DIR.F.matout{r}             = fullfile(DIR.bchrun{r},'output_matlab');
    DIR.F.cpuout{r}             = fullfile(DIR.bchrun{r},'output_cpufinder');
    DIR.F.quickstart{r}         = fullfile(DIR.bchrun{r},'quick_start'); 
    DIR.F.swrcomp{r}            = fullfile(DIR.logcomp,sprintf('%s_RUN%i_SWR_completed',subject,r));
    DIR.F.statscomp{r}          = fullfile(DIR.logcomp,sprintf('%s_RUN%i_STATS_completed',subject,r));
    %DIR.F.spmmat{r}             = fullfile(DIR.spmspec{r},'SPM.mat'); 
    DIR.F.spmmat{r}             = fullfile(DIR.spm{r},'SPM.mat'); 
end

DIR.F.cpufinder     = fullfile(DIR.shelldir,'cpu_finder'); 
DIR.F.launchscript  = fullfile(DIR.shelldir,'launch_matlabx');
DIR.F.runsaredone   = fullfile(DIR.logcomp,'swr_completed'); 

if ~isempty(wfujob) & wfujob.fixedeff.enabled
    DIR.fix = fullfile(subjectdir,'FIXED_EFFECTS');     % /subject_001/FIXED_EFFECTS

    for f = 1:length(wfujob.fixedeff.refs)
        paradigm                = wfujob.fixedeff.refs{f}.paradigm_name;
        DIR.fixparadigm{f}      = fullfile(DIR.fix,paradigm);
        DIR.fixref{f}           = fullfile(DIR.fixparadigm{f},'REFS');
        DIR.fixspm{f}           = fullfile(DIR.fixparadigm{f},'spm_mat');
        %DIR.fixspmest{f}        = fullfile(DIR.fixparadigm{f},'spm_mat');
        %DIR.fixspmspec{f}       = fullfile(DIR.fixspmest{f},'spm_spec');
    
        uniqueID                = num2str(wfu_randnum(1000,10000)); 
        DIR.F.fixmatname{f}     = fullfile(DIR.fixparadigm{f},['fixedeff_model_',uniqueID,'.mat']);
        DIR.F.fixxname{f}       = fullfile(DIR.fixparadigm{f},['fixedeff_model_',uniqueID,'_x.m']);
        DIR.F.fixuname{f}       = fullfile(DIR.fixparadigm{f},['fixedeff_model_',uniqueID,'_u']);
        
        DIR.F.fixbatchque{f}    = fullfile(DIR.fixparadigm{f},'batch_que');
        DIR.F.fixflist{f}       = fullfile(DIR.fixparadigm{f},'batch.flist');
        DIR.F.fixlogfile{f}     = fullfile(DIR.fixparadigm{f},'batch_log');
        DIR.F.fixunixout{f}     = fullfile(DIR.fixparadigm{f},'output_unix');
        DIR.F.fixmatout{f}      = fullfile(DIR.fixparadigm{f},'output_matlab');
        DIR.F.fixcpuout{f}      = fullfile(DIR.fixparadigm{f},'output_cpufinder');
        DIR.F.fixquickstart{f}  = fullfile(DIR.fixparadigm{f},'quick_start'); 
        DIR.F.fixcomp{f}        = fullfile(DIR.logcomp,sprintf('%s_FIXED_EFFECTS_%i_of_%i_completed',subject,f,length(wfujob.fixedeff.refs))); 
        DIR.F.fixfullflist{f}   = fullfile(DIR.fix,sprintf('%s.flist',paradigm));
        %DIR.F.fixspmmat{f}      = fullfile(DIR.fixspmspec{f},'SPM.mat');
        DIR.F.fixspmmat{f}      = fullfile(DIR.fixspm{f},'SPM.mat');
    end
else
    DIR.F.fixquickstart = []; 
end


if ndti
    for d = 1:ndti
                  
        %%%%% Define DTI directory structure %%%%%
        DIR.dti{d}          = fullfile(subjectdir,sprintf('DTI_S%03i',d));% /subject_001/DTI_S(1,2,3)
        DIR.trackvis{d}     = fullfile(DIR.dti{d},'trackvis');
        DIR.slicer{d}       = fullfile(DIR.dti{d},'slicer');
        DIR.medinria{d}     = fullfile(DIR.dti{d},'medinria');
        DIR.dtistudio{d}    = fullfile(DIR.dti{d},'dtistudio');   
        DIR.bchdti{d}       = fullfile(DIR.bch,sprintf('DTI_S%03i',d));   % /subject_001/batch/DTI_S(1,2,3)
        DIR.dtidicom{d}     = fullfile(subjectdir,'nifti_input');       % /subject_001/nifti_input
        DIR.dtitensor       = fullfile(subjectdir,'config');            % /subject_001/config
        DIR.reports         = fullfile(subjectdir,'reports');
       
        %%%%% Define DTI filenames %%%%%
        uniqueID            = num2str(wfu_randnum(1000,10000));
        DIR.F.dtidicom{d}   = fullfile(DIR.bchdti{d},['dtidicom_',uniqueID]);
        DIR.F.dtifa{d}      = fullfile(DIR.bchdti{d},['dtifa_',uniqueID]); 
        DIR.F.dtibvec{d}    = fullfile(DIR.bchdti{d},['dtibvec_',uniqueID]); 
        DIR.F.dtifa{d}      = fullfile(DIR.bchdti{d},['dtifa_',uniqueID]); 
        DIR.F.dticoreg{d}   = fullfile(DIR.bchdti{d},['dticoreg_',uniqueID]); 
        DIR.F.dtireport{d}  = fullfile(DIR.bchdti{d},['dtireport_',uniqueID]);
        DIR.F.dtibatchque{d}= fullfile(DIR.bchdti{d},'batch_que');
        DIR.F.dtiflist{d}   = fullfile(DIR.bchdti{d},'batch.flist');
        DIR.F.dtiquickstart{d}=fullfile(DIR.bchdti{d},'quick_start'); 
        
        %-these should be series-specific-%
        DIR.F.dtitensor     = fullfile(DIR.dtitensor,'tensor.dat'); 
        DIR.F.dtifalog{d}      = fullfile(DIR.bchdti{d},'FSL_wfu_dti.log'); 
        DIR.F.dticoreglog{d}   = fullfile(DIR.bchdti{d},'FSL_wfu_dti_coreg.log'); 
        DIR.F.dtireportlog{d}  = fullfile(DIR.bchdti{d},'FSL_wfu_dti_report.log'); 
        DIR.F.dtireportname{d} = fullfile(DIR.reports,'wfu_dti_report.csv'); 
              
    end
end
