function datafield = wfu_copy_epis(DIR,epis)

%   Copy epis (.img, .hdr and .mat) into the appropriate run
%   directory. 
%   Example: attn001_07_12_05/RUN1/normalized
%
%   FORMAT datafield = wfu_copy_epis(DIR,epis)
%   
%   datafield   - structure array of epi images in their new
%                 locations 
%   DIR         - structure containing full paths of all 
%                 subject subdirectories and standard
%                 filenames
%   epis        - cell array of epi pfile names
%____________________________________________________________

if ~isequal(length(epis),length(DIR.norm))
    error(sprintf('Number of .info files (%i) is not equal to number of runs (%i)',length(epis),length(DIR.norm))); 
end

%--- copy 4D epis into place ---%
for r = 1:length(epis) 
    %oldimg  = [epis{r},'_4D.img'];
    %oldhdr  = [epis{r},'_4D.hdr'];
    %oldmat  = [epis{r},'_4D.mat'];
    %[p,n,e] = fileparts(oldimg);
    [p,n,e] = fileparts(epis{r});
    oldimg  = fullfile(p,[n,'.img']);
    oldhdr  = fullfile(p,[n,'.hdr']);
    oldmat  = fullfile(p,[n,'.mat']);
    newimg  = fullfile(DIR.norm{r},[n,'.img']);
    newhdr  = fullfile(DIR.norm{r},[n,'.hdr']);
    newmat  = fullfile(DIR.norm{r},[n,'.mat']);
    omat  = fullfile(DIR.norm{r},[n,'.mat.original']);
    copyimg = sprintf('echo yes | cp %s %s',oldimg,newimg);
    copyhdr = sprintf('echo yes | cp %s %s',oldhdr,newhdr);
    copymat = sprintf('echo yes | cp %s %s',oldmat,newmat);
    copyomat = sprintf('echo yes | cp %s %s',oldmat,omat);
    unix(copyimg);
    unix(copyhdr);
    unix(copymat);
    unix(copyomat);
    datafield.data{r}   = newimg;
    header              = nifti(newimg); 
    datafield.vols(r)   = header.dat.dim(4); 
end
