function defaults = wfu_defaults(wfujob) 

%   List of default parameters used at the Wake Forest University
%   ANSIR laboratory
%   FORMAT defaults = wfu_defaults
%
%   defaults - structure containing WFU defined parameters
%   send wfujob structure to modify fields from defaults based on ref
%
%________________________________________________________________
global defaults 
spm_defaults; 
modify_flags = 1;
if nargin < 1, modify_flags = 0; end;

%----- realignment -----%
defaults.realign.enabled            =   1;      

defaults.realign.estimate.quality   =   0.7500;         % quality/speed tradeoff,1=poor/fast,0=best/slow
defaults.realign.estimate.fwhm      =   5;              % smoothing kernel applied before realignment 
defaults.realign.estimate.rtm       =   0;              % register to mean, 2-pass is used if field exists
defaults.realign.estimate.sep       =   4;              % default separation to sample the images
defaults.realign.estimate.interp    =   2;              % 2=2nd degree B-spline interpolation
defaults.realign.estimate.wrap      =   [0 0 0];        % [1 1 1] = wrap x, y, and z.
defaults.realign.estimate.PW        =   '';             % spm format = STRING, NOT CELL
defaults.realign.estimate.graphics  =   1;              % only in spm_realign.m 
defaults.realign.estimate.lkp       =   [1 2 3 4 5 6];  % used in estimation only, not writing

defaults.realign.write.interp       =   4;              % spm_defaults & spm_reslice have diff interp#
defaults.realign.write.wrap         =   [0 0 0];        % [1 1 1] = wrap x, y, and z.
defaults.realign.write.mask         =   1;              % reduces mvmt-related variance (see spm_reslice)
defaults.realign.write.which        =   2;              % 2=reslice all images
defaults.realign.write.mean         =   1;              % create mean image, y/n

if modify_flags, 
    defaults = wfu_setfield(defaults,'defaults.realign.estimate',wfujob.realign.estimate);
    defaults = wfu_setfield(defaults,'defaults.realign.write',wfujob.realign.write);
end
    

%----- normalisation -----%
%defaults.normalise.enabled              =   1;
defaults.normalise.anat.enabled         =   1;
defaults.normalise.shadow.enabled       =   1;
defaults.normalise.epi.enabled          =   1;

defaults.normalise.type                 =   {'T1-EPI','EPI'}; 

defaults.normalise.estimate.smosrc      =   8; 
defaults.normalise.estimate.smoref      =   0; 
defaults.normalise.estimate.regtype     =   'mni'; 
defaults.normalise.estimate.weight      =   ''; 
defaults.normalise.estimate.cutoff      =   25; 
defaults.normalise.estimate.nits        =   16; 
defaults.normalise.estimate.reg         =   1; 
defaults.normalise.estimate.wtsrc       =   0;
defaults.normalise.estimate.graphics    =   1; 
defaults.normalise.estimate.mniT1       =   fullfile(spm('dir'),'templates','T1.nii'); 
defaults.normalise.estimate.mniEPI      =   fullfile(spm('dir'),'templates','EPI.nii');
defaults.normalise.write.preserve       =   0;
defaults.normalise.write.bb             =   [-90 -126 -72; 90 90 108];
defaults.normalise.write.vox            =   [2 2 2]; 
defaults.normalise.write.interp         =   1; 
defaults.normalise.write.wrap           =   [0 0 0]; 
defaults.normalise.write.which          =   1; 
defaults.normalise.write.mean           =   1; 
% defaults.normalise.reslice_anat
% defaults.normalise.reslice_anat.vox    = [1 1 1]; 
% -- the matrix size or voxel dimensions are different b/t EPI and T1.
%----- normalise -----% 
defaults.normalise.shadow.enabled       =   1; 

if modify_flags, 
    defaults = wfu_setfield(defaults,'defaults.normalise.estimate',wfujob.normalise.estimate);
    defaults = wfu_setfield(defaults,'defaults.normalise.write',wfujob.normalise.write);
    defaults = wfu_setfield(defaults,'defaults.normalise.shadow',wfujob.normalise.shadow);
end




%----- segmentation -----%
defaults.segment.enabled         =   0;
defaults.segment.estimate.priors    =   char(...
    fullfile(spm('Dir'),'apriori','grey.nii'),...
    fullfile(spm('Dir'),'apriori','white.nii'),...
    fullfile(spm('Dir'),'apriori','csf.nii'));
defaults.segment.estimate.reg           =   0.01; 
defaults.segment.estimate.cutoff        =   30; 
defaults.segment.estimate.samp          =   3;
defaults.segment.estimate.bb            =   [-90 -126 -72; 90 90 108];
defaults.segment.estimate.affreg.smosrc =   8;  
defaults.segment.estimate.affreg.regtype =   'mni'; 
defaults.segment.estimate.affreg.weight =   ''; 

defaults.segment.write.cleanup        =   1; 
defaults.segment.write.wrt_cor        =   1; 
defaults.segment.write.wrt_brV        =   1; 

if modify_flags, 
    defaults = wfu_setfield(defaults, 'defaults.segment.estimate',wfujob.segment.estimate);
    defaults = wfu_setfield(defaults, 'defaults.segment.write',wfujob.segment.write);
end

% VBM Preprocessing defaults
%=======================================================================
defaults.preproc.tpm     = char(...
    fullfile(spm('Dir'),'tpm','grey.nii'),...
    fullfile(spm('Dir'),'tpm','white.nii'),...
    fullfile(spm('Dir'),'tpm','csf.nii')); % Prior probability maps
defaults.preproc.ngaus    = [2 2 2 4];     % Gaussians per class
defaults.preproc.warpreg  = 1;             % Warping Regularisation
defaults.preproc.warpco   = 25;            % Warp Frequency Cutoff
defaults.preproc.biasreg  = 0.0001;        % Bias regularisation
defaults.preproc.biasfwhm = 60;            % Bias FWHM
defaults.preproc.regtype  = 'mni';         % Affine Regularisation
defaults.preproc.samp     = 3;             % Sampling distance

if modify_flags, 
    defaults = wfu_setfield(defaults,'defaults.preproc',wfujob.preproc);
end


%----- smoothing -----%
defaults.smooth.enabled                 =   1;
defaults.smooth.fwhm                    =   [8 8 8];
if modify_flags, 
    defaults = wfu_setfield(defaults,'defaults.smooth',wfujob.smooth);
end





%----- fixedeff.model -----%
defaults.model.enabled                              = 1; 
defaults.model.fmri_spec.dir                        = ''; 
defaults.model.fmri_spec.fact                       = {};
defaults.model.fmri_spec.volt                       = 1;            % Volterra inter's: 1=NO, 2=YES
defaults.model.fmri_spec.mask                       = '';
defaults.model.fmri_spec.cvi                        = 'AR(1)';      %'AR(1)' or 'none'
defaults.model.fmri_spec.global                     = 'Scaling';    %'Scaling' or 'None'
defaults.model.fmri_spec.bases.hrf.derivs           = [0 0];
defaults.model.fmri_spec.timing.units               = 'secs'; 
defaults.model.fmri_spec.timing.RT                  = [];
defaults.model.fmri_spec.timing.fmri_t              = 16;
defaults.model.fmri_spec.timing.fmri_t0             = 1;
defaults.model.fmri_spec.sess(1).regress            = {};
defaults.model.fmri_spec.sess(1).hpf                = 128;
defaults.model.fmri_spec.sess(1).cond(1).tmod       = 0;
defaults.model.fmri_spec.sess(1).cond(1).mod        = {};
defaults.model.fmri_spec.sess(1).cond(1).name       = ''; 
defaults.model.fmri_spec.sess(1).cond(1).onset      = [];
defaults.model.fmri_spec.sess(1).cond(1).duration   = [];
defaults.model.fmri_spec.sess(1).scans              = '';
defaults.model.fmri_spec.sess(1).multi              = {''};
defaults.model.fmri_est.method.Classical            = 1; 

%----- contrasts -----% 
defaults.contrasts.enabled                          = 1; 

%----- fixed effects -----% 
defaults.fixedeff.enabled                                   = 1;
defaults.fixedeff.model.fmri_spec.dir                       = ''; 
defaults.fixedeff.model.fmri_spec.fact                      = {};
defaults.fixedeff.model.fmri_spec.volt                      = 1;            % Volterra inter's: 1=NO, 2=YES
defaults.fixedeff.model.fmri_spec.mask                      = '';
defaults.fixedeff.model.fmri_spec.cvi                       = 'AR(1)';      %'AR(1)' or 'none'
defaults.fixedeff.model.fmri_spec.global                    = 'Scaling';    %'Scaling' or 'None'
defaults.fixedeff.model.fmri_spec.bases.hrf.derivs          = [0 0];
defaults.fixedeff.model.fmri_spec.timing.units              = 'secs'; 
defaults.fixedeff.model.fmri_spec.timing.RT                 = [];
defaults.fixedeff.model.fmri_spec.timing.fmri_t             = 16;
defaults.fixedeff.model.fmri_spec.timing.fmri_t0            = 1;
defaults.fixedeff.model.fmri_spec.sess(1).regress           = {};
defaults.fixedeff.model.fmri_spec.sess(1).hpf               = 128;
defaults.fixedeff.model.fmri_spec.sess(1).cond(1).tmod      = 0;
defaults.fixedeff.model.fmri_spec.sess(1).cond(1).mod       = {};
defaults.fixedeff.model.fmri_spec.sess(1).cond(1).name      = ''; 
defaults.fixedeff.model.fmri_spec.sess(1).cond(1).onset     = [];
defaults.fixedeff.model.fmri_spec.sess(1).cond(1).duration  = [];
defaults.fixedeff.model.fmri_spec.sess(1).scans             = '';
defaults.fixedeff.model.fmri_spec.sess(1).multi             = {''};
defaults.fixedeff.model.fmri_est.method.Classical           = 1; 
