function ok = wfu_exportjob(fname,jobs)
%JAM  - program modified to correctly generate a .m file that can be called as a function
%and repopulate the job structure properly for use in the spm_jobman routine
ok = 0;
if ~nargin, return; end
%defaults = job_defaults;
defaults=[];
%load(jobname);
global jobcomments indent;
indent = '  ';
%jobcomments = readcomments;
jobcomments.names = '';
job_version = 1;
[pth,nam,ext] = fileparts(fname);
fname = fullfile(pth,[nam '_wfu.m']);
file = fopen(fname,'wt');
fprintf(file, 'function jobs = %s\n',nam);
fprintf(file, '%% spmjob JOB file - generated by spmjob %1.2f\n',job_version);
%fprintf(file, 'job = job_defaults;\n\n');


ok1 = cycle_jobs(jobs,file,1);

%fprintf(file, 'runjob(job,''spm'');\n');
fclose(file);
return

function ok1 = cycle_jobs(jobs,file,parent)
ok1 = 0;
defaults = [];
sz = size(jobs);
for n = 1:sz(2)
	level1_fields = fieldnames(jobs{n});
	nlevels = size(level1_fields);
	for j = 1:nlevels(2)
		nf = char(level1_fields(j,:));
		nfield = getfield(jobs{n},nf);
		matched = 0;
		if ~iscell(nfield)
			exportstruct(file,'job',nfield,'super',defaults); 
			fprintf(file,'myjob = job ; job  = [];\tcrap{1} = myjob;\n');
			matched = 1;
			else ok2 = cycle_jobs(nfield,file,0);
		end
		if matched
		   %fprintf(file, 'myjob = crap;\tjobs{%s}.%s = myjob{1};\n',num2str(n),nf);
		   fprintf(file, 'myjob = crap;\tjobx{%s}.%s = myjob{1};\n',num2str(n),nf);

		   else 
		     	if ~parent
			 %fprintf(file, 'myjob = crap;\tjobs{%s}.%s{%s} = myjob{1};\n',num2str(n),nf,num2str(j));
		    	 %else  fprintf(file, 'myjob = jobs;\tjobs{%s}.%s{1} = myjob;\n',num2str(n),nf);
 			 fprintf(file, 'myjob = crap;\tjobs{%s}.%s{%s} = jobx;\n',num2str(n),nf,num2str(j));
		    	 else  fprintf(file, '\tjobs{%s}.%s = jobx;\n',num2str(n),nf);

		 	end
		
		end
	end
end
return


function ok = exportjob1(fname,job)
% Export a job to a .m file
% FORMAT  ok = exportjob(fname,job)
%   fname - file name
%   job - job structure
%
% (c) Copyright 2003,2004 Thomas Tanner (tanner@gmx.de)
%$Id: wfu_exportjob.m,v 1.2 2009/02/27 21:19:52 bwagner Exp $

%     This program is free software; you can redistribute it and/or
%     modify it under the terms of the GNU General Public License as
%     published by the Free Software Foundation; either version 2 of
%     the License, or (at your option) any later version.
%
%     This program is distributed in the hope that it will be useful,
%     but WITHOUT ANY WARRANTY; without even the implied warranty of
%     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
%     GNU General Public License for more details.
%
%     You should have received a copy of the GNU General Public License
%     along with this program; if not, write to the Free Software
%     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
%     MA 02111-1307 USA
%--------------------------------------------------------------------------

ok = 0;
if ~nargin, return; end
defaults = job_defaults;
defaults=[];

global jobcomments indent;
indent = '  ';
%jobcomments = readcomments;
jobcomments.names = '';

file = fopen(fname,'wt');
fprintf(file, '%% spmjob JOB file - generated by spmjob %1.2f\n',job_version);
%fprintf(file, 'job = job_defaults;\n\n');
exportstruct(file,'job',job,'super',defaults);
%fprintf(file, 'runjob(job,''spm'');\n');
fclose(file);

%--------------------------------------------------------------------------

function exportstruct(file,prefix,x0,context,defaults)
hprefix = prefix;
global jobcomments indent;
sub = fieldnames(x0);
if isempty(sub)
    fprintf(file,'struct');
    return
end
if strcmp(context,'cell') fprintf(file,'struct('); end
for nx = 1:length(x0)
  if nx > 1, prefix = [hprefix '(' num2str(nx) ')' ]; end
	x = x0(nx);
	for i=1:length(sub)
	    xsub = getfield(x,sub{i});
	    defsub = [];
	    if isfield(defaults,sub{i})
	        defsub = getfield(defaults,sub{i});
	        if isequalwithequalnans(xsub, getfield(defaults,sub{i})), continue; end
	    end
    if ~strcmp(context,'cell')
        field = [prefix '.' sub{i}];
        j = strmatch(field,jobcomments.names,'exact');
        if ~isempty(j)
            comm = jobcomments.descr{j};
            if ~isempty(comm)
                fprintf(file,comm);
                fprintf(file,'\n');
            end
            def = jobcomments.default{j};
            if ~isempty(def)
                fprintf(file,'%% default: %s\n',def);
            end
        else
            fprintf(file,'% unknown parameter\n');
        end
    end
    xclass = class(xsub);
    if strcmp(xclass,'struct')
        if strcmp(context,'cell')
            exportstruct(file,hprefix, xsub, context, defsub);
        else
            exportstruct(file,[hprefix '.' sub{i}], xsub, 'sub', defsub);
        end
    else
        if strcmp(context,'cell')
            fprintf(file,'''%s'', ', sub{i});
            pref = [prefix indent];
        else
            fprintf(file,'%s = ',[prefix '.' sub{i}]);
            pref = '';
        end
        switch class(xsub)
        case 'char'
            exportchar(file, pref, xsub);
        case 'double'
            exportnum(file, pref, xsub);
        case 'cell'
            exportcell(file, pref, xsub, strcmp(context,'cell'));
        end
        if ~strcmp(context,'cell'), fprintf(file,';\n'); end
    end
    if strcmp(context,'cell') & i<length(sub), fprintf(file,','); end
    if strcmp(context,'super'), fprintf(file,'\n'); end
end
end %for nx
if strcmp(context,'cell'), fprintf(file,')'); end

function exportchar(file,prefix, xsub)
global indent;
s = size(xsub);
if ~all(s)
    fprintf(file,'''''');
elseif s(1) == 1
    [str,fmt] = finalStr(xsub);
    fprintf(file,fmt,str);
else
    fprintf(file,'[...\n');
    for j=1:s(1)
        [str,fmt] = finalStr(xsub(j,:));
        fprintf(file,[prefix indent fmt],str);
        if j<s(1), fprintf(file,';'); end
        fprintf(file,'...\n');
    end
    fprintf(file,[prefix indent ']']);
end

function [str,fmt] = finalStr(str)
spmdir = spm('Dir');
if strncmp(str,spmdir,length(spmdir))
    dir = fullfile(spmdir,'apriori');
    fmt = 'fullfile(spm(''Dir''),''apriori'',''%s'')';
    if strncmp(str,dir,length(dir))
        str = str(length(dir)+2:end);
        return
    end
    dir = fullfile(spmdir,'templates');
    fmt = 'fullfile(spm(''Dir''),''templates'',''%s'')';
    if strncmp(str,dir,length(dir))
        str = str(length(dir)+2:end);
        return
    end
end
fmt = '''%s''';

function exportnum(file,prefix,xsub)
global indent;
s = size(xsub);
if ~all(s)
    fprintf(file,'[]');
elseif isequal(s,[1,1])
    exportnumrow(file, xsub)
elseif s(1) == 1
    fprintf(file,'[');
    exportnumrow(file, xsub)
    fprintf(file,']');
elseif s(1)*s(2) <= 6
    fprintf(file,'[');
    for j=1:s(1)
        exportnumrow(file, xsub(j,:))
        if j<s(1), fprintf(file,'; '); end
    end
    fprintf(file,']');
else
    fprintf(file,'[...\n');
    for j=1:s(1)
        fprintf(file,[prefix indent]);
        exportnumrow(file, xsub(j,:))
        fprintf(file,';...\n');
    end
    fprintf(file,[prefix indent ']']);
end

function exportnumrow(file,x)
s = length(x);
for i=1:s
    if floor(x) == x
        fprintf(file,'%i',x(i));
    else
        fprintf(file,'%f',x(i));
    end
    if i<s, fprintf(file,' '); end
end

function exportcell(file,prefix, x, in_struct)
global indent;
s = size(x);
if ~all(s)
    fprintf(file,'{}');
    return
end
for i=1:1+in_struct, fprintf(file,'{'); end
fprintf(file,'...\n');
pref = [prefix indent];
for j=1:s(1)
    fprintf(file,pref);
    for i=1:s(2)
        switch class(x{j,i})
        case 'char'
            exportchar(file, pref, x{j,i});
        case 'double'
            exportnum(file, pref, x{j,i});
        case 'cell'
            exportcell(file,pref, x{j,i}, 0);
        case 'struct'
            exportstruct(file,pref, x{j,i}, 'cell', []);
        end
        if i<s(2), fprintf(file,', '); end
    end
    fprintf(file,';...\n');
end
fprintf(file,prefix);
for i=1:1+in_struct, fprintf(file,'}'); end

% --------------------------------------------------------------------

function comments = readcomments;
[path,name,ext,ver] = fileparts(mfilename);
fname = fullfile(path,'runjob.m');
comments.names = {};
comments.descr = {};
comments.default = {};

file = fopen(fname,'rt');
mode = 0;
% 0 = look for first '%'
% 1 = look for '% job.' or end of comments
% 2 = read descr until single '%'
while 1
    % read until first '%'
    % then until last '%' do
    % look for lines starting with '% job.', save until space
    % read comments starting with '%   ' until '%$', save
    line = fgetl(file);
    if ~ischar(line), break, end;
    if ~mode & strncmp(line,'%',1), mode = 1; end
    if mode == 1 & strncmp(line,'% job.',6)
        mode = 2;
        curdescr = '';
        [name,def] = strtok(line(2:end));
        while 1
            [tmp,def] = strtok(def);
            if isempty(tmp) | strncmp(tmp,'(default:',9), break, end
        end
        if ~isempty(def)
            tmp1 = strfind(def,strtok(def));
            tmp2 = strfind(def,')');
            def = def(tmp1(1):tmp2(end)-1);
        end
        comments.names{end+1} = name;
        comments.default{end+1} = def;
    elseif mode == 2
        if strncmp(line,'%   ',4) & length(line)>4 & strtok(line(2:end))
            line = strrep(['% ' line(5:end)],'%','%%');
            if isempty(curdescr)
                curdescr = line;
            else
                curdescr = [curdescr '\n' line];
            end
        else
            comments.descr{end+1} = curdescr;
            mode = 1;
        end
    end
end
if mode==2
    comments.descr{end+1} = curdescr;
end
fclose(file);
