function [runrefs,dirlist] = wfu_fe_scriptwrite(fedir,flist,fixedref)
%
%
%===================================================% 
dirlist = {};
refdir  = {};
runrefs = {};

if ~exist(fedir,'dir')
    error('Fixed effects directory: %s does not exist'); 
else
    outputdir = fedir;
end

%%%%% get directory list from flist %%%%%
if ~exist('flist','var')
    error('wfu_fe_scriptwrite cannot run without a file list (flist) of run'); 
elseif ~exist(flist,'file')
    error(sprintf('File list (%s) does not exist. Terminating.',flist));
else
    list = wfu_read_flist(flist);
    for i = 1:size(list,1); 
        dirlist{i} = char(list(i,:));
    end       
end

%%%%% get FE reference function, read it %%%%%
if ~exist(fixedref) | isempty(fixedref)
    error('No fixed effect reference function specified. Terminating.');
elseif ~exist(fixedref,'file')
    error(sprintf('Fixed effect reference function given (%s) does not exist. Terminating.',fixedref));
else 
    ref = wfu_read_refs(fixedref);
end

%%%%% find the ref functions from the runs in flist %%%%%
for r = 1:length(dirlist)
    %d = dirlist{r};
    %[path1,rundirname] = fileparts(d);
    %[path2,batchname]  = fileparts(path1);
    %refdir{r}       = fullfile(path2,rundirname); 
    %refs            = wfu_find_files('.*ref$',refdir{r}); 
    refs            = wfu_find_files('.*ref$',dirlist{r}); 
    if isempty(refs)
        error(sprintf('No reference functions in dir: %s',refdir{r}));
    elseif length(refs) > 1
        error(sprintf('Too many reference functions in dir: %s',refdir{r}));
    else
        temp        = wfu_read_refs(refs{1}); 
        runrefs{r}  = temp{1}; 
    end
end

