function [quickstartlist,fixquickstarts] = wfu_final_prep(anatulist,ulist,fixulist,DIR,wfujob,runvector,email_address);

quickstartlist = {};
fixquickstarts = {}; 


%========================= ANAT PROCESSING ============================%

if ~isempty(anatulist)
    %--- write bach_que and flists---% 
    wfu_batch_que(anatulist,DIR,wfujob,'anat',runvector,email_address);
    
    %--- get quick_start ---%
       if ~exist(DIR.F.anat.quickstart{1})
            qstemplate = fullfile(DIR.shelldir,'quick_start');
            [a,b] = unix(sprintf('cp %s %s',qstemplate,DIR.F.anat.quickstart{1}));
            if ~exist(DIR.F.anat.quickstart{1},'file')
                error(sprintf('Could not copy quick_start file for anatomic.')); 
            end
            unix(sprintf('chmod 777 %s',DIR.F.anat.quickstart{1}));
        end
	[qpath] = fileparts(DIR.F.anat.quickstart{1});
%	qcmd = ['cd ' qpath ' ; ./quick_start ; cd ' pwd];
	qcmd = [qpath];
	quickstartlist{end+1} = qcmd;
end

%========================= 1st LEVEL PROCESSING ============================%

if ~isempty(ulist)
    %--- write bach_que and flists---% 
    wfu_batch_que(ulist,DIR,wfujob,'one_run',runvector,email_address);
    
    %--- get quick_start ---% 
    for r = runvector
        if ~exist(DIR.F.quickstart{r})
            qstemplate = fullfile(DIR.shelldir,'quick_start');
            [a,b] = unix(sprintf('cp %s %s',qstemplate,DIR.F.quickstart{r}));
            if ~exist(DIR.F.quickstart{r},'file')
                error(sprintf('Could not copy quick_start file for RUN-%i.',r)); 
            end
            unix(sprintf('chmod 777 %s',DIR.F.quickstart{r}));
        end
	[qpath] = fileparts(DIR.F.quickstart{r});
%	qcmd = ['cd ' qpath ' ; ./quick_start ; cd ' pwd];
	qcmd = [qpath];
	quickstartlist{end+1} = qcmd;
    end
    
    %--- copy reference functions into batch directories ---% 
    for r = runvector
        newref = fullfile(DIR.run{r},sprintf('RUN%i.se_ref',r));
        copystr = sprintf('echo yes | cp %s %s',wfujob.refs{r}.refname,newref); 
        [a,b] = unix(copystr);
        if ~exist(newref,'file')
            error(sprintf('Could not copy reference function for RUN-%i.',r));
        end
    end
end

%============================ FIXED EFFECTS =================================% 

if ~isempty(fixulist)
    %--- write batch_que and batch.flists---% 
    wfu_batch_que(fixulist,DIR,wfujob,'fixed_effects',runvector,email_address);
    
    %--- get quick_start ---% 
    for f = 1:length(fixulist)
        if ~exist(DIR.F.fixquickstart{f})
            qstemplate = fullfile(DIR.shelldir,'quick_start');
            [a,b] = unix(sprintf('echo yes | cp %s %s',qstemplate,DIR.F.fixquickstart{f}));
            if ~exist(DIR.F.fixquickstart{f},'file')
                error(sprintf('Could not copy quick_start file for FIXED EFFECTS (%i of %i)',f,length(fixulist))); 
            end
            [a,b] = unix(sprintf('chmod 777 %s',DIR.F.fixquickstart{f}));
        end
	[qpath] = fileparts(DIR.F.fixquickstart{f});
%	qcmd = ['cd ' qpath ' ; ./quick_start ; cd ' pwd];
	qcmd = [qpath];
	fixquickstarts{end+1} = qcmd;
    end
    
    %--- copy reference functions into fixed effects directory ---% 
    for f = 1:length(fixulist)
        [path,name,ext] = fileparts(wfujob.fixedeff.refs{f}.refname);
        newref          = fullfile(DIR.fix,[name,ext]); 
        copystr = sprintf('echo yes | cp %s %s',wfujob.fixedeff.refs{f}.refname,newref);
        [a,b] = unix(copystr); 
        if ~exist(newref,'file')
            error(sprintf('Could not copy reference function for FIXED EFFECTS (%i of %i)',f,length(fixulist)));
        end
        for r = 1:length(wfujob.fixedeff.refs{f}.runids)
            run             = wfujob.fixedeff.refs{f}.runids(r);
            [path,name,ext] = fileparts(wfujob.refs{run}.refname); 
            newrunref       = fullfile(DIR.fixref{f},[name,ext]);  
            copystr = sprintf('echo yes | cp %s %s',wfujob.refs{run}.refname,newrunref);
            [a,b] = unix(copystr); 
            if ~exist(newrunref,'file')
                error(sprintf('Could not copy RUN reference functions for FIXED EFFECTS (%i of %i)',f,length(fixulist)));
            end
        end
    end
end

    
