function wfujob = wfu_fixed_effects(wfujob,refnum)

%   Add fixed effects analysis to wfujob structure
%   FORMAT wfujob = wfu_fixed_effects(wfujob)
%
%   wfujob  - job structure for autoprocessing that contains
%             user-defined parameters
%
%   NOTE: A rather inelegant method is used to determine
%         which paradigms belong to which fixed effects (FE)
%         analysis. Each paradigm reference function is
%         examined for a FE lookup code. If one is found, the
%         FE reference function is read and the
%         'combined_paradigms' field is used to identify the
%         paradigms needed. An index is then created to match
%         each paradigm with its respective run/epi
%____________________________________________________________
warning off MATLAB:deblank:NonStringInput
%____________________________________________________________



fixed    = {};
usedcode = [];
runcount = 1;
if nargin > 1 & refnum
    if isnumeric(refnum), refnum = cellstr(refnum); end
    for n = 1:length(refnum);
        ref = wfu_paradigm_lookup(refnum{n});
        if ~isempty(ref)
            refstruct   = wfu_read_refs(ref);
            reftext     = refstruct{1};
            for runpar = 1:length(reftext.combined_paradigms)
                for r = 1:length(wfujob.refs)
                    [path,name,ext] = fileparts(wfujob.refs{r}.refname);
                    if strcmp(reftext.combined_paradigms{runpar},name);
                        reftext.runids(runpar) = r;
                    end
                end
            end
            [reftext,wfujob] = wfu_merge_defaults(reftext,wfujob);
            fixed{end+1}     = reftext;
        else
            error(sprintf('Paradigm code %.2f is not valid.',refnum{n}));
        end
    end
elseif ~isempty(wfujob.refs{1})
    [alt_paradigm_names, alt_paradigms_list] = wfu_get_alternate_paradigms(wfujob.subjectdir);
    for i = 1:length(wfujob.refs)
        if isfield(wfujob.refs{i},'Fixed_effects_lookup_code') && (wfujob.refs{i}.Fixed_effects_lookup_code > 0) 
            code = wfujob.refs{i}.Fixed_effects_lookup_code;
            if isnumeric(code)
                index = find(code==usedcode);
                if isempty(index)
                    ref = wfu_paradigm_lookup(code);
                    if ~isempty(ref)
                        usedcode(end+1) = code;
                        % <<>> <<>> <<>> <<>> <<>> <<>> <<>> <<>> <<>> <<>>
                        refstruct       = wfu_read_refs(ref);
                        reftext         = refstruct{1};

                        for runpar = 1:length(reftext.combined_paradigms)
                            for r = 1:length(wfujob.refs)
                                [path,name,ext] = fileparts(wfujob.refs{r}.refname);
                                if strcmp(reftext.combined_paradigms{runpar},name);
                                    reftext.runids(runpar) = r;
                                end
                            end
                        end
                        %-----------------------------------------------------------------
                        %alternate and global paradigms need to be read here
                        %and the wfujobs.refs structure needs to be reloaded with these
                        %using run order matching when reloading alternates
                        %need to create a cell array called alt_paradigm_names
                        %containing alternate paradigm names if they exist (in the parent folder)
                        %requires reading all the refs in the alternate paradigm folder ahead of time
                        % and placing the filenames into a cell array called alt_paradigm_list
                        %-----------------------------------------------------------------
                        if isfield(reftext,'global_alternate') | (isfield(reftext,'alternate_paradigms'))
                            for j = 1:length(reftext.combined_paradigms)
                                alt_index = reftext.runids(j);
                                altref=[];
                                if isfield(reftext,'global_alternate') & (reftext.global_alternate == 1)
                                    altref = wfu_paradigm_lookup(reftext.global_alernate_id{j});
                                end
                                if isfield(reftext,'alternate_paradigms') & ~isempty(reftext.alternate_paradigms) & (reftext.alternate_paradigms ~= 0)
                                    alt_paradigm_index = find(strcmp(alt_paradigm_names,reftext.alternate_paradigms{j}));
                                    altref = alt_paradigm_list{alt_paradigm_index}
                                end
                                if altref, wfujob.refs{alt_index} = wfu_read_refs(altref); end
                            end
                        end
                        [reftext,wfujob] = wfu_merge_defaults(reftext,wfujob);
                        fixed{end+1}     = reftext;
                    else
                        error(sprintf('Paradigm code %.2f is not valid.',code));
                    end
                else
                    continue
                end
            end
        end
    end
else
    error('No reference functions could be found in wfujob structure.');
end

if ~isempty(fixed)
    if ~isempty(fixed{1})
        wfujob.fixedeff.enabled = 1;
        wfujob.fixedeff.refs    = fixed;
    else
    wfujob.fixedeff.enabled = 0;
    end
else
   wfujob.fixedeff.enabled = 0; 
end

if ~wfujob.fixedeff.enabled
    sprintf('Could not find fixed effects files.  Fixed effects disabled');
end
%________________________________________________
warning off MATLAB:deblank:NonStringInput
%________________________________________________
return


%________________________________________________
%________________________________________________
function [alternate_paradigm_names, alternate_paradigms_list] = wfu_get_alternate_paradigms(subjectdir)
alternate_paradigm_names = [];
alternate_paradigms_list = [];
alternate_dir='alternate_fixed';
alternate_dir = fullfile(subjectdir{1},alternate_dir);
if exist(alternate_dir,'dir')
    files   = dir(alternate_dir);
    for i = 1:length(files)
        if ~files(i).isdir
            file = fullfile(alternate_dir,files(i).name);
            [path,name,ext] = fileparts(file);
            if strcmp(ext,'.se_ref')
                alternate_paradigms_list{end+1} = file;
                reftext = wfu_read_refs(file);
                alternate_paradigm_names{end+1} = reftext{1}.paradigm_name;
            end
        end
    end
end
return
%________________________________________________
%________________________________________________

