function [epis,runs,pfiles] = wfu_get_epis(subjectdir,type,imglist)

%   Find 4D EPI analyze images based on the State flag of 
%   the info file
%   FORMAT [epis,runs,pfiles] = wfu_get_epis(subjectdir)
%   
%   runs        - number of runs (same as number of epis)
%   epis        - analyze/nifti (4D imgs)
%   pfiles	- reconstructed pfile
%   input       - when type='dir', input is a subject directory
%                 when type='plist', input is a structure 
%                 containing a field with pfile names and a field
%                 containing corresponding reference functions 
%   type        - 'dir' or 'plist', see above
%________________________________________________________________

epis    = {};
pfiles	= {};
if ~exist('plist'), plist=[]; end 
switch type
    case 'dir'
        files       = dir(subjectdir);
        for i = 1:length(files)
            if ~files(i).isdir
                file            = fullfile(subjectdir,files(i).name); 
                [path,name,ext] = fileparts(file);
                if strcmp(ext,'.info')
                    infotext = wfu_read_info(file);
                    if isfield(infotext,'State')
                        if infotext.State == 1
                            [epipath,epiname]   = fileparts(file); 
                            pfiles{end+1}         = fullfile(epipath,epiname); 
			    epi1 = fullfile(epipath,[epiname '.img']);
			    if ~exist(epi1,'file'), epi1 = fullfile(epipath,[epiname '_4D.img']); end;
			    epis{end+1}         = epi1;
                        end
                    end
                end
            end
        end
    case 'list'
        for i = 1:length(imglist.imgfiles)
            [p,n,e] = fileparts(imglist.imgfiles{i});
	    if isempty(p), p = subjectdir;  end
            if ~(strcmp(e,'.img') | strcmp(e,'.hdr') )
                epis{end+1} = fullfile(p,[n,e,'_4D.img']);
            else
		epis{end+1} = fullfile(p,[n,e]);
	    end
        end          
end

runs = length(epis);
