function refs = wfu_id_refs(epis) 

%   Find reference function for each pfile based on the .info 
%   file
%   FORMAT refs = wfu_id_refs(epis) 
%   
%   refs    - cell array of reference functions in their 
%             home directories
%             (example: /ansir1/abaer/er_attn/er_attn.se_ref)
%   epis    - cell array of pfile paths
%____________________________________________________________

for i = 1:length(epis)
    infofile    = [epis{i},'.info'];
    text        = wfu_read_info(infofile); 
    refnum      = text.fMRIParadigmNumber;
    if refnum
	refs{i}     = wfu_paradigm_lookup(refnum);
    else
	refs{i}  = '';
    end
end
