function [new,defaults] = wfu_merge_defaults(new,defaults)

if isfield(new,'fixedref')
    if new.fixedref
	%-----------------------------------------------------------------
	%Create event vector from individual run ids
	%conditions/event numbering needs to be cumulative from previous runs
	%-----------------------------------------------------------------
	fe_event_vector = [];
	conditions = 0;
	for r = 1:length(new.runids)
		if (isfield(defaults.refs{r},'events'))
			fe_event_vector = [fe_event_vector (defaults.refs{r}.events.num + conditions)];
		end
		conditions = conditions + defaults.refs{r}.conditions;
	end
	new.fe_event_vector = fe_event_vector;
	new.events.num = fe_event_vector;
	%new = wfu_permute_contrasts(new);
        if isfield(new,'time_derivative') && new.time_derivative == 1
            defaults.fixedeff.model.fmri_spec.bases.hrf.derivs(1) = 1;
        end
        
        if isfield(new,'dispersion_derivative') && new.dispersion_derivative == 1
            defaults.fixedeff.model.fmri_spec.bases.hrf.derivs(2) = 1;
        end        
    else
        
    end
else
    error('Reference function structure must contain the field ''fixedref'' to continue. See structure below'); 
    disp(new); 
end
return